/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice.fs.impl;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.lattice.fs.DLFSNode;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class DLFSFileAttributes
implements BasicFileAttributes {
    private AVector<ACell> node;

    public DLFSFileAttributes(AVector<ACell> node) {
        this.node = node;
    }

    public static DLFSFileAttributes create(AVector<ACell> node) {
        return new DLFSFileAttributes(node);
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.getFileTime();
    }

    protected FileTime getFileTime() {
        return FileTime.fromMillis(DLFSNode.getUTime(this.node).longValue());
    }

    @Override
    public FileTime lastAccessTime() {
        return null;
    }

    @Override
    public FileTime creationTime() {
        return null;
    }

    @Override
    public boolean isRegularFile() {
        return DLFSNode.isRegularFile(this.node);
    }

    @Override
    public boolean isDirectory() {
        return DLFSNode.isDirectory(this.node);
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isOther() {
        return DLFSNode.isTombstone(this.node);
    }

    @Override
    public long size() {
        ABlob blob = DLFSNode.getData(this.node);
        if (blob != null) {
            return blob.count();
        }
        return 0L;
    }

    @Override
    public Object fileKey() {
        return null;
    }
}

