/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice.fs.impl;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Index;
import convex.lattice.fs.DLFSNode;
import convex.lattice.fs.DLPath;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DLDirectoryStream
implements DirectoryStream<Path> {
    private Index<AString, AVector<ACell>> dirs;
    private DLPath base;

    public DLDirectoryStream(DLPath base, Index<AString, AVector<ACell>> dirs) {
        this.base = base;
        this.dirs = dirs;
    }

    @Override
    public void close() throws IOException {
    }

    public DIterator iterator() {
        return new DIterator();
    }

    public static DLDirectoryStream create(DLPath base, AVector<ACell> dirNode) {
        Index<AString, AVector<ACell>> dirs = DLFSNode.getDirectoryEntries(dirNode);
        if (dirs == null) {
            return null;
        }
        return new DLDirectoryStream(base, dirs);
    }

    public class DIterator
    implements Iterator<Path> {
        long pos = 0L;

        @Override
        public boolean hasNext() {
            return this.pos < DLDirectoryStream.this.dirs.count();
        }

        @Override
        public DLPath next() {
            if (this.pos >= DLDirectoryStream.this.dirs.count()) {
                throw new NoSuchElementException();
            }
            return DLDirectoryStream.this.base.resolve((AString)DLDirectoryStream.this.dirs.entryAt(this.pos++).getKey());
        }
    }
}

