/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice.fs;

import convex.core.data.AString;
import convex.core.data.StringShort;
import convex.core.util.Utils;
import convex.lattice.fs.DLFS;
import convex.lattice.fs.DLFileSystem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;

public final class DLPath
implements Path {
    protected final DLFileSystem fileSystem;
    protected final AString[] names;
    protected final boolean absolute;
    protected final int count;
    private String pathString = null;
    static final StringShort DOT = StringShort.create(".");
    static final StringShort SLASHDOT = StringShort.create("/.");
    static final StringShort DOTDOT = StringShort.create("..");
    static final AString[] EMPTY_STRINGS = new AString[0];
    static final Pattern endSlashes = Pattern.compile("/+$");

    protected DLPath(DLFileSystem fs) {
        this(fs, EMPTY_STRINGS, false);
    }

    protected DLPath(DLFileSystem fs, AString[] names, boolean absolute) {
        this.fileSystem = fs;
        this.names = names;
        this.absolute = absolute;
        this.count = names.length;
    }

    static DLPath createRoot(DLFileSystem fileSystem) {
        return new DLPath(fileSystem, EMPTY_STRINGS, true);
    }

    static DLPath create(DLFileSystem fs, String fullPath) {
        int ix;
        String path = fullPath;
        String sep = "/";
        if (path.isEmpty()) {
            throw new InvalidPathException(fullPath, "Empty path name");
        }
        boolean absolute = false;
        for (ix = 0; ix < path.length() && path.charAt(ix) == '/'; ++ix) {
        }
        if (ix > 0) {
            absolute = true;
            path = path.substring(ix);
        }
        if (path.endsWith(sep)) {
            path = endSlashes.matcher(path).replaceAll("/.");
        }
        String[] names = path.isEmpty() ? Utils.EMPTY_STRINGS : path.split(sep);
        int n = names.length;
        AString[] ns = new AString[n];
        for (int i = 0; i < n; ++i) {
            String name = names[i];
            AString cname = DLFS.checkName(name);
            if (cname == null) {
                throw new InvalidPathException(fullPath, "Invalid path name at position " + i);
            }
            ns[i] = cname;
        }
        return new DLPath(fs, ns, absolute);
    }

    @Override
    public DLFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public DLPath getRoot() {
        if (!this.absolute) {
            return null;
        }
        return this.fileSystem.getRoot();
    }

    @Override
    public DLPath getFileName() {
        if (this.count == 0) {
            return null;
        }
        if (!this.absolute & this.count == 1) {
            return this;
        }
        return new DLPath(this.fileSystem, new AString[]{this.names[this.count - 1]}, false);
    }

    @Override
    public DLPath getParent() {
        int n = this.getNameCount();
        if (n == 0) {
            return null;
        }
        return new DLPath(this.fileSystem, Arrays.copyOf(this.names, n - 1), this.absolute);
    }

    @Override
    public int getNameCount() {
        return this.count;
    }

    @Override
    public DLPath getName(int index) {
        int n = this.getNameCount();
        if (index < 0 || index >= n) {
            throw new IllegalArgumentException("index out of range");
        }
        if (!this.absolute & this.count == 1) {
            return this;
        }
        return new DLPath(this.fileSystem, new AString[]{this.names[index]}, false);
    }

    @Override
    public DLPath subpath(int beginIndex, int endIndex) {
        int n = this.getNameCount();
        if (beginIndex < 0 || endIndex > n) {
            throw new IllegalArgumentException("index out of range");
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("negative length");
        }
        if (beginIndex == endIndex) {
            return this.fileSystem.getEmptyPath();
        }
        if (!this.absolute && beginIndex == 0 && endIndex == n) {
            return this;
        }
        return new DLPath(this.fileSystem, Arrays.copyOfRange(this.names, beginIndex, endIndex), false);
    }

    public DLPath subpath(int beginIndex) {
        return this.subpath(beginIndex, this.count);
    }

    @Override
    public boolean startsWith(Path other) {
        if (!(other instanceof DLPath)) {
            return false;
        }
        return this.startsWith((DLPath)other);
    }

    public boolean startsWith(DLPath other) {
        if (this.absolute != other.absolute) {
            return false;
        }
        int n = other.getNameCount();
        if (n > this.count) {
            return false;
        }
        if (!this.fileSystem.equals(other.fileSystem)) {
            return false;
        }
        return Utils.arrayEquals(this.names, other.names, n);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other instanceof DLPath) {
            DLPath dlp = (DLPath)other;
            return this.endsWith(dlp);
        }
        return false;
    }

    public boolean endsWith(DLPath other) {
        if (this.absolute != other.absolute) {
            return false;
        }
        int n = other.getNameCount();
        if (n > this.count) {
            return false;
        }
        if (!this.fileSystem.equals(other.fileSystem)) {
            return false;
        }
        return Utils.arrayEquals(this.names, other.names, n);
    }

    @Override
    public DLPath normalize() {
        if (this.count == 0) {
            return this;
        }
        int j = 0;
        AString[] dest = this.names;
        block5: for (int i = 0; i < this.count; ++i) {
            AString c = this.names[i];
            int strategy = DOT.equals(c) ? 0 : (DOTDOT.equals(c) ? (this.absolute ? (j > 0 ? -1 : 0) : (j > 0 && !DOTDOT.equals(dest[j - 1]) ? -1 : 1)) : 1);
            switch (strategy) {
                case -1: {
                    if (dest == this.names) {
                        dest = (AString[])this.names.clone();
                    }
                    if (j <= 0) continue block5;
                    --j;
                    continue block5;
                }
                case 0: {
                    if (dest != this.names) continue block5;
                    dest = (AString[])this.names.clone();
                    continue block5;
                }
                case 1: {
                    if (dest != this.names) {
                        dest[j] = c;
                    }
                    ++j;
                }
            }
        }
        if (j == this.count) {
            return this;
        }
        if (dest.length > j) {
            dest = Arrays.copyOfRange(dest, 0, j);
        }
        return new DLPath(this.fileSystem, dest, this.absolute);
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        if (other.getNameCount() == 0) {
            return this;
        }
        AString[] newNames = Utils.concat(this.names, DLPath.extractNames(other));
        return new DLPath(this.fileSystem, newNames, this.absolute);
    }

    public DLPath resolve(AString nameToAppend) {
        AString name = DLFS.checkName(nameToAppend);
        if (name == null) {
            throw new InvalidPathException(nameToAppend.toString(), "Invalid path name: ");
        }
        AString[] newNames = Arrays.copyOf(this.names, this.count + 1);
        newNames[this.count] = name;
        return new DLPath(this.fileSystem, newNames, this.absolute);
    }

    private static AString[] extractNames(Path other) {
        if (other instanceof DLPath) {
            return ((DLPath)other).names;
        }
        return null;
    }

    @Override
    public DLPath relativize(Path other) {
        if (!(other instanceof DLPath)) {
            throw new IllegalArgumentException("Not a DLFS path");
        }
        return this.relativize((DLPath)other);
    }

    public DLPath relativize(DLPath other) {
        if (this.equals(other)) {
            return this.fileSystem.getEmptyPath();
        }
        if (this.absolute != other.isAbsolute()) {
            return null;
        }
        int extra = other.count - this.count;
        if (extra < 0) {
            return null;
        }
        for (int i = 0; i < this.count; ++i) {
            if (Objects.equals(this.names[i], other.names[i])) continue;
            return null;
        }
        AString[] newNames = Arrays.copyOfRange(other.names, this.count, this.count + extra);
        return new DLPath(this.fileSystem, newNames, false);
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.fileSystem.provider.getScheme(), this.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new Error("Invalid URI construction?", e);
        }
    }

    @Override
    public DLPath toAbsolutePath() {
        if (this.absolute) {
            return this;
        }
        return new DLPath(this.fileSystem, this.names, true);
    }

    @Override
    public DLPath toRealPath(LinkOption ... options) throws IOException {
        if (this.absolute) {
            return this;
        }
        return this.toAbsolutePath();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Path other) {
        if (!(other instanceof DLPath)) {
            throw new IllegalArgumentException("Not a data lattice path!");
        }
        return this.compareTo((DLPath)other);
    }

    @Override
    public int compareTo(DLPath other) {
        int n1 = this.getNameCount();
        int n2 = other.getNameCount();
        int n = Math.min(n1, n2);
        for (int i = 0; i < n; ++i) {
            int c = this.names[i].compareTo(other.names[i]);
            if (c == 0) continue;
            return c;
        }
        return n1 - n2;
    }

    @Override
    public String toString() {
        if (this.pathString != null) {
            return this.pathString;
        }
        CharSequence[] ns = this.getJavaNames();
        Object joined = String.join((CharSequence)"/", ns);
        if (this.absolute) {
            joined = "/" + (String)joined;
        }
        if (((String)joined).isEmpty()) {
            joined = ".";
        }
        this.pathString = joined;
        return joined;
    }

    protected String[] getJavaNames() {
        String[] ns = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            ns[i] = this.names[i].toString();
        }
        return ns;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DLPath)) {
            return false;
        }
        return this.equals((DLPath)other);
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(DLPath other) {
        if (this == other) {
            return true;
        }
        if (!other.fileSystem.equals(this.fileSystem)) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        return Arrays.equals(this.names, other.names);
    }

    public AString getCVMName(int i) {
        return this.names[i];
    }

    public AString getCVMFileName() {
        if (this.count == 0) {
            return null;
        }
        return this.names[this.count - 1];
    }
}

