/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice.fs;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AIndex;
import convex.core.data.ASequence;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Index;
import convex.core.data.MapEntry;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.util.MergeFunction;
import convex.core.util.Utils;
import convex.lattice.fs.DLPath;

public class DLFSNode {
    public static final long NODE_LENGTH = 4L;
    public static final int POS_DIR = 0;
    public static final int POS_DATA = 1;
    public static final int POS_METADATA = 2;
    public static final int POS_UTIME = 3;
    static final Index<AString, AVector<ACell>> EMPTY_CONTENTS = Index.none();
    static final Index<AString, AVector<ACell>> NIL_CONTENTS = null;
    static final Blob NIL_DATA = null;
    static final Blob EMPTY_DATA = Blob.EMPTY;
    static final ACell EMPTY_METADATA = null;
    static final CVMLong EMPTY_TIME = CVMLong.ZERO;
    private static final AVector<ACell> EMPTY_DIRECTORY = Vectors.of(EMPTY_CONTENTS, NIL_DATA, EMPTY_METADATA, EMPTY_TIME);
    private static final AVector<ACell> EMPTY_FILE = Vectors.of(NIL_CONTENTS, EMPTY_DATA, EMPTY_METADATA, EMPTY_TIME);
    private static final AVector<ACell> TOMBSTONE = Vectors.of(NIL_CONTENTS, NIL_DATA, EMPTY_METADATA, EMPTY_TIME);
    private static AVector<ACell> lastTombstone = TOMBSTONE;
    private static AVector<ACell> lastDirectory = EMPTY_DIRECTORY;
    private static AVector<ACell> lastEmptyFile = EMPTY_FILE;

    public static boolean isDirectory(AVector<ACell> node) {
        if (node == null) {
            return false;
        }
        return node.get(0) != null;
    }

    public static boolean isRegularFile(AVector<ACell> node) {
        if (node == null) {
            return false;
        }
        return node.get(1) instanceof ABlob;
    }

    public static AVector<ACell> navigate(AVector<ACell> node, DLPath path) {
        if (path == null) {
            return null;
        }
        int n = path.getNameCount();
        for (int i = 0; i < n; ++i) {
            AString compName = path.getCVMName(i);
            Index dir = (Index)node.get(0);
            if (dir == null) {
                return null;
            }
            AVector child = (AVector)dir.get(compName);
            if (child == null) {
                return null;
            }
            node = child;
        }
        return node;
    }

    public static Index<AString, AVector<ACell>> getDirectoryEntries(AVector<ACell> dirNode) {
        if (dirNode == null || dirNode.count() < 4L) {
            return null;
        }
        return (Index)dirNode.get(0);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AVector<ACell> updateNode(AVector<ACell> rootNode, DLPath path, AVector<ACell> newNode, CVMLong utime) {
        void var6_9;
        int n = path.getNameCount();
        if (n == 0) {
            return newNode;
        }
        if (!DLFSNode.isDirectory(rootNode)) {
            return null;
        }
        AString name = path.getCVMName(0);
        Index<AString, AVector<ACell>> index = DLFSNode.getDirectoryEntries(rootNode);
        AVector<ACell> childNode = index.get(name);
        if ((childNode = DLFSNode.updateNode(childNode, path.subpath(1), newNode, utime)) == null) {
            if (n != 1) return null;
            AIndex aIndex = index.dissoc((ABlobLike)name);
        } else {
            AIndex aIndex = index.assoc(name, childNode);
        }
        ASequence result = rootNode;
        result = ((AVector)result).assoc(0L, (ACell)var6_9);
        return ((AVector)result).assoc(3L, (ACell)utime);
    }

    public static ABlob getData(AVector<ACell> node) {
        return (ABlob)node.get(1);
    }

    public static Blob getMetaData(AVector<ACell> node) {
        return (Blob)node.get(2);
    }

    public static CVMLong getUTime(AVector<ACell> node) {
        return (CVMLong)node.get(3);
    }

    public static MapEntry<AString, AVector<ACell>> getDirectoryEntry(AVector<ACell> node, AString name) {
        Index<AString, AVector<ACell>> entries = DLFSNode.getDirectoryEntries(node);
        if (entries == null) {
            return null;
        }
        MapEntry<AString, AVector<ACell>> entry = entries.getEntry(name);
        return entry;
    }

    public static boolean isTombstone(AVector<ACell> node) {
        if (node == null) {
            return false;
        }
        return !DLFSNode.isDirectory(node) && !DLFSNode.isRegularFile(node);
    }

    public static AVector<ACell> createTombstone(CVMLong timestamp) {
        ASequence last = lastTombstone;
        lastTombstone = last = TOMBSTONE.assoc(3L, (ACell)timestamp);
        return last;
    }

    public static AVector<ACell> createDirectory(CVMLong timestamp) {
        ASequence last = lastDirectory;
        lastDirectory = last = EMPTY_DIRECTORY.assoc(3L, (ACell)timestamp);
        return last;
    }

    public static AVector<ACell> createEmptyFile(CVMLong timestamp) {
        ASequence last = lastEmptyFile;
        lastEmptyFile = last = EMPTY_FILE.assoc(3L, (ACell)timestamp);
        return last;
    }

    public static AVector<ACell> merge(AVector<ACell> a, AVector<ACell> b, final CVMLong time) {
        Index<AString, AVector<ACell>> contB;
        if (a.equals(b)) {
            return a;
        }
        CVMLong timeA = DLFSNode.getUTime(a);
        CVMLong timeB = DLFSNode.getUTime(b);
        Index<AString, AVector<ACell>> contA = DLFSNode.getDirectoryEntries(a);
        if (Utils.equals(contA, contB = DLFSNode.getDirectoryEntries(b)) && Utils.equals(DLFSNode.getData(a), DLFSNode.getData(b))) {
            return timeA.compareTo(timeB) >= 0 ? a : b;
        }
        if (contA != null && contB != null) {
            Index<AString, AVector<ACell>> mergedEntries = contA.mergeDifferences(contB, new MergeFunction<AVector<ACell>>(){

                @Override
                public AVector<ACell> merge(AVector<ACell> ca, AVector<ACell> cb) {
                    if (cb == null) {
                        return ca;
                    }
                    if (ca == null) {
                        return cb;
                    }
                    return DLFSNode.merge(ca, cb, time);
                }
            });
            if (contA == mergedEntries && timeA.longValue() >= time.longValue()) {
                return a;
            }
            ASequence result = DLFSNode.createDirectory(time);
            result = result.assoc(0L, (ACell)mergedEntries);
            return result;
        }
        AVector<ACell> result = timeA.longValue() >= timeB.longValue() ? a : b;
        return result;
    }
}

