/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice;

import convex.core.data.ACell;
import convex.lattice.ACursor;
import convex.lattice.AView;
import java.util.function.Function;

public class Transformer<S extends ACell, T extends ACell>
extends AView<T> {
    private final Function<S, T> transformFunction;

    public Transformer(ACursor<S> source, Function<S, T> transformFunction) {
        super(source);
        if (transformFunction == null) {
            throw new NullPointerException("Transform function cannot be null");
        }
        this.transformFunction = transformFunction;
    }

    @Override
    public T get() {
        Object sourceValue = this.source.get();
        return (T)((ACell)this.transformFunction.apply(sourceValue));
    }

    public Function<S, T> getTransformFunction() {
        return this.transformFunction;
    }

    public static <S extends ACell, T extends ACell> Transformer<S, T> create(ACursor<S> source, Function<S, T> transformFunction) {
        return new Transformer<S, T>(source, transformFunction);
    }

    public static <S extends ACell, T extends ACell, U extends ACell> Transformer<S, U> chain(ACursor<S> source, Function<S, T> firstTransform, Function<T, U> secondTransform) {
        if (firstTransform == null) {
            throw new NullPointerException("First transform function cannot be null");
        }
        if (secondTransform == null) {
            throw new NullPointerException("Second transform function cannot be null");
        }
        Function<S, U> combinedTransform = firstTransform.andThen(secondTransform);
        return new Transformer<S, U>(source, combinedTransform);
    }
}

