/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice;

import convex.core.data.ACell;
import convex.core.util.Utils;
import convex.lattice.ACachedView;
import convex.lattice.ACursor;

public class TimeCache<V extends ACell>
extends ACachedView<V> {
    private final long ttl;
    private volatile long lastUpdate = -1L;
    private volatile V value;

    protected TimeCache(ACursor<V> source, long timeToLive) {
        super(source);
        if (timeToLive < 0L) {
            throw new IllegalArgumentException("Time-to-live must be non-negative, got: " + timeToLive);
        }
        this.ttl = timeToLive;
    }

    @Override
    public V get() {
        long currentTime = Utils.getCurrentTimestamp();
        if (this.lastUpdate >= 0L) {
            boolean isValid = false;
            long expirationTime = this.lastUpdate + this.ttl;
            if (expirationTime < this.lastUpdate) {
                isValid = true;
            } else {
                boolean bl = isValid = currentTime < expirationTime;
            }
            if (isValid) {
                return this.value;
            }
        }
        Object freshValue = this.source.get();
        this.value = freshValue;
        this.lastUpdate = currentTime;
        return freshValue;
    }

    public long getTTL() {
        return this.ttl;
    }

    public long getLastUpdateTime() {
        return this.lastUpdate;
    }

    public boolean hasValidCache() {
        if (this.lastUpdate < 0L) {
            return false;
        }
        long currentTime = Utils.getCurrentTimestamp();
        if (this.ttl == Long.MAX_VALUE) {
            return true;
        }
        long expirationTime = this.lastUpdate + this.ttl;
        if (expirationTime < this.lastUpdate) {
            return true;
        }
        return currentTime < expirationTime;
    }

    public void invalidate() {
        this.lastUpdate = -1L;
        this.value = null;
    }
}

