/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice;

import convex.core.data.ACell;
import convex.core.lang.RT;
import convex.core.util.Utils;
import convex.lattice.ABranchedCursor;
import convex.lattice.ACursor;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public class PathCursor<V extends ACell>
extends ABranchedCursor<V> {
    ACursor<ACell> base;
    ACell[] path;

    public PathCursor(ACursor<?> base, ACell ... path) {
        super(base.get(path));
        this.base = base;
        this.path = path;
    }

    public static <T extends ACell, V extends ACell> PathCursor<T> create(ACursor<V> base, ACell[] path) {
        return new PathCursor<V>(base, path);
    }

    @Override
    public V get() {
        return (V)RT.getIn(this.base.get(), this.path);
    }

    @Override
    public void set(V newValue) {
        this.base.set(newValue, this.path);
    }

    @Override
    public V getAndSet(V newValue) {
        ACell oldBase = this.base.getAndUpdate(bv -> RT.assocIn(bv, newValue, this.path));
        return (V)RT.getIn(oldBase, this.path);
    }

    @Override
    public V getAndUpdate(UnaryOperator<V> updateFunction) {
        ACell oldBase = this.base.getAndUpdate(bv -> {
            Object oldValue = RT.getIn(bv, this.path);
            ACell newValue = (ACell)updateFunction.apply(oldValue);
            return RT.assocIn(bv, newValue, this.path);
        });
        return (V)RT.getIn(oldBase, this.path);
    }

    @Override
    public V updateAndGet(UnaryOperator<V> updateFunction) {
        ACell[] nv = new ACell[1];
        this.base.updateAndGet(bv -> {
            ACell newValue;
            Object oldValue = RT.getIn(bv, this.path);
            nv[0] = newValue = (ACell)updateFunction.apply(oldValue);
            return RT.assocIn(bv, newValue, this.path);
        });
        return (V)nv[0];
    }

    @Override
    public V getAndAccumulate(V x, BinaryOperator<V> accumulatorFunction) {
        ACell oldBase = this.base.getAndUpdate(bv -> {
            Object oldValue = RT.getIn(bv, this.path);
            ACell newValue = (ACell)accumulatorFunction.apply(x, oldValue);
            return RT.assocIn(bv, newValue, this.path);
        });
        return (V)RT.getIn(oldBase, this.path);
    }

    @Override
    public V accumulateAndGet(V x, BinaryOperator<V> accumulatorFunction) {
        ACell[] nv = new ACell[1];
        this.base.updateAndGet(bv -> {
            ACell newValue;
            Object oldValue = RT.getIn(bv, this.path);
            nv[0] = newValue = (ACell)accumulatorFunction.apply(x, oldValue);
            return RT.assocIn(bv, newValue, this.path);
        });
        return (V)nv[0];
    }

    @Override
    public boolean compareAndSet(V expected, V newValue) {
        boolean[] updated = new boolean[1];
        this.base.update(bv -> {
            Object oldValue = RT.getIn(bv, this.path);
            if (Utils.equals(expected, oldValue)) {
                updated[0] = true;
                return RT.assocIn(bv, newValue, this.path);
            }
            return bv;
        });
        return updated[0];
    }
}

