/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice;

import convex.core.data.ACell;
import convex.core.lang.RT;
import convex.lattice.ABranchedCursor;
import convex.lattice.Root;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public abstract class ACursor<V extends ACell> {
    protected ACursor() {
    }

    public abstract V get();

    public V get(ACell ... path) {
        return (V)RT.getIn(this.get(), path);
    }

    public V get(Object ... path) {
        return (V)RT.getIn(this.get(), path);
    }

    public <T extends ACell> void set(T newValue, ACell ... path) {
        this.getAndUpdate(bv -> RT.assocIn(bv, newValue, path));
    }

    public <T extends ACell> void set(T newValue, Object ... path) {
        this.getAndUpdate(bv -> RT.assocIn(bv, newValue, path));
    }

    public abstract V getAndSet(V var1);

    public abstract boolean compareAndSet(V var1, V var2);

    public abstract void set(V var1);

    public void set(Object o) {
        if (o instanceof ACell) {
            ACell cell = (ACell)o;
            this.set((V)cell);
        } else {
            this.set((V)RT.cvm(o));
        }
    }

    public abstract V getAndUpdate(UnaryOperator<V> var1);

    public abstract V updateAndGet(UnaryOperator<V> var1);

    public void update(UnaryOperator<V> updateFunction) {
        this.getAndUpdate(updateFunction);
    }

    public abstract V getAndAccumulate(V var1, BinaryOperator<V> var2);

    public abstract V accumulateAndGet(V var1, BinaryOperator<V> var2);

    public String toString() {
        V v = this.get();
        if (v == null) {
            return "nil";
        }
        return ((ACell)v).toString();
    }

    public abstract <T extends ACell> ACursor<T> path(ACell ... var1);

    public <T extends ACell> ABranchedCursor<T> detach() {
        return Root.create(this.get());
    }
}

