/*
 * Decompiled with CFR 0.152.
 */
package convex.lattice;

import convex.core.data.ACell;
import convex.lattice.ACursor;
import convex.lattice.PathCursor;

public abstract class ABranchedCursor<V extends ACell>
extends ACursor<V> {
    private final V initialValue;

    protected ABranchedCursor(V value) {
        this.initialValue = value;
    }

    public V getInitialValue() {
        return this.initialValue;
    }

    public boolean sync(ABranchedCursor<V> detached) {
        Object newValue = detached.get();
        V detachedValue = detached.getInitialValue();
        boolean updated = this.compareAndSet(detachedValue, newValue);
        return updated;
    }

    @Override
    public <T extends ACell> ABranchedCursor<T> path(ACell ... path) {
        if (path.length == 0) {
            return this;
        }
        return PathCursor.create(this, path);
    }
}

