/*
 * Decompiled with CFR 0.152.
 */
package convex.etch;

import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.RefSoft;
import convex.core.store.ACachedStore;
import convex.core.util.FileUtils;
import convex.core.util.Utils;
import convex.etch.Etch;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.function.Consumer;

public class EtchStore
extends ACachedStore {
    private Etch etch;
    private Etch target;

    public EtchStore(Etch etch) {
        this.etch = etch;
        this.target = null;
        etch.setStore(this);
    }

    public synchronized void startGC() throws IOException {
        if (this.target != null) {
            throw new Error("Already collecting!");
        }
        File temp = new File(this.etch.getFile().getCanonicalPath() + "~");
        this.target = Etch.create(temp);
        this.target.setRootHash(this.etch.getRootHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Etch getWriteEtch() {
        if (this.target != null) {
            EtchStore etchStore = this;
            synchronized (etchStore) {
                if (this.target != null) {
                    return this.target;
                }
            }
        }
        return this.etch;
    }

    public static EtchStore create(File file) throws IOException {
        file = FileUtils.ensureFilePath(file);
        Etch etch = Etch.create(file);
        return new EtchStore(etch);
    }

    public static EtchStore createTemp(String prefix) throws IOException {
        Etch etch = Etch.createTempEtch(prefix);
        return new EtchStore(etch);
    }

    public static EtchStore createTemp() throws IOException {
        Etch etch = Etch.createTempEtch();
        return new EtchStore(etch);
    }

    @Override
    public <T extends ACell> Ref<T> refForHash(Hash hash) {
        try {
            Ref existing = this.checkCache(hash);
            if (existing != null) {
                return existing;
            }
            if (hash == Hash.NULL_HASH) {
                return Ref.NULL_VALUE;
            }
            existing = this.readStoreRef(hash);
            return existing;
        }
        catch (ClosedChannelException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public <T extends ACell> Ref<T> readStoreRef(Hash hash) throws IOException {
        RefSoft ref = this.etch.read(hash);
        if (ref != null) {
            this.refCache.putCell(ref);
        }
        return ref;
    }

    @Override
    public <T extends ACell> Ref<T> storeRef(Ref<T> ref, int status, Consumer<Ref<ACell>> noveltyHandler) throws IOException {
        return this.storeRef(ref, status, noveltyHandler, false);
    }

    @Override
    public <T extends ACell> Ref<T> storeTopRef(Ref<T> ref, int status, Consumer<Ref<ACell>> noveltyHandler) throws IOException {
        return this.storeRef(ref, status, noveltyHandler, true);
    }

    public <T extends ACell> Ref<T> storeRef(Ref<T> ref, int requiredStatus, Consumer<Ref<ACell>> noveltyHandler, boolean topLevel) throws IOException {
        IRefFunction func;
        ACell newObject;
        Ref<T> existing;
        Object cell = ref.getValue();
        if (cell == null) {
            return Ref.NULL_VALUE;
        }
        boolean embedded = ((ACell)cell).isEmbedded();
        Hash hash = null;
        if (!embedded && (existing = this.refForHash(hash = ref.getHash())) != null && existing.getStatus() >= requiredStatus) {
            return existing;
        }
        if (requiredStatus < 1) {
            if (topLevel || !embedded) {
                this.addToCache(ref);
            }
            return ref;
        }
        if (requiredStatus > 1 && ((ACell)cell).getRefCount() > 0 && cell != (newObject = ((ACell)cell).updateRefs(func = r -> {
            try {
                return this.storeRef(r, requiredStatus, noveltyHandler, false);
            }
            catch (IOException e) {
                throw (RuntimeException)Utils.sneakyThrow(e);
            }
        }))) {
            ref = ref.withValue(newObject);
            cell = newObject;
        }
        if (topLevel || !embedded) {
            Hash fHash = hash != null ? hash : ref.getHash();
            ref = ref.withMinimumStatus(requiredStatus);
            ref = this.etch.write(fHash, ref);
            if (!embedded) {
                ref = ref.toSoft(this);
            }
            ((ACell)cell).attachRef(ref);
            this.addToCache(ref);
            if (noveltyHandler != null && !embedded) {
                noveltyHandler.accept(ref);
            }
        } else {
            ref = ref.withMinimumStatus(requiredStatus);
        }
        ((ACell)cell).attachRef(ref);
        return ref;
    }

    protected <T extends ACell> void addToCache(Ref<T> ref) {
        this.refCache.putCell(ref);
    }

    public String toString() {
        try {
            return "EtchStore: " + this.getFile().getCanonicalPath();
        }
        catch (IOException e) {
            return "EtchStore: <File name lookup failed>";
        }
    }

    public String getFileName() {
        return this.etch.getFileName();
    }

    @Override
    public void close() {
        this.etch.close();
    }

    public void flush() throws IOException {
        this.etch.flush();
        Etch target = this.target;
        if (target != null) {
            target.flush();
        }
    }

    public File getFile() {
        return this.etch.getFile();
    }

    @Override
    public Hash getRootHash() throws IOException {
        return this.getWriteEtch().getRootHash();
    }

    @Override
    public <T extends ACell> Ref<T> setRootData(T data) throws IOException {
        Ref<T> ref = this.storeTopRef(Ref.get(data), 3, null);
        Hash h = Hash.get(data);
        Etch etch = this.getWriteEtch();
        etch.setRootHash(h);
        etch.writeDataLength();
        return ref;
    }

    public Etch getEtch() {
        return this.etch;
    }

    @Override
    public String shortName() {
        return "Etch: " + this.etch.getFileName();
    }
}

