/*
 * Decompiled with CFR 0.152.
 */
package convex.did;

import convex.core.data.AString;
import convex.core.data.Strings;
import convex.did.DID;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class DIDURL {
    final DID did;
    final String path;
    final String query;
    final String fragment;
    private volatile AString aStringCache = null;

    public DIDURL(DID did, String path, String query, String fragment) {
        this.did = did;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    public DIDURL(DID did) {
        this(did, null, null, null);
    }

    public static DIDURL create(String didURL) {
        return DIDURL.create(URI.create(didURL));
    }

    public static DIDURL create(DID did) {
        return new DIDURL(did);
    }

    private static DIDURL create(URI uri) {
        int ppos;
        DID did = DID.fromURI(uri);
        String path = null;
        String query = null;
        String fragment = uri.getFragment();
        String ssp = uri.getRawSchemeSpecificPart();
        int qpos = ssp.indexOf(63);
        if (qpos >= 0) {
            query = URLDecoder.decode(ssp.substring(qpos + 1), StandardCharsets.UTF_8);
            ssp = ssp.substring(0, qpos);
        }
        if ((ppos = ssp.indexOf(47)) >= 0) {
            path = ssp.substring(ppos);
            ssp = ssp.substring(0, ppos);
        }
        return new DIDURL(did, path, query, fragment);
    }

    public DIDURL withPath(String newPath) {
        return new DIDURL(this.did, newPath, this.query, this.fragment);
    }

    public DIDURL withQuery(String newQuery) {
        return new DIDURL(this.did, this.path, newQuery, this.fragment);
    }

    public DIDURL withFragment(String newFragment) {
        return new DIDURL(this.did, this.path, this.query, newFragment);
    }

    public DIDURL withDID(DID newDID) {
        return new DIDURL(newDID, this.path, this.query, this.fragment);
    }

    public DID getDID() {
        return this.did;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DIDURL didurl = (DIDURL)obj;
        return Objects.equals(this.did, didurl.did) && Objects.equals(this.path, didurl.path) && Objects.equals(this.query, didurl.query) && Objects.equals(this.fragment, didurl.fragment);
    }

    public int hashCode() {
        return Objects.hash(this.did, this.path, this.query, this.fragment);
    }

    public String toString() {
        Object result = this.did.toString();
        if (this.path != null) {
            result = (String)result + this.path;
        }
        if (this.query != null) {
            result = (String)result + "?" + URLEncoder.encode(this.query, StandardCharsets.UTF_8);
        }
        if (this.fragment != null) {
            result = (String)result + "#" + URLEncoder.encode(this.fragment, StandardCharsets.UTF_8);
        }
        return result;
    }

    public AString toAString() {
        AString result = this.aStringCache;
        this.aStringCache = result = Strings.create(this.toString());
        return result;
    }
}

