/*
 * Decompiled with CFR 0.152.
 */
package convex.did;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class DID {
    private static final String URI_SCHEME = "did";
    private static final String DID_START = "did:";
    private final String method;
    private final String id;

    public DID(String method, String id) {
        if (method == null) {
            throw new IllegalArgumentException("DID method cannot be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("DID id cannot be null");
        }
        this.method = method;
        this.id = id;
    }

    public static DID fromURI(URI uri) {
        int slashPos;
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        String scheme = uri.getScheme();
        if (!URI_SCHEME.equals(scheme)) {
            throw new IllegalArgumentException("DID must start with 'did:' URI scheme");
        }
        String ssp = uri.getRawSchemeSpecificPart();
        int methodColon = ssp.indexOf(58);
        if (methodColon < 0) {
            throw new IllegalArgumentException("DID must start with 'did:<method>:<id>'");
        }
        String method = ssp.substring(0, methodColon);
        if (method.isEmpty()) {
            throw new IllegalArgumentException("DID must have non-empty method");
        }
        String id = ssp.substring(methodColon + 1);
        int queryPos = id.indexOf(63);
        if (queryPos >= 0) {
            id = id.substring(0, queryPos);
        }
        if ((slashPos = id.indexOf(47)) >= 0) {
            id = id.substring(0, slashPos);
        }
        id = URLDecoder.decode(id, StandardCharsets.UTF_8);
        return new DID(method, id);
    }

    public static DID fromString(String didString) {
        return DID.fromURI(URI.create(didString));
    }

    public String getMethod() {
        return this.method;
    }

    public String getID() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DID) {
            DID other = (DID)obj;
            return this.method.equals(other.method) && this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return DID_START + this.method + ":" + URLEncoder.encode(this.id, StandardCharsets.UTF_8);
    }

    public static DID create(String method, String id) {
        return new DID(method, id);
    }

    public DID withPath(String string) {
        return null;
    }
}

