/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.data.ACell;
import convex.core.data.AObject;
import convex.core.data.ASequence;
import convex.core.data.AString;
import convex.core.data.Hash;
import convex.core.data.Strings;
import convex.core.data.prim.AInteger;
import convex.core.lang.RT;
import convex.core.util.Bits;
import convex.core.util.ErrorMessages;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Utils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final long startupTimestamp = Utils.getCurrentTimestamp();
    private static final long startupNanos = System.nanoTime();
    public static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final char[] EMPTY_CHARS = new char[0];
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final Hash[] EMPTY_HASHES = new Hash[0];
    private static final long LONG_HIGH_BIT = Long.MIN_VALUE;
    private static Path homePath = null;
    static String version = null;

    public static String toHexString(int val) {
        char[] chars = new char[8];
        for (int i = 0; i < 8; ++i) {
            chars[i] = Utils.toHexChar(val >> (7 - i) * 4 & 0xF);
        }
        return new String(chars);
    }

    public static String toHexString(short val) {
        char[] chars = new char[4];
        for (int i = 0; i < 4; ++i) {
            chars[i] = Utils.toHexChar(val >> (3 - i) * 4 & 0xF);
        }
        return new String(chars);
    }

    public static String toHexString(byte value) {
        char[] chars = new char[]{Utils.toHexChar((value & 0xF0) >>> 4), Utils.toHexChar(value & 0xF)};
        return new String(chars);
    }

    public static String toHexString(long x) {
        char[] chars = new char[16];
        for (int i = 0; i < 16; ++i) {
            chars[i] = Utils.toHexChar((int)(x >> 4 * (15 - i)) & 0xF);
        }
        return new String(chars);
    }

    public static int readInt(byte[] data, int offset) {
        int result = data[offset];
        for (int i = 1; i <= 3; ++i) {
            result = (result << 8) + (data[offset + i] & 0xFF);
        }
        return result;
    }

    public static int readIntZeroExtend(byte[] data, int offset) {
        int result = data[offset];
        for (int i = 1; i <= 3; ++i) {
            int ix = offset + i;
            result = (result << 8) + (ix < data.length ? data[offset + i] & 0xFF : 0);
        }
        return result;
    }

    public static long readLong(byte[] data, int offset, int numBytes) {
        long result = data[offset];
        for (int i = 1; i < numBytes; ++i) {
            result = (result << 8) + (long)(data[offset + i] & 0xFF);
        }
        return result;
    }

    public static short readShort(byte[] data, int offset) {
        int result = ((data[offset] & 0xFF) << 8) + (data[offset + 1] & 0xFF);
        return (short)result;
    }

    public static int writeChar(byte[] data, int offset, char value) {
        data[offset++] = (byte)(value >> 8);
        data[offset++] = (byte)value;
        return offset;
    }

    public static int writeShort(byte[] data, int offset, short value) {
        data[offset++] = (byte)(value >> 8);
        data[offset++] = (byte)value;
        return offset;
    }

    public static int writeInt(byte[] data, int offset, int value) {
        for (int i = 0; i <= 3; ++i) {
            data[offset + i] = (byte)(value >> 8 * (3 - i) & 0xFF);
        }
        return offset + 4;
    }

    public static int writeLong(byte[] data, int offset, long value) {
        for (int i = 0; i <= 7; ++i) {
            data[offset + i] = (byte)(value >> 8 * (7 - i));
        }
        return offset + 8;
    }

    public static byte[] toByteArray(ByteBuffer bb) {
        int len = bb.remaining();
        byte[] bytes = new byte[len];
        bb.get(bytes);
        return bytes;
    }

    public static char toHexChar(int i) {
        if (i >= 0) {
            if (i <= 9) {
                return (char)(i + 48);
            }
            if (i <= 15) {
                return (char)(i + 87);
            }
        }
        throw new IllegalArgumentException("Unable to convert to single hex char: " + i);
    }

    public static byte[] hexToBytes(String hex) {
        byte[] bs = Utils.hexToBytes(hex, hex.length());
        return bs;
    }

    public static byte[] hexToBytes(String hex, int hexLength) {
        if (hex.length() < hexLength) {
            return null;
        }
        int N = hexLength / 2;
        if (N * 2 != hexLength) {
            return null;
        }
        byte[] result = new byte[N];
        for (int i = 0; i < N; ++i) {
            char high = hex.charAt(2 * i);
            char low = hex.charAt(2 * i + 1);
            int lowD = Utils.hexVal(low);
            if (lowD < 0) {
                return null;
            }
            int highD = Utils.hexVal(high);
            if (highD < 0) {
                return null;
            }
            result[i] = (byte)(highD * 16 + lowD);
        }
        return result;
    }

    public static BigInteger hexToBigInt(String hex) {
        return new BigInteger(1, Utils.hexToBytes(hex));
    }

    public static int hexVal(char c) {
        char v = c;
        if (v < '0' || v > 'f') {
            return -1;
        }
        if (v >= 'a') {
            return v - 87;
        }
        if (v <= '9') {
            return v - 48;
        }
        if (v >= 'A' && v <= 'F') {
            return v - 55;
        }
        return -1;
    }

    public static int octalVal(char c) {
        char v = c;
        if (v < '0' || v > '7') {
            return -1;
        }
        return v - 48;
    }

    public static String toHexString(byte[] data) {
        return Utils.toHexString(data, 0, data.length);
    }

    public static String toHexString(byte[] data, int offset, int length) {
        char[] hexDigits = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int v = data[i + offset] & 0xFF;
            hexDigits[i * 2] = Utils.toHexChar(v >>> 4);
            hexDigits[i * 2 + 1] = Utils.toHexChar(v & 0xF);
        }
        return new String(hexDigits);
    }

    public static int hashCode(Object a) {
        if (a == null) {
            return 0;
        }
        return a.hashCode();
    }

    public static boolean arrayEquals(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        if (a == b && aOffset == bOffset) {
            return true;
        }
        return Arrays.equals(a, aOffset, aOffset + length, b, bOffset, bOffset + length);
    }

    public static <T> boolean arrayEquals(T[] a, T[] b, int n) {
        for (int i = 0; i < n; ++i) {
            if (Utils.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static int compareByteArrays(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        for (int i = 0; i < length; ++i) {
            int ai = 0xFF & a[aOffset + i];
            int bi = 0xFF & b[bOffset + i];
            if (ai < bi) {
                return -1;
            }
            if (ai <= bi) continue;
            return 1;
        }
        return 0;
    }

    public static String toHexString(BigInteger a, int digits) {
        if (a.signum() < 0) {
            throw new IllegalArgumentException("toHexString requires a non-negative BigInteger, got :" + String.valueOf(a));
        }
        String s = a.toString(16);
        int slen = s.length();
        if (slen > digits) {
            throw new IllegalArgumentException("toHexString number of digits exceeded, got :" + slen);
        }
        if (slen == digits) {
            return s;
        }
        StringBuffer sb = new StringBuffer(digits);
        while (slen < digits) {
            sb.append('0');
            ++slen;
        }
        sb.append(s);
        return sb.toString();
    }

    public static byte[] toByteArray(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static Object[] toObjectArray(Object anyArray) {
        if (anyArray instanceof Object[]) {
            return (Object[])anyArray;
        }
        int n = Array.getLength(anyArray);
        Object[] result = new Object[n];
        for (int i = 0; i < n; ++i) {
            result[i] = Array.get(anyArray, i);
        }
        return result;
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equals(ACell a, ACell b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static Class<?> getClass(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass();
    }

    public static String getClassName(Object o) {
        Class<?> klass = Utils.getClass(o);
        return klass == null ? "null" : klass.getName();
    }

    public static int checkedInt(long a) {
        int i = (int)a;
        if (a != (long)i) {
            throw new IllegalArgumentException(ErrorMessages.sizeOutOfRange(a));
        }
        return i;
    }

    public static long checkedLong(double d) {
        long l = (long)d;
        if ((double)l != d) {
            throw new IllegalArgumentException("Double is not an exact long value");
        }
        return l;
    }

    public static long checkedLong(BigInteger p) {
        return p.longValueExact();
    }

    public static short checkedShort(long a) {
        short s = (short)a;
        if ((long)s != a) {
            throw new IllegalArgumentException(ErrorMessages.sizeOutOfRange(a));
        }
        return s;
    }

    public static byte checkedByte(long a) {
        byte b = (byte)a;
        if ((long)b != a) {
            throw new IllegalArgumentException(ErrorMessages.sizeOutOfRange(a));
        }
        return b;
    }

    public static ByteBuffer writeUInt256(ByteBuffer b, BigInteger v) {
        if (v.signum() < 0) {
            throw new IllegalArgumentException("Non-negative integer expected");
        }
        byte[] bs = v.toByteArray();
        byte[] buf = new byte[32];
        int blen = bs.length;
        if (blen <= 32) {
            System.arraycopy(bs, 0, buf, 32 - blen, blen);
        } else if (blen == 33 && bs[0] == 0) {
            System.arraycopy(bs, blen - 32, buf, 0, 32);
        } else {
            throw new IllegalArgumentException("BigInteger too large for UInt256, length in bytes=" + blen);
        }
        return b.put(buf);
    }

    public static BigInteger readUInt256(ByteBuffer b) {
        byte[] buf = new byte[32];
        b.get(buf);
        return new BigInteger(1, buf);
    }

    public static int bitLength(long x) {
        long ux = x >= 0L ? x : -x - 1L;
        return 1 + (64 - Bits.leadingZeros(ux));
    }

    public static int byteLength(long x) {
        long ux = x >= 0L ? x : -x - 1L;
        int bits = 64 - Bits.leadingZeros(ux);
        return 1 + bits / 8;
    }

    public static int byteLength(BigInteger bi) {
        return bi.bitLength() / 8 + 1;
    }

    public static int toInt(Object v) {
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            try {
                return Integer.parseInt((String)v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("String cannot be converted to an integer");
            }
        }
        if (v instanceof ACell) {
            AInteger cv = AInteger.parse(v);
            if (cv == null) {
                throw new IllegalArgumentException("Cell not a integer numeric value: " + String.valueOf(v));
            }
            Integer result = (int)cv.longValue();
            if ((double)result.longValue() == cv.doubleValue()) {
                return result;
            }
            throw new IllegalArgumentException("CVM numeric value not in Java Integer range");
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            int value = (int)number.longValue();
            if ((double)value != number.doubleValue()) {
                throw new IllegalArgumentException("Cannot coerce to int without loss:");
            }
            return value;
        }
        throw new IllegalArgumentException("Can't convert to int: " + String.valueOf(v));
    }

    public static long toLong(Object v) {
        if (v instanceof Long) {
            Long l = (Long)v;
            return l;
        }
        if (v instanceof String) {
            try {
                return Long.parseLong((String)v);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("String cannot be converted to a Long");
            }
        }
        if (v instanceof ACell) {
            AInteger cv = AInteger.parse(v);
            if (cv == null) {
                throw new IllegalArgumentException("Cell not a integer numeric value: " + String.valueOf(v));
            }
            return cv.longValue();
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            long value = number.longValue();
            if ((double)value != number.doubleValue()) {
                throw new IllegalArgumentException("Cannot coerce to long without loss:");
            }
            return value;
        }
        throw new IllegalArgumentException("Can't convert to int: " + String.valueOf(v));
    }

    public static String readResourceAsString(String path) throws IOException {
        try (InputStream inputStream = Utils.getResourceAsStream(path);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return string;
        }
    }

    public static AString readResourceAsAString(String path) throws IOException {
        return Strings.fromStream(Utils.getResourceAsStream(path));
    }

    public static InputStream getResourceAsStream(String path) throws IOException {
        InputStream inputStream = Utils.class.getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + path);
        }
        return inputStream;
    }

    public static String readString(InputStream inputStream) throws IOException {
        byte[] bytes = inputStream.readAllBytes();
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static int extractBits(byte[] bs, int numBits, int shift) {
        if (numBits <= 0) {
            return 0;
        }
        if (numBits > 32) {
            throw new IllegalArgumentException("Invalid number of bits: " + numBits);
        }
        if (numBits > 8) {
            return Utils.extractBits(bs, 8, shift) | Utils.extractBits(bs, numBits - 8, shift + 8) << 8;
        }
        if (shift < 0) {
            int end = Utils.extractBits(bs, numBits + shift, 0);
            return end << -shift;
        }
        int bshift = shift >> 3;
        int bslen = bs.length;
        if (bshift >= bslen) {
            return (bs[0] >= 0 ? 0 : -1) & Bits.lowBitMask(numBits);
        }
        int lowShift = shift - (bshift << 3);
        int ix = bslen - bshift - 1;
        int val = bs[ix];
        if (ix > 0) {
            val &= 0xFF;
            val |= bs[ix - 1] << 8;
        }
        return (val >>= lowShift) & Bits.lowBitMask(numBits);
    }

    public static void setBits(byte[] bs, int numBits, int shift, int bits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Invalid number of bits: " + numBits);
        }
        if (shift < 0) {
            if ((numBits += shift) <= 0) {
                return;
            }
            Utils.setBits(bs, numBits, 0, bits >> -shift);
            return;
        }
        if (numBits > 8) {
            Utils.setBits(bs, 8, shift, bits);
            Utils.setBits(bs, numBits - 8, shift + 8, bits >> 8);
            return;
        }
        int bshift = shift >> 3;
        int bslen = bs.length;
        if (bshift >= bslen) {
            return;
        }
        int ix = bslen - bshift - 1;
        int lowShift = shift - (bshift << 3);
        int lowBitMask = Bits.lowBitMask(numBits);
        int val = (bits & lowBitMask) << lowShift;
        int keepBitMask = ~(lowBitMask << lowShift);
        int keep = bs[ix] & 0xFF;
        if (ix > 0) {
            keep |= (bs[ix - 1] & 0xFF) << 8;
        }
        bs[ix] = (byte)((val |= (keep &= keepBitMask)) & 0xFF);
        if (ix > 0) {
            bs[ix - 1] = (byte)(val >> 8 & 0xFF);
        }
    }

    public static String print(Object v) {
        StringBuilder sb = new StringBuilder();
        Utils.print(sb, v);
        return sb.toString();
    }

    public static void print(StringBuilder sb, Object v) {
        if (v == null) {
            sb.append("nil");
        } else if (v instanceof AObject) {
            sb.append(((AObject)v).print());
        } else if (v instanceof Boolean || v instanceof Number) {
            sb.append(v.toString());
        } else if (v instanceof String) {
            sb.append('\"');
            sb.append((String)v);
            sb.append('\"');
        } else if (v instanceof Instant) {
            sb.append(((Instant)v).toEpochMilli());
        } else if (v instanceof Character) {
            sb.append(((Character)v).toString());
        } else {
            throw new IllegalArgumentException("Can't print: " + String.valueOf(Utils.getClass(v)));
        }
    }

    public static int longStringSize(long x) {
        int d = 1;
        if (x >= 0L) {
            d = 0;
            x = -x;
        }
        long p = -10L;
        for (int i = 1; i < 19; ++i) {
            if (x > p) {
                return i + d;
            }
            p = 10L * p;
        }
        return 19 + d;
    }

    public static <T> ArrayList<T> sortListBy(Function<T, Long> scorer, Collection<T> coll) {
        ArrayList<T> result = new ArrayList<T>(coll.size());
        final HashMap<T, Long> scores = new HashMap<T, Long>(coll.size());
        for (T c : coll) {
            Long score = scorer.apply(c);
            if (score == null) continue;
            scores.put(c, score);
            result.add(c);
        }
        result.sort(new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                long comp = (Long)scores.get(a) - (Long)scores.get(b);
                return Long.signum(comp);
            }
        });
        return result;
    }

    public static <T> short computeMask(T[] set, T[] subset) {
        int n = set.length;
        if (n > 16) {
            throw new IllegalArgumentException("Max length of 16 for mask computation, got: " + n);
        }
        int mask = 0;
        int ix = 0;
        int subsetLength = subset.length;
        for (int i = 0; i < n && ix != subsetLength; ++i) {
            if (set[i] != subset[ix]) continue;
            mask |= 1 << i;
            ++ix;
        }
        if (ix != subsetLength) {
            throw new IllegalArgumentException("Subset not all found");
        }
        return (short)mask;
    }

    public static <T extends Throwable> T sneakyThrow(Throwable t) throws T {
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw t;
    }

    public static <T> T[] copyOfRangeExcludeNulls(T[] entries, int offset, int length) {
        int newLen = length;
        for (int i = 0; i < length; ++i) {
            if (entries[offset + i] != null) continue;
            --newLen;
        }
        if (newLen < length) {
            Object[] result = (Object[])Array.newInstance(entries.getClass().getComponentType(), newLen);
            int ix = 0;
            for (int i = 0; i < length; ++i) {
                T v = entries[offset + i];
                if (v == null) continue;
                result[ix++] = v;
            }
            assert (ix == newLen);
            return result;
        }
        return Arrays.copyOfRange(entries, offset, offset + length);
    }

    public static <T> void reverse(T[] arr) {
        Utils.reverse(arr, arr.length);
    }

    public static <T> void reverse(T[] arr, int n) {
        for (int i = 0; i < n / 2; ++i) {
            T val = arr[i];
            arr[i] = arr[n - i - 1];
            arr[n - i - 1] = val;
        }
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((bytesRead = is.read(buf)) >= 0) {
            bos.write(buf, 0, bytesRead);
        }
        return bos.toByteArray();
    }

    public static boolean isOdd(long x) {
        return (x & 1L) != 0L;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "nil";
        }
        return o.toString();
    }

    public static String stripWhiteSpace(String s) {
        return s.replaceAll("\\s+", "");
    }

    public static int bitCount(short mask) {
        return Integer.bitCount(mask & 0xFFFF);
    }

    public static boolean timeout(int timeoutMillis, Supplier<Boolean> test) throws InterruptedException {
        long start = Utils.getTimeMillis();
        long end = start + (long)timeoutMillis;
        long now = start;
        while (!test.get().booleanValue()) {
            long nextInterval = (long)((double)(now - start) * 0.3 + 1.0);
            long sleepTime = Math.min(nextInterval, end - now);
            if (sleepTime < 0L) {
                return true;
            }
            Thread.sleep(sleepTime);
            now = Utils.getTimeMillis();
        }
        return false;
    }

    public static long getCurrentTimestamp() {
        return Instant.now().toEpochMilli();
    }

    public static long getTimeMillis() {
        long elapsedMillis = (System.nanoTime() - startupNanos) / 1000000L;
        return startupTimestamp + elapsedMillis;
    }

    public static boolean firstDigitMatch(byte a, byte b) {
        return (a & 0xF0) == (b & 0xF0);
    }

    public static <T extends ACell, U> T binarySearchLeftmost(ASequence<T> L, Function<? super T, U> value, Comparator<U> comparator, U target) {
        long min = 0L;
        long max = L.count();
        while (min < max) {
            long midpoint = (min + max) / 2L;
            if (comparator.compare(value.apply(L.get(midpoint)), target) < 0) {
                min = midpoint + 1L;
                continue;
            }
            max = midpoint;
        }
        if (min < L.count() && comparator.compare(value.apply(L.get(min)), target) == 0) {
            return L.get(min);
        }
        if (min - 1L == -1L) {
            return null;
        }
        return L.get(min - 1L);
    }

    public static <T extends ACell, U> long binarySearch(ASequence<T> data, Function<? super T, U> value, Comparator<U> comparator, U target) {
        long min = 0L;
        long max = data.count();
        while (min < max) {
            long midPoint = (min + max) / 2L;
            U midVal = value.apply(data.get(midPoint));
            if (comparator.compare(midVal, target) < 0) {
                min = midPoint + 1L;
                continue;
            }
            max = midPoint;
        }
        return min;
    }

    public static boolean bool(Object a) {
        if (a == null) {
            return false;
        }
        if (a instanceof ACell) {
            return RT.bool((ACell)a);
        }
        if (a instanceof Boolean) {
            return (Boolean)a;
        }
        return true;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... values) {
        return Arrays.asList(values);
    }

    public static <T> T[] concat(T[] a, T[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        T[] result = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static byte[] trimBigIntegerLeadingBytes(byte[] bs) {
        byte b;
        int i;
        int n = bs.length;
        for (i = 0; i < n - 1 && ((b = bs[i]) == 0 || b == -1) && b == 0 ^ (bs[i + 1] & 0x80) != 0; ++i) {
        }
        if (i > 0) {
            bs = Arrays.copyOfRange(bs, i, n);
        }
        return bs;
    }

    public static long memoryAdd(long a, long b) {
        long r = a + b;
        if (r < a) {
            r = Long.MAX_VALUE;
        }
        return r;
    }

    public static <K> void histogramAdd(HashMap<K, Integer> hm, K value) {
        Integer count = hm.get(value);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        hm.put(value, count);
    }

    public static <T> void shuffle(List<T> list) {
        Utils.shuffle(list, new Random());
    }

    public static <T> void shuffle(List<T> list, Random r) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int j = r.nextInt(n);
            if (i == j) continue;
            T temp = list.get(i);
            list.set(i, list.get(j));
            list.set(j, temp);
        }
    }

    public static <A, B> List<B> map(List<A> values, Function<A, B> mapper) {
        ArrayList<B> result = new ArrayList<B>(values.size());
        for (A value : values) {
            result.add(mapper.apply(value));
        }
        return result;
    }

    public static String joinStrings(List<String> strings, String separator) {
        StringBuilder sb = new StringBuilder();
        int n = strings.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(strings.get(i));
        }
        return sb.toString();
    }

    public static long slowMulDiv(long a, long b, long c) {
        BigInteger result = BigInteger.valueOf(a).multiply(BigInteger.valueOf(b)).divide(BigInteger.valueOf(c));
        return Utils.checkedLong(result);
    }

    public static long mulDiv(long a, long b, long c) {
        if (a < 0L || b < 0L) {
            throw new IllegalArgumentException("Negative multiplicand!");
        }
        if (c <= 0L) {
            throw new IllegalArgumentException("Division by non-positive number!");
        }
        return Utils.fastMulDiv(a, b, c);
    }

    static long fastMulDiv(long a, long b, long c) {
        long m0 = a * b;
        long m1 = Math.multiplyHigh(a, b);
        long acc = 0L;
        long ab1 = m1 << 1 | m0 >>> 63;
        if (c <= ab1) {
            return -1L;
        }
        if (ab1 == 0L) {
            return m0 / c;
        }
        long ab0 = m0 & Long.MAX_VALUE;
        long dq = -(Long.MIN_VALUE / c);
        long dr = Long.remainderUnsigned(Long.MIN_VALUE, c);
        while (ab1 > 0L) {
            acc += ab1 * dq;
            m0 = ab1 * dr;
            m1 = Math.multiplyHigh(ab1, dr);
            ab1 = m1 << 1 | m0 >>> 63;
            if ((ab0 = (m0 & Long.MAX_VALUE) + ab0) >= 0L) continue;
            ab0 &= Long.MAX_VALUE;
            ++ab1;
        }
        long result = acc + ab0 / c;
        return result;
    }

    public static Path getHomePath() {
        Path p;
        if (homePath != null) {
            return homePath;
        }
        String homeDir = System.getProperty("user.home");
        homePath = p = new File(homeDir).toPath();
        return p;
    }

    public static long longByteAt(long value, long i) {
        return 0xFFL & value >> (int)((8L - i - 1L) * 8L);
    }

    public static String getVersion() {
        version = Utils.class.getPackage().getImplementationVersion();
        if (version == null) {
            try {
                Properties properties = new Properties();
                InputStream stream = Utils.getResourceAsStream("/convex/core/build.properties");
                if (stream != null) {
                    properties.load(stream);
                    version = properties.getProperty("convex.core.version");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (version == null) {
            return "SNAPSHOT";
        }
        return version;
    }

    public static String timeString() {
        return Utils.timeString(Instant.now());
    }

    private static String timeString(Instant timeStamp) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").withZone(ZoneId.from(ZoneOffset.UTC));
        return formatter.format(timeStamp);
    }

    public static boolean isASCIIChar(long c) {
        return (c & 0xFFFFFFFFFFFFFF80L) == 0L;
    }

    public static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    public static String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }
}

