/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Shutdown;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ThreadUtils {
    private static ExecutorService virtualExecutor = null;

    public static synchronized ExecutorService getVirtualExecutor() {
        if (virtualExecutor == null) {
            virtualExecutor = ThreadUtils.buildVirtualExecutor();
            Shutdown.addHook(110, () -> {
                ExecutorService executor = virtualExecutor;
                List<Object> tasks = List.of();
                if (executor == null) {
                    return;
                }
                try {
                    executor.shutdown();
                    if (!executor.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                        tasks = executor.shutdownNow();
                        if (!tasks.isEmpty()) {
                            System.err.println("Still pending executor tasks: " + String.valueOf(tasks));
                        }
                        if (!executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                            System.err.println("Slow shutdown of executor task threads");
                        }
                    }
                }
                catch (InterruptedException e) {
                    executor.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            });
        }
        return virtualExecutor;
    }

    private static ExecutorService buildVirtualExecutor() {
        ExecutorService ex;
        try {
            Method method = Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]);
            ex = (ExecutorService)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            ex = Executors.newCachedThreadPool();
        }
        return ex;
    }

    public static <R, T> ArrayList<CompletableFuture<R>> futureMap(ExecutorService executor, Function<? super T, R> f, Collection<T> items) {
        ArrayList<CompletableFuture<R>> futures = new ArrayList<CompletableFuture<R>>(items.size());
        for (Object item : items) {
            futures.add(CompletableFuture.supplyAsync(() -> f.apply((Object)item), executor));
        }
        return futures;
    }

    public static <R> void awaitAll(Collection<CompletableFuture<R>> futures) throws InterruptedException, ExecutionException {
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).get();
    }

    public static <T> CompletableFuture<List<T>> completeAll(List<CompletableFuture<T>> futures) {
        CompletableFuture[] fs = futures.toArray(new CompletableFuture[futures.size()]);
        return CompletableFuture.allOf(fs).thenApply(e -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static void runVirtual(Runnable task) {
        ThreadUtils.getVirtualExecutor().execute(task);
    }

    public static void runWithStore(AStore store, Runnable func) {
        ThreadUtils.runVirtual(() -> {
            AStore saved = Stores.current();
            try {
                func.run();
            }
            finally {
                Stores.setCurrent(saved);
            }
        });
    }
}

