/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.cvm.Address;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.Blob;
import convex.core.data.MapEntry;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.util.BlobBuilder;
import convex.core.json.JSON5Reader;
import convex.core.json.JSONReader;
import convex.core.lang.RT;
import convex.core.text.Text;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSON {
    private static final int INDENT = 2;
    private static final StringShort QUOTED_BACKSLASH = StringShort.create("\\\\");
    private static final StringShort QUOTED_QUOTES = StringShort.create("\\\"");
    private static final StringShort QUOTED_NEWLINE = StringShort.create("\\n");
    private static final StringShort QUOTED_RETURN = StringShort.create("\\r");
    private static final StringShort QUOTED_TAB = StringShort.create("\\t");
    private static final StringShort JS_NAN = StringShort.create("NaN");
    private static final char CONTROL_CHARS_END = '\u001f';

    public static String toString(Object value) {
        return JSON.print(value).toString();
    }

    public static String toStringPretty(Object value) {
        return JSON.printPretty(value).toString();
    }

    public static AString toAString(Object value) {
        return JSON.print(value);
    }

    public static <T extends ACell> T parseJSON5(String jsonString) {
        return (T)JSON5Reader.read(jsonString);
    }

    public static <T extends ACell> T parseJSON5(AString jsonString) {
        try {
            return (T)JSON5Reader.read(jsonString.getInputStream());
        }
        catch (IOException e) {
            throw new Error("Unexpected IO error reading JSON", e);
        }
    }

    public static <T extends ACell> T parse(String jsonString) {
        return (T)JSONReader.read(jsonString);
    }

    public static <T extends ACell> T parse(AString jsonString) {
        try {
            return (T)JSONReader.read(jsonString.getInputStream());
        }
        catch (IOException e) {
            throw new Error("Unexpected IO error reading JSON", e);
        }
    }

    public static AString print(Object value) {
        BlobBuilder bb = new BlobBuilder();
        JSON.appendJSON(bb, value);
        return Strings.create(bb.toBlob());
    }

    public static AString printPretty(Object value) {
        BlobBuilder bb = new BlobBuilder();
        JSON.appendPrettyJSON(bb, RT.cvm(value), 0);
        return Strings.create(bb.toBlob());
    }

    private static void appendJSON(BlobBuilder bb, Object value) {
        if (value == null) {
            bb.append(Strings.NULL);
            return;
        }
        if (value instanceof ACell) {
            ACell cell = (ACell)value;
            JSON.appendJSON(bb, cell);
            return;
        }
        if (value instanceof Map) {
            Map mv = (Map)value;
            bb.append('{');
            int i = 0;
            for (Map.Entry me : mv.entrySet()) {
                if (i > 0) {
                    bb.append(",");
                }
                JSON.appendJSON(bb, JSON.jsonKey(me.getKey()));
                bb.append(':');
                JSON.appendJSON(bb, me.getValue());
                ++i;
            }
            bb.append('}');
            return;
        }
        if (value instanceof List) {
            List lv = (List)value;
            bb.append('[');
            int n = lv.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    bb.append(',');
                }
                JSON.appendJSON(bb, lv.get(i));
            }
            bb.append(']');
            return;
        }
        if (value instanceof Boolean) {
            Boolean bv = (Boolean)value;
            bb.append(bv != false ? Strings.TRUE : Strings.FALSE);
            return;
        }
        if (value instanceof CharSequence) {
            CharSequence cs = (CharSequence)value;
            bb.append('\"');
            JSON.appendCVMStringQuoted(bb, cs);
            bb.append('\"');
            return;
        }
        if (value instanceof ASymbolic) {
            ASymbolic cs = (ASymbolic)value;
            bb.append('\"');
            JSON.appendCVMStringQuoted(bb, cs.getName().toString());
            bb.append('\"');
            return;
        }
        if (value instanceof Number) {
            Number nv = (Number)value;
            if (value instanceof Double) {
                Double dv = (Double)value;
                if (Double.isFinite(dv)) {
                    bb.append(nv.toString());
                    return;
                }
                if (Double.isNaN(dv)) {
                    bb.append(JS_NAN);
                } else {
                    bb.append(Strings.NULL);
                }
                return;
            }
            bb.append(nv.toString());
            return;
        }
        throw new IllegalArgumentException("Can't print type as JSON: " + Utils.getClassName(value));
    }

    private static void appendJSON(BlobBuilder bb, ACell value) {
        if (value == null) {
            bb.append(Strings.NULL);
            return;
        }
        if (value instanceof AString) {
            AString cs = (AString)value;
            bb.append('\"');
            JSON.appendCVMStringQuoted(bb, cs.toString());
            bb.append('\"');
            return;
        }
        if (value instanceof ASymbolic) {
            ASymbolic cs = (ASymbolic)value;
            JSON.appendJSON(bb, cs.getName());
            return;
        }
        if (value instanceof AMap) {
            AMap mv = (AMap)value;
            bb.append('{');
            long n = mv.size();
            for (long i = 0L; i < n; ++i) {
                if (i > 0L) {
                    bb.append(',');
                }
                MapEntry me = mv.entryAt(i);
                JSON.appendJSON(bb, JSON.jsonKey((ACell)me.getKey()));
                bb.append(':');
                JSON.appendJSON(bb, (ACell)me.getValue());
            }
            bb.append('}');
            return;
        }
        if (value instanceof ACollection) {
            ACollection lv = (ACollection)value;
            bb.append('[');
            long n = lv.count();
            for (long i = 0L; i < n; ++i) {
                if (i > 0L) {
                    bb.append(',');
                }
                JSON.appendJSON(bb, lv.get(i));
            }
            bb.append(']');
            return;
        }
        if (value instanceof CVMLong) {
            CVMLong nv = (CVMLong)value;
            JSON.appendJSON(bb, nv.longValue());
            return;
        }
        if (value instanceof ABlob) {
            ABlob bv = (ABlob)value;
            bb.append("\"0x");
            bb.append(bv.toHexString());
            bb.append('\"');
            return;
        }
        if (value instanceof CVMDouble) {
            CVMDouble nv = (CVMDouble)value;
            JSON.appendJSON(bb, nv.doubleValue());
            return;
        }
        if (value instanceof CVMBigInteger) {
            CVMBigInteger nv = (CVMBigInteger)value;
            bb.append(nv.toString());
            return;
        }
        if (value instanceof CVMBool) {
            CVMBool bv = (CVMBool)value;
            bb.append(bv.booleanValue() ? Strings.TRUE : Strings.FALSE);
            return;
        }
        if (value instanceof CVMChar) {
            CVMChar c = (CVMChar)value;
            JSON.appendJSON(bb, c.toString());
            return;
        }
        if (value instanceof Address) {
            Address a = (Address)value;
            bb.append(Long.toString(a.longValue()));
            return;
        }
        JSON.appendJSON(bb, RT.print(value));
    }

    private static BlobBuilder appendPrettyJSON(BlobBuilder sb, ACell o, int indent) {
        if (o instanceof AMap) {
            int entryIndent = indent + 2;
            sb.append("{");
            AMap m = (AMap)o;
            int size = m.size();
            if (size > 0) {
                sb.append('\n');
                int pos = 0;
                for (int i = 0; i < size; ++i) {
                    MapEntry me = m.entryAt(i);
                    AString k = JSON.keyValue((ACell)me.getKey());
                    JSON.appendWhitespaceString(sb, entryIndent);
                    sb.append(JSON.toString(k));
                    sb.append(": ");
                    int vIndent = entryIndent + k.size() + 4;
                    Object v = me.getValue();
                    JSON.appendPrettyJSON(sb, (ACell)v, vIndent);
                    if (++pos == size) {
                        sb.append('\n');
                        continue;
                    }
                    sb.append(",\n");
                }
            }
            JSON.appendWhitespaceString(sb, indent);
            sb.append('}');
        } else if (o instanceof ASequence) {
            ASequence list = (ASequence)o;
            int size = list.size();
            int entryIndent = indent + 1;
            sb.append("[");
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                    JSON.appendWhitespaceString(sb, entryIndent);
                }
                Object v = list.get(i);
                JSON.appendPrettyJSON(sb, (ACell)v, entryIndent);
            }
            sb.append("]");
        } else {
            sb.append(JSON.toString(o));
        }
        return sb;
    }

    private static AString keyValue(ACell key) {
        if (key instanceof ASymbolic) {
            ASymbolic symKey = (ASymbolic)key;
            return symKey.getName();
        }
        return RT.str(key);
    }

    private static BlobBuilder appendWhitespaceString(BlobBuilder sb, long count) {
        return sb.appendRepeatedByte((byte)32, count);
    }

    private static void appendCVMStringQuoted(BlobBuilder bb, CharSequence cs) {
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            char c = cs.charAt(i);
            AString rep = JSON.getReplacementString(c);
            if (rep != null) {
                bb.append(rep);
                continue;
            }
            if (Character.isSurrogate(c)) {
                int codePoint = Character.codePointAt(cs, i);
                bb.append(CVMChar.create(codePoint));
                ++i;
                continue;
            }
            bb.append(c);
        }
    }

    private static AString getReplacementString(char c) {
        if (c == '\\') {
            return QUOTED_BACKSLASH;
        }
        if (c > '\"') {
            return null;
        }
        if (c == '\"') {
            return QUOTED_QUOTES;
        }
        if (c > '\u001f') {
            return null;
        }
        if (c == '\n') {
            return QUOTED_NEWLINE;
        }
        if (c == '\r') {
            return QUOTED_RETURN;
        }
        if (c == '\t') {
            return QUOTED_TAB;
        }
        return StringShort.create(Blob.wrap(new byte[]{92, 117, 48, 48, (byte)Utils.toHexChar(c >> 4 & 0xF), (byte)Utils.toHexChar(c & 0xF)}));
    }

    public static AString escape(String content) {
        BlobBuilder bb = new BlobBuilder();
        JSON.appendCVMStringQuoted(bb, content);
        return Strings.create(bb.toBlob());
    }

    public static AString unescape(String content) {
        String unes = Text.unescapeJava(content);
        return Strings.create(unes);
    }

    public static <T> T jvm(String json) {
        return RT.jvm(JSON.parse(json));
    }

    public static <T> T jvm(AString json) {
        return RT.jvm(JSON.parse(json));
    }

    public static Object json(ACell o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CVMLong) {
            CVMLong cvmLong = (CVMLong)o;
            return cvmLong.longValue();
        }
        if (o instanceof CVMBigInteger) {
            CVMBigInteger bi = (CVMBigInteger)o;
            return bi.big();
        }
        if (o instanceof CVMDouble) {
            CVMDouble cd = (CVMDouble)o;
            double dv = cd.doubleValue();
            if (!Double.isFinite(dv)) {
                return null;
            }
            return dv;
        }
        if (o instanceof ASymbolic) {
            ASymbolic symKey = (ASymbolic)o;
            return symKey.getName().toString();
        }
        if (o instanceof CVMBool) {
            CVMBool bool = (CVMBool)o;
            return bool.booleanValue();
        }
        if (o instanceof CVMChar) {
            CVMChar c = (CVMChar)o;
            return c.toString();
        }
        if (o instanceof Address) {
            Address a = (Address)o;
            return a.longValue();
        }
        if (o instanceof AMap) {
            AMap m = (AMap)o;
            return JSON.jsonMap(m);
        }
        if (o instanceof ACollection) {
            ACollection seq = (ACollection)o;
            long n = seq.count();
            ArrayList<Object> list = new ArrayList<Object>();
            for (long i = 0L; i < n; ++i) {
                Object cvmv = seq.get(i);
                Object v = JSON.json(cvmv);
                list.add(v);
            }
            return list;
        }
        return o.toString();
    }

    public static HashMap<String, Object> jsonMap(AMap<?, ?> m) {
        int n = m.size();
        HashMap<String, Object> hm = new HashMap<String, Object>(n);
        for (long i = 0L; i < (long)n; ++i) {
            MapEntry<?, ?> me = m.entryAt(i);
            Object k = me.getKey();
            String sk = JSON.jsonKey((ACell)k);
            Object v = JSON.json((ACell)me.getValue());
            hm.put(sk, v);
        }
        return hm;
    }

    public static String jsonKey(ACell k) {
        if (k instanceof AString) {
            return k.toString();
        }
        if (k instanceof ASymbolic) {
            ASymbolic symKey = (ASymbolic)k;
            return symKey.getName().toString();
        }
        return RT.toString(k);
    }

    public static String jsonKey(Object o) {
        if (o instanceof ACell) {
            ACell cell = (ACell)o;
            return JSON.jsonKey(cell);
        }
        if (o instanceof String) {
            String s = (String)o;
            return s;
        }
        throw new IllegalArgumentException("Invalid type for JSON key: " + Utils.getClassName(o));
    }
}

