/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.lang.RT;
import convex.core.util.FileUtils;
import convex.core.util.JSON;
import convex.core.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class ConfigUtils {
    public static AMap<AString, ACell> readConfig(URL url) throws IOException {
        AMap<AString, ACell> result = ConfigUtils.readConfig(url.openStream());
        return result;
    }

    public static AMap<AString, ACell> readConfig(URI uri) throws IOException {
        AMap<AString, ACell> result = ConfigUtils.readConfig(uri.toURL());
        return result;
    }

    public static AMap<AString, ACell> readConfig(InputStream resource) throws IOException {
        String config = Utils.readString(resource);
        AMap result = (AMap)JSON.parseJSON5(config);
        return RT.ensureMap(result);
    }

    public static AMap<AString, ACell> readConfigFile(String filename) throws IOException {
        File f = FileUtils.getFile(filename);
        if (!f.exists()) {
            throw new FileNotFoundException("File: " + filename);
        }
        return ConfigUtils.readConfig(f.toURI());
    }
}

