/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.cvm.Address;
import convex.core.data.ACell;
import convex.core.data.ACountable;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.exceptions.ParseException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.util.Utils;

public class CAIP {
    public static AString CONVEX_ASSET_ID = Strings.intern("slip44:864");
    public static AString CAD29_ASSET_NAMESPACE = Strings.intern("cad29");
    private static final String CAD29_PREFIX = "cad29:";
    public static AString PROTONET = Strings.intern("convex:protonet");
    public static AString LOCALNET = Strings.intern("convex:local");
    public static AString TESTNET = Strings.intern("convex:testnet");
    public static AString MAINNET = Strings.intern("convex:main");

    public static ACell parseAssetID(AString assetID) {
        if (assetID == null) {
            throw new IllegalArgumentException("Null asset ID");
        }
        if (assetID.equals(CONVEX_ASSET_ID)) {
            return CONVEX_ASSET_ID;
        }
        if (assetID.startsWith(CAD29_ASSET_NAMESPACE)) {
            return CAIP.parseTokenID(assetID.toString());
        }
        throw new IllegalArgumentException("Unrecognised CAIP19 asset format: " + String.valueOf(assetID));
    }

    public static ACell parseTokenID(String caip19) {
        if (CAIP.isCVM(caip19)) {
            return CONVEX_ASSET_ID;
        }
        String[] ss = caip19.split(":");
        if (ss[0].equals("cad29")) {
            try {
                ACountable assetID;
                String id = ss[1];
                int dashPos = id.indexOf("-");
                if (dashPos < 0) {
                    assetID = Address.parse(id);
                    if (assetID == null) {
                        throw new IllegalArgumentException("Invalid address for CAD29 asset: " + id);
                    }
                } else {
                    assetID = Address.parse(id.substring(0, dashPos));
                    Address addr = assetID;
                    if (addr == null) {
                        throw new IllegalArgumentException("Invalid address for scoped CAD29 asset: " + id);
                    }
                    Object scope = Reader.read(Utils.urlDecode(id.substring(dashPos + 1)));
                    assetID = Vectors.create(new ACell[]{addr, scope});
                }
                return assetID;
            }
            catch (ParseException | IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid CAIP19 asset for Convex: " + caip19, e);
            }
        }
        throw new IllegalArgumentException("Only CVM or CAD29 assets currently supported on Convex, but CAIP19 code was: " + caip19);
    }

    public static String toAssetID(ACell assetID) {
        if (assetID instanceof Address) {
            Address addr = (Address)assetID;
            return CAD29_PREFIX + Long.toString(addr.longValue());
        }
        if (assetID instanceof AVector) {
            AVector v = (AVector)assetID;
            if (v.count() != 2L) {
                throw new IllegalArgumentException("Not a valid CAD29 scoped token ID: 2 elements requires");
            }
            return CAIP.toAssetID((ACell)v.get(0)) + "-" + Utils.urlEncode(RT.print((ACell)v.get(1)).toString());
        }
        throw new IllegalArgumentException("Not a valid CAD29 token ID: " + String.valueOf(assetID));
    }

    public static boolean isCVM(String caip19) {
        return "slip44:864".equals(caip19);
    }
}

