/*
 * Decompiled with CFR 0.152.
 */
package convex.core.text;

import convex.core.data.AString;
import convex.core.data.Strings;
import convex.core.data.prim.CVMChar;
import convex.core.data.util.BlobBuilder;

public class StringUtils {
    public static AString escapeHtml(AString text) {
        if (text == null) {
            return Strings.EMPTY;
        }
        BlobBuilder bb = new BlobBuilder();
        long len = text.count();
        long pos = 0L;
        while (pos < len) {
            int c = text.charAt(pos);
            if (c == -1) {
                ++pos;
                continue;
            }
            switch (c) {
                case 38: {
                    bb.append("&amp;");
                    break;
                }
                case 60: {
                    bb.append("&lt;");
                    break;
                }
                case 62: {
                    bb.append("&gt;");
                    break;
                }
                case 34: {
                    bb.append("&quot;");
                    break;
                }
                case 39: {
                    bb.append("&#39;");
                    break;
                }
                default: {
                    if (!Character.isValidCodePoint(c)) break;
                    bb.append(CVMChar.create(c));
                }
            }
            int utfLen = CVMChar.utfLength(c);
            if (utfLen < 0) {
                utfLen = 1;
            }
            pos += (long)utfLen;
        }
        return bb.getCVMString();
    }
}

