/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.data.ACell;
import convex.core.data.AEncoder;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;

public abstract class AStore
implements Closeable {
    public abstract <T extends ACell> Ref<T> storeRef(Ref<T> var1, int var2, Consumer<Ref<ACell>> var3) throws IOException;

    public abstract <T extends ACell> Ref<T> storeTopRef(Ref<T> var1, int var2, Consumer<Ref<ACell>> var3) throws IOException;

    public abstract <T extends ACell> Ref<T> refForHash(Hash var1);

    public abstract Hash getRootHash() throws IOException;

    public <T extends ACell> T getRootData() throws IOException {
        Ref<T> ref = this.getRootRef();
        if (ref == null) {
            return null;
        }
        return ref.getValue();
    }

    public <T extends ACell> Ref<T> getRootRef() throws IOException {
        Hash h = this.getRootHash();
        Ref<T> ref = this.refForHash(h);
        if (ref == null && (Hash.EMPTY_HASH.equals(h) || Hash.NULL_HASH.equals(h))) {
            return Ref.NULL_VALUE;
        }
        return ref;
    }

    public abstract <T extends ACell> Ref<T> setRootData(T var1) throws IOException;

    @Override
    public abstract void close();

    public abstract <T extends ACell> T decode(Blob var1) throws BadFormatException;

    public abstract AEncoder<ACell> getEncoder();

    public abstract <T extends ACell> Ref<T> checkCache(Hash var1);

    public abstract String shortName();
}

