/*
 * Decompiled with CFR 0.152.
 */
package convex.core.message;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.cpos.Belief;
import convex.core.cvm.Address;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.message.MessageTag;
import convex.core.message.MessageType;
import convex.core.store.AStore;
import convex.core.util.Utils;
import java.util.function.Predicate;

public class Message {
    private static final Message BYE_MESSAGE = Message.create(MessageType.GOODBYE, Vectors.create(MessageTag.BYE));
    protected ACell payload;
    protected Blob messageData;
    protected MessageType type;
    protected Predicate<Message> returnHandler;

    protected Message(MessageType type, ACell payload, Blob data, Predicate<Message> handler) {
        this.type = type;
        this.messageData = data;
        this.payload = payload;
        this.returnHandler = handler;
    }

    public static Message create(Predicate<Message> handler, MessageType type, Blob data) {
        return new Message(type, null, data, handler);
    }

    public static Message create(Blob data) throws BadFormatException {
        if (data.count() == 0L) {
            throw new BadFormatException("Empty Message");
        }
        return new Message(null, null, data, null);
    }

    public static Message create(MessageType type, ACell payload) {
        return new Message(type, payload, null, null);
    }

    public static Message create(MessageType type, ACell payload, Blob data) {
        return new Message(type, payload, data, null);
    }

    public static Message createDataResponse(ACell id, ACell ... cells) {
        Result result = Result.create(id, Vectors.create(cells));
        Message m = Message.create(MessageType.RESULT, Result.create(id, Vectors.create(cells)));
        m.messageData = Format.encodeDataResult(result);
        return m;
    }

    public static Message createDataRequest(ACell id, Hash ... hashes) {
        int n = hashes.length;
        ACell[] cs = new ACell[n + 2];
        cs[0] = MessageTag.DATA_REQUEST;
        cs[1] = id;
        for (int i = 0; i < n; ++i) {
            cs[i + 2] = hashes[i];
        }
        return Message.create(MessageType.DATA_REQUEST, Vectors.create(cs));
    }

    public static Message createBelief(Belief belief) {
        return Message.create(MessageType.BELIEF, belief);
    }

    public static Message createBeliefRequest() {
        return Message.create(MessageType.REQUEST_BELIEF, null);
    }

    public static Message createChallenge(SignedData<ACell> challenge) {
        return Message.create(MessageType.CHALLENGE, challenge);
    }

    public static Message createResponse(SignedData<ACell> response) {
        return Message.create(MessageType.RESPONSE, response);
    }

    public static Message createGoodBye() {
        return BYE_MESSAGE;
    }

    public <T extends ACell> T getPayload() throws BadFormatException {
        if (this.payload != null) {
            return (T)this.payload;
        }
        if (this.messageData == null) {
            return null;
        }
        if (this.messageData.count() == 1L && this.messageData.byteAt(0L) == 0) {
            return null;
        }
        this.payload = Format.decodeMultiCell(this.messageData);
        return (T)this.payload;
    }

    public Blob getMessageData() {
        if (this.messageData != null) {
            return this.messageData;
        }
        MessageType type = this.getType();
        switch (type) {
            default: 
        }
        this.messageData = Format.encodeMultiCell(this.payload, true);
        return this.messageData;
    }

    public MessageType getType() {
        if (this.type == null) {
            this.type = this.inferType();
        }
        return this.type;
    }

    private MessageType inferType() {
        byte tag;
        if (this.hasData()) {
            tag = this.messageData.byteAt(0L);
        } else {
            if (this.payload == null) {
                return MessageType.UNKNOWN;
            }
            tag = this.payload.getTag();
        }
        if (tag == -44) {
            return MessageType.BELIEF;
        }
        if (tag == -112) {
            return MessageType.BELIEF;
        }
        if (tag == -35) {
            return MessageType.RESULT;
        }
        try {
            Object payload = this.getPayload();
            if (payload instanceof AVector) {
                AVector v = (AVector)payload;
                if (v.count() == 0L) {
                    return MessageType.UNKNOWN;
                }
                Keyword mt = RT.ensureKeyword((ACell)v.get(0));
                if (mt == null) {
                    return MessageType.UNKNOWN;
                }
                if (MessageTag.STATUS_REQUEST.equals(mt)) {
                    return MessageType.STATUS;
                }
                if (MessageTag.QUERY.equals(mt)) {
                    return MessageType.QUERY;
                }
                if (MessageTag.BYE.equals(mt)) {
                    return MessageType.GOODBYE;
                }
                if (MessageTag.TRANSACT.equals(mt)) {
                    return MessageType.TRANSACT;
                }
                if (MessageTag.DATA_REQUEST.equals(mt)) {
                    return MessageType.DATA_REQUEST;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MessageType.UNKNOWN;
    }

    public String toString() {
        try {
            Object payload = this.getPayload();
            AString ps = RT.print(payload, 10000L);
            if (ps == null) {
                return "<BIG MESSAGE " + RT.count(this.getMessageData()) + " TYPE [" + String.valueOf((Object)this.getType()) + "]>";
            }
            return ps.toString();
        }
        catch (MissingDataException e) {
            return "<PARTIAL MESSAGE [" + String.valueOf((Object)this.getType()) + "] MISSING " + String.valueOf(e.getMissingHash()) + " ENC " + this.getMessageData().toHexString(16) + ">";
        }
        catch (BadFormatException e) {
            return "<CORRUPTED MESSAGE [" + String.valueOf((Object)this.getType()) + "]>: " + e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (this.payload != null && Utils.equals(this.payload, other.payload)) {
            return true;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getMessageData().equals(other.getMessageData());
    }

    public int hashCode() {
        try {
            return Utils.hashCode(this.getPayload());
        }
        catch (BadFormatException e) {
            return 0;
        }
    }

    public ACell getID() {
        if (this.payload == null) {
            throw new IllegalStateException("Attempting to get ID of message before Payload is decoded");
        }
        switch (this.getType()) {
            case RESULT: {
                return this.getResultID();
            }
        }
        return this.getRequestID();
    }

    public ACell getRequestID() {
        try {
            switch (this.getType()) {
                case STATUS: 
                case TRANSACT: 
                case QUERY: 
                case DATA_REQUEST: {
                    AVector v = RT.ensureVector(this.getPayload());
                    if (v.count() < 2L) {
                        return null;
                    }
                    return RT.ensureLong((ACell)v.get(1));
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ACell getResultID() {
        if (this.payload != null) {
            if (this.payload instanceof Result) {
                return ((Result)this.payload).getID();
            }
            return null;
        }
        if (this.hasData()) {
            try {
                byte tag = this.messageData.byteAt(0L);
                if (tag != -35) {
                    return null;
                }
                return Result.peekResultID(this.messageData, 0);
            }
            catch (BadFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Message withID(ACell id) {
        try {
            switch (this.getType()) {
                case RESULT: {
                    return Message.create(this.type, ((Result)this.getPayload()).withID(id));
                }
                case STATUS: 
                case TRANSACT: 
                case QUERY: 
                case DATA_REQUEST: {
                    Object o = this.getPayload();
                    if (!(o instanceof AVector)) break;
                    AVector v = (AVector)o;
                    if (v.count() < 2L) {
                        return null;
                    }
                    return Message.create(this.type, v.assoc(1L, id));
                }
            }
            return null;
        }
        catch (BadFormatException | ClassCastException | IndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean returnResult(Result res) {
        ACell id = this.getRequestID();
        if (id != null) {
            res = res.withID(id);
            Message msg = Message.createResult(res);
            return this.returnMessage(msg);
        }
        throw new IllegalStateException("Trying to return result with no original request ID");
    }

    public boolean returnMessage(Message m) {
        Predicate<Message> handler = this.returnHandler;
        if (handler == null) {
            return false;
        }
        return handler.test(m);
    }

    public boolean hasData() {
        return this.messageData != null;
    }

    public static Message createResult(Result res) {
        return Message.create(MessageType.RESULT, res);
    }

    public static Message createResult(ACell id, ACell value, ACell error) {
        Result r = Result.create(id, value, error);
        return Message.createResult(r);
    }

    public void closeConnection() {
        this.returnHandler = null;
    }

    public Message makeDataResponse(AStore store) throws BadFormatException {
        int HEADER_OFFSET = 2;
        AVector v = RT.ensureVector(this.getPayload());
        if (v == null || v.isEmpty()) {
            throw new BadFormatException("Invalid data request payload");
        }
        if (v.count() > 256L) {
            throw new BadFormatException("Too many elements in Missing data request");
        }
        Object id = v.get(1);
        int n = v.size() - 2;
        ACell[] vals = new ACell[n];
        for (int i = 0; i < n; ++i) {
            Hash h = RT.ensureHash((ACell)v.get(i + 2));
            if (h == null) {
                throw new BadFormatException("Invalid data request hash");
            }
            Ref r = store.refForHash(h);
            if (r != null) {
                Object data = r.getValue();
                vals[i] = data;
                continue;
            }
            vals[i] = null;
        }
        Message resp = Message.createDataResponse((ACell)id, vals);
        return resp;
    }

    public Result toResult() {
        try {
            MessageType type = this.getType();
            switch (type) {
                case RESULT: {
                    Result result = (Result)this.getPayload();
                    return result;
                }
                case DATA: {
                    return Result.create(this.getID(), this.getPayload(), null);
                }
            }
            return Result.create(this.getID(), Strings.create("Unexpected message type for Result: " + String.valueOf((Object)type)), ErrorCodes.UNEXPECTED);
        }
        catch (BadFormatException e) {
            return Result.fromException(e).withSource(SourceCodes.CLIENT);
        }
    }

    public static Message create(MessageType type, ACell payload, Predicate<Message> handler) {
        return new Message(type, payload, null, handler);
    }

    public Message withResultHandler(Predicate<Message> resultHandler) {
        if (this.returnHandler == resultHandler) {
            return this;
        }
        return new Message(this.type, this.payload, this.messageData, resultHandler);
    }

    public static Message createQuery(long id, String code, Address address) {
        return Message.createQuery(id, Reader.read(code), address);
    }

    public static Message createQuery(long id, ACell code, Address address) {
        AVector v = Vectors.create(MessageTag.QUERY, CVMLong.create(id), code, address);
        return Message.create(MessageType.QUERY, v);
    }

    public static Message createTransaction(long id, SignedData<ATransaction> signed) {
        AVector v = Vectors.create(MessageTag.TRANSACT, CVMLong.create(id), signed);
        return Message.create(MessageType.TRANSACT, v);
    }

    public static Message createStatusRequest(long id) {
        CVMLong idPayload = CVMLong.create(id);
        AVector v = Vectors.create(MessageTag.STATUS_REQUEST, idPayload);
        return Message.create(MessageType.STATUS, v);
    }

    public Hash getHash() {
        try {
            return ((ACell)this.getPayload()).getHash();
        }
        catch (BadFormatException e) {
            return null;
        }
    }
}

