/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.reader;

import convex.core.cvm.Address;
import convex.core.cvm.CVMEncoder;
import convex.core.cvm.Symbols;
import convex.core.cvm.Syntax;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AList;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Keyword;
import convex.core.data.List;
import convex.core.data.Lists;
import convex.core.data.Maps;
import convex.core.data.Sets;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.ParseException;
import convex.core.lang.RT;
import convex.core.lang.reader.ConvexErrorListener;
import convex.core.lang.reader.ReaderUtils;
import convex.core.lang.reader.antlr.ConvexBaseListener;
import convex.core.lang.reader.antlr.ConvexLexer;
import convex.core.lang.reader.antlr.ConvexParser;
import convex.core.text.Text;
import convex.core.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class AntlrReader {
    private static final ConvexErrorListener ERROR_LISTENER = new ConvexErrorListener();

    public static ACell read(InputStream is) throws IOException {
        return AntlrReader.read(CharStreams.fromStream((InputStream)is));
    }

    public static ACell read(String s) {
        if (s == null) {
            throw new ParseException("Null input String");
        }
        return AntlrReader.read((CharStream)CharStreams.fromString((String)s));
    }

    public static ACell read(Reader r) throws IOException {
        return AntlrReader.read((CharStream)CharStreams.fromReader((Reader)r));
    }

    static ConvexParser getParser(CharStream cs, CRListener listener) {
        ConvexLexer lexer = new ConvexLexer(cs);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CatchingParser parser = new CatchingParser((TokenStream)tokens);
        parser.setBuildParseTree(false);
        parser.removeErrorListeners();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        parser.addParseListener(listener);
        return parser;
    }

    static ACell read(CharStream cs) {
        CRListener listener = new CRListener();
        ConvexParser parser = AntlrReader.getParser(cs, listener);
        parser.singleForm();
        ArrayList<ACell> top = listener.popList();
        if (top.size() != 1) {
            throw new ParseException("Bad parse output: " + String.valueOf(top));
        }
        return top.get(0);
    }

    public static AList<ACell> readAll(String source) {
        return AntlrReader.readAll((CharStream)CharStreams.fromString((String)source));
    }

    static AList<ACell> readAll(CharStream cs) {
        CRListener listener = new CRListener();
        ConvexParser parser = AntlrReader.getParser(cs, listener);
        parser.allForms();
        ArrayList<ACell> top = listener.popList();
        return Lists.create(top);
    }

    static ParseTree getParseTree(String input) {
        CodePointCharStream cs = CharStreams.fromString((String)input);
        return AntlrReader.getParseTree((CharStream)cs);
    }

    static ParseTree getParseTree(CharStream cs) {
        ConvexLexer lexer = new ConvexLexer(cs);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ConvexErrorListener());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ConvexParser parser = new ConvexParser((TokenStream)tokens);
        parser.removeErrorListeners();
        ConvexParser.AllFormsContext tree = parser.allForms();
        return tree;
    }

    public static Lexer getLexer(CharStream cs) {
        return new ConvexLexer(cs);
    }

    static class CatchingParser
    extends ConvexParser {
        protected boolean listenerExceptionOccurred = false;

        public CatchingParser(TokenStream input) {
            super(input);
        }

        protected void triggerExitRuleEvent() {
            if (this.listenerExceptionOccurred) {
                return;
            }
            try {
                for (int i = this._parseListeners.size() - 1; i >= 0; --i) {
                    ParseTreeListener listener = (ParseTreeListener)this._parseListeners.get(i);
                    this._ctx.exitRule(listener);
                    listener.exitEveryRule(this._ctx);
                }
            }
            catch (ParseException e) {
                this.listenerExceptionOccurred = true;
                throw e;
            }
        }
    }

    static class CRListener
    extends ConvexBaseListener {
        ArrayList<ArrayList<ACell>> stack = new ArrayList();
        protected CVMEncoder encoder;

        public CRListener() {
            this(CVMEncoder.INSTANCE);
        }

        public CRListener(CVMEncoder encoder) {
            this.encoder = encoder;
            this.stack.add(new ArrayList());
        }

        public void push(ACell a) {
            ArrayList<ACell> top = this.stack.getLast();
            top.add(a);
        }

        public <R extends ACell> R pop() {
            ArrayList<ACell> top = this.stack.getLast();
            ACell cell = top.removeLast();
            return (R)cell;
        }

        private void pushList() {
            this.stack.add(new ArrayList());
        }

        public ArrayList<ACell> popList() {
            ArrayList<ACell> top = this.stack.removeLast();
            return top;
        }

        @Override
        public void visitErrorNode(ErrorNode node) {
            throw new ParseException(String.valueOf(node.getSourceInterval()) + " " + node.getText());
        }

        @Override
        public void enterList(ConvexParser.ListContext ctx) {
            this.pushList();
        }

        @Override
        public void exitList(ConvexParser.ListContext ctx) {
            ArrayList<ACell> elements = this.popList();
            this.push((ACell)Lists.create(elements));
        }

        @Override
        public void enterVector(ConvexParser.VectorContext ctx) {
            this.pushList();
        }

        @Override
        public void exitVector(ConvexParser.VectorContext ctx) {
            ArrayList<ACell> elements = this.popList();
            this.push(Vectors.create(elements));
        }

        @Override
        public void enterSet(ConvexParser.SetContext ctx) {
            this.pushList();
        }

        @Override
        public void exitSet(ConvexParser.SetContext ctx) {
            ArrayList<ACell> elements = this.popList();
            this.push(Sets.fromCollection(elements));
        }

        @Override
        public void enterMap(ConvexParser.MapContext ctx) {
            this.pushList();
        }

        @Override
        public void exitMap(ConvexParser.MapContext ctx) {
            ArrayList<ACell> elements = this.popList();
            if (Utils.isOdd(elements.size())) {
                throw new ParseException("Map requires an even number of forms.");
            }
            this.push((ACell)Maps.create(elements.toArray(new ACell[elements.size()])));
        }

        @Override
        public void exitLongValue(ConvexParser.LongValueContext ctx) {
            String s = ctx.getStop().getText();
            AInteger a = AInteger.parse(s);
            if (a == null) {
                throw new ParseException("Unparseable number: " + s);
            }
            this.push(a);
        }

        @Override
        public void enterDoubleValue(ConvexParser.DoubleValueContext ctx) {
        }

        @Override
        public void exitDoubleValue(ConvexParser.DoubleValueContext ctx) {
            String s = ctx.getStop().getText();
            CVMDouble v = CVMDouble.parse(s);
            if (v == null) {
                throw new ParseException("Bad double format: " + s);
            }
            this.push(v);
        }

        @Override
        public void exitNil(ConvexParser.NilContext ctx) {
            this.push(null);
        }

        @Override
        public void exitBool(ConvexParser.BoolContext ctx) {
            this.push(CVMBool.parse(ctx.getStop().getText()));
        }

        @Override
        public void exitCharacter(ConvexParser.CharacterContext ctx) {
            String s = ctx.getStop().getText();
            CVMChar c = CVMChar.parse(s);
            if (c == null) {
                throw new ParseException("Bad character literal format: " + s);
            }
            this.push(c);
        }

        @Override
        public void exitKeyword(ConvexParser.KeywordContext ctx) {
            String s = ctx.getStop().getText();
            Keyword k = Keyword.create(s.substring(1));
            if (k == null) {
                throw new ParseException("Bad Keyword format: " + s);
            }
            this.push(k);
        }

        @Override
        public void exitSymbol(ConvexParser.SymbolContext ctx) {
            String s = ctx.getStop().getText();
            Symbol sym = Symbol.create(s);
            if (sym == null) {
                throw new ParseException("Bad Symbol format: " + s);
            }
            this.push(sym);
        }

        @Override
        public void exitImplicitSymbol(ConvexParser.ImplicitSymbolContext ctx) {
            String s = ctx.getText();
            Symbol sym = Symbol.create(s);
            if (sym == null) {
                throw new ParseException("Bad implicit symbol: " + s);
            }
            this.push(sym);
        }

        @Override
        public void enterTaggedForm(ConvexParser.TaggedFormContext ctx) {
            this.pushList();
        }

        @Override
        public void exitTaggedForm(ConvexParser.TaggedFormContext ctx) {
            ArrayList<ACell> elements = this.popList();
            if (elements.size() != 2) {
                throw new ParseException("Tagged form tag and form but got:" + String.valueOf(elements));
            }
            Symbol sym = (Symbol)elements.get(0);
            ACell value = elements.get(1);
            ACell result = Cells.createTagged(sym, value);
            this.push(result);
        }

        @Override
        public void exitTag(ConvexParser.TagContext ctx) {
            String s = ctx.getText();
            Symbol sym = Symbol.create(s = s.substring(1));
            if (sym == null) {
                throw new ParseException("Bad tag: #" + s);
            }
            this.push(sym);
        }

        @Override
        public void exitAddress(ConvexParser.AddressContext ctx) {
            String s = ctx.getStop().getText();
            try {
                long value = Long.parseLong(s.substring(1));
                Address addr = Address.create(value);
                if (addr == null) {
                    throw new ParseException("Bad Address format: " + s);
                }
                this.push(addr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Problem parsing Address: " + s, e);
            }
        }

        @Override
        public void enterSyntax(ConvexParser.SyntaxContext ctx) {
            this.pushList();
        }

        @Override
        public void exitSyntax(ConvexParser.SyntaxContext ctx) {
            ArrayList<ACell> elements = this.popList();
            if (elements.size() != 2) {
                throw new ParseException("Metadata requires metadata and annotated form but got:" + String.valueOf(elements));
            }
            AHashMap<ACell, ACell> meta = ReaderUtils.interpretMetadata(elements.get(0));
            ACell value = elements.get(1);
            this.push(Syntax.create(value, meta));
        }

        @Override
        public void exitBlob(ConvexParser.BlobContext ctx) {
            String s = ctx.getStop().getText();
            Blob b = Blob.fromHex(s.substring(2));
            if (b == null) {
                throw new ParseException("Invalid Blob syntax: " + s);
            }
            this.push(b);
        }

        @Override
        public void exitCad3(ConvexParser.Cad3Context ctx) {
            String s = ctx.getStop().getText();
            Blob enc = Blob.fromHex(s.substring(2, s.length() - 1));
            try {
                ACell cell = this.encoder.decodeMultiCell(enc);
                this.push(cell);
            }
            catch (BadFormatException e) {
                throw new ParseException("Invalid CAD3 encoding: " + e.getMessage(), e);
            }
        }

        @Override
        public void exitQuoted(ConvexParser.QuotedContext ctx) {
            Object form = this.pop();
            String qs = ctx.getStart().getText();
            Symbol qsym = ReaderUtils.getQuotingSymbol(qs);
            if (qsym == null) {
                throw new ParseException("Invalid quoting reader macro: " + qs);
            }
            this.push(Lists.of(qsym, form));
        }

        @Override
        public void exitResolve(ConvexParser.ResolveContext ctx) {
            String s = ctx.getStop().getText();
            Symbol sym = Symbol.create(s = s.substring(1));
            if (sym == null) {
                throw new ParseException("Invalid @ symbol: @" + s);
            }
            this.push(List.of(new Object[]{Symbols.RESOLVE, sym}));
        }

        @Override
        public void exitSlashSymbol(ConvexParser.SlashSymbolContext ctx) {
            String s = ctx.getStop().getText();
            Symbol sym = Symbol.create(s = s.substring(1));
            if (sym == null) {
                throw new ParseException("Invalid / symbol: /" + s);
            }
            this.push(sym);
        }

        @Override
        public void exitString(ConvexParser.StringContext ctx) {
            String s = ctx.getStop().getText();
            int n = s.length();
            s = s.substring(1, n - 1);
            s = Text.unescapeJava(s);
            this.push(Strings.create(s));
        }

        @Override
        public void exitSpecialLiteral(ConvexParser.SpecialLiteralContext ctx) {
            String s = ctx.getStop().getText();
            ACell special = ReaderUtils.specialLiteral(s);
            if (special == null) {
                throw new ParseException("Invalid special literal: " + s);
            }
            this.push(special);
        }

        @Override
        public void enterCommented(ConvexParser.CommentedContext ctx) {
            this.pushList();
        }

        @Override
        public void exitCommented(ConvexParser.CommentedContext ctx) {
            this.popList();
        }

        @Override
        public void enterPathSymbol(ConvexParser.PathSymbolContext ctx) {
            this.pushList();
        }

        @Override
        public void exitPathSymbol(ConvexParser.PathSymbolContext ctx) {
            ArrayList<ACell> elements = this.popList();
            int n = elements.size();
            List lookup = elements.get(0);
            if (lookup == null) {
                throw new ParseException("Path must start with Address or Symbol");
            }
            for (int i = 1; i < n; ++i) {
                ACell sym = elements.get(i);
                if (!(sym instanceof Symbol)) {
                    throw new ParseException("Expected path element to be a symbol but got: " + String.valueOf(RT.getType(sym)));
                }
                lookup = List.create(Symbols.LOOKUP, lookup, sym);
            }
            this.push(lookup);
        }

        @Override
        public void enterAllForms(ConvexParser.AllFormsContext ctx) {
            this.pushList();
        }
    }
}

