/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.cvm.Context;
import convex.core.data.ACell;
import convex.core.data.ASet;
import convex.core.data.prim.CVMBool;
import convex.core.data.util.BlobBuilder;
import convex.core.lang.impl.ADataFn;

public class SetFn<T extends ACell>
extends ADataFn<CVMBool> {
    private ASet<T> set;

    SetFn(ASet<T> m) {
        this.set = m;
    }

    public static <T extends ACell> SetFn<T> wrap(ASet<T> m) {
        return new SetFn<T>(m);
    }

    @Override
    public Context invoke(Context context, ACell[] args) {
        int n = args.length;
        if (n == 1) {
            ACell key = args[0];
            CVMBool result = CVMBool.create(this.set.contains(key));
            return context.withResult(result);
        }
        return context.withArityError("Expected arity 1 for set lookup but got: " + n + " in set: " + String.valueOf(this.set));
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return this.set.print(sb, limit);
    }

    @Override
    public ACell toCanonical() {
        return this.set.getCanonical();
    }
}

