/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang;

import convex.core.ErrorCodes;
import convex.core.crypto.Hashing;
import convex.core.cvm.AFn;
import convex.core.cvm.AOp;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.Juice;
import convex.core.cvm.Keywords;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.State;
import convex.core.cvm.Symbols;
import convex.core.cvm.Syntax;
import convex.core.cvm.exception.ErrorValue;
import convex.core.cvm.exception.HaltValue;
import convex.core.cvm.exception.RecurValue;
import convex.core.cvm.exception.ReducedValue;
import convex.core.cvm.exception.ReturnValue;
import convex.core.cvm.exception.RollbackValue;
import convex.core.cvm.exception.TailcallValue;
import convex.core.cvm.ops.Special;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.ACountable;
import convex.core.data.ADataStructure;
import convex.core.data.AHashMap;
import convex.core.data.AIndex;
import convex.core.data.AList;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.ASet;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.List;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.SetLeaf;
import convex.core.data.Sets;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.APrimitive;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.Compiler;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.impl.CoreFn;
import convex.core.lang.impl.CorePred;
import convex.core.lang.impl.ICoreDef;
import convex.core.util.ErrorMessages;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SequencedCollection;

public class Core {
    public static final Address CORE_ADDRESS = Address.create(8L);
    public static final AHashMap<Symbol, ACell> ENVIRONMENT;
    public static final AHashMap<Symbol, AHashMap<ACell, ACell>> METADATA;
    public static final HashMap<Symbol, ACell> CORE_FORMS;
    public static final Symbol CORE_SYMBOL;
    private static final HashSet<ACell> tempReg;
    private static final ACell[] CODE_MAP;
    public static final CoreFn<AVector<ACell>> VECTOR;
    public static final CoreFn<ASequence<ACell>> CONCAT;
    public static final CoreFn<AVector<ACell>> VEC;
    public static final CoreFn<AVector<ACell>> REVERSE;
    public static final CoreFn<ASet<ACell>> SET;
    public static final CoreFn<ASet<ACell>> UNION;
    public static final CoreFn<ASet<ACell>> INTERSECTION;
    public static final CoreFn<ASet<ACell>> DIFFERENCE;
    public static final CoreFn<AList<ACell>> LIST;
    public static final CoreFn<AString> STR;
    public static final CoreFn<AString> PRINT;
    public static final CoreFn<AString> SPLIT;
    public static final CoreFn<AString> JOIN;
    public static final CoreFn<AString> NAME;
    public static final CoreFn<Keyword> KEYWORD;
    public static final CoreFn<Symbol> SYMBOL;
    public static final CoreFn<AOp<ACell>> COMPILE;
    public static final CoreFn<ACell> EVAL;
    public static final CoreFn<ACell> EVAL_AS;
    public static final CoreFn<ACell> QUERY_AS;
    public static final CoreFn<CVMLong> SCHEDULE_STAR;
    public static final CoreFn<Syntax> SYNTAX;
    public static final CoreFn<ACell> UNSYNTAX;
    public static final CoreFn<AHashMap<ACell, ACell>> META;
    public static final CoreFn<CVMBool> SYNTAX_Q;
    public static final CoreFn<ACell> EXPAND;
    public static final AFn<ACell> INITIAL_EXPANDER;
    public static final CoreFn<CVMBool> CALLABLE_Q;
    public static final CoreFn<Address> DEPLOY;
    public static final CoreFn<CVMLong> ACCEPT;
    public static final CoreFn<ACell> CALL_STAR;
    public static final CoreFn<Hash> LOG;
    public static final CoreFn<ACell> UNDEF_STAR;
    public static final CoreFn<ACell> LOOKUP;
    public static final CoreFn<Syntax> LOOKUP_META;
    public static final CoreFn<Address> ADDRESS;
    public static final CoreFn<ABlob> BLOB;
    public static final CoreFn<AccountStatus> ACCOUNT;
    public static final CoreFn<CVMLong> BALANCE;
    public static final CoreFn<CVMLong> TRANSFER;
    public static final CoreFn<CVMLong> SET_MEMORY;
    public static final CoreFn<CVMLong> TRANSFER_MEMORY;
    public static final CoreFn<CVMLong> SET_STAKE;
    public static final CoreFn<CVMLong> GET_STAKE;
    public static final CoreFn<CVMLong> GET_PEER_STAKE;
    public static final CoreFn<CVMLong> CREATE_PEER;
    public static final CoreFn<CVMLong> EVICT_PEER;
    public static final CoreFn<CVMLong> SET_PEER_DATA;
    public static final CoreFn<CVMLong> SET_PEER_STAKE;
    public static final CoreFn<AMap<?, ?>> HASHMAP;
    public static final CoreFn<Index> INDEX;
    public static final CoreFn<ASet<?>> HASHSET;
    public static final CoreFn<AVector<ACell>> KEYS;
    public static final CoreFn<AVector<ACell>> VALUES;
    public static final CoreFn<ADataStructure<ACell>> ASSOC;
    public static final CoreFn<ACell> ASSOC_IN;
    public static final CoreFn<ACell> GET_HOLDING;
    public static final CoreFn<ACell> SET_HOLDING;
    public static final CoreFn<ACell> SET_CONTROLLER;
    public static final CoreFn<ACell> SET_PARENT;
    public static final CoreFn<AccountKey> SET_KEY;
    public static final CoreFn<ACell> GET;
    public static final CoreFn<ACell> GET_IN;
    public static final CoreFn<CVMBool> CONTAINS_KEY_Q;
    public static final CoreFn<CVMBool> SUBSET_Q;
    public static final CoreFn<AMap<?, ?>> DISSOC;
    public static final CoreFn<ADataStructure<ACell>> CONJ;
    public static final CoreFn<ASet<ACell>> DISJ;
    public static final CoreFn<AList<ACell>> CONS;
    public static final CoreFn<ACell> FIRST;
    public static final CoreFn<ACell> SECOND;
    public static final CoreFn<ACell> LAST;
    public static final CoreFn<CVMBool> EQUALS;
    public static final CoreFn<CVMBool> EQ;
    public static final CoreFn<CVMBool> NE;
    public static final CoreFn<CVMBool> GE;
    public static final CoreFn<CVMBool> GT;
    public static final CoreFn<CVMBool> LE;
    public static final CoreFn<CVMBool> LT;
    public static final CoreFn<CVMBool> MIN;
    public static final CoreFn<CVMBool> MAX;
    public static final CoreFn<CVMLong> INC;
    public static final CoreFn<CVMLong> DEC;
    public static final CoreFn<CVMBool> BOOLEAN;
    public static final CoreFn<CVMBool> BOOLEAN_Q;
    public static final CoreFn<ABlob> ENCODING;
    public static final CoreFn<CVMLong> LONG;
    public static final CoreFn<AInteger> INT;
    public static final CoreFn<CVMDouble> DOUBLE;
    public static final CoreFn<CVMChar> CHAR;
    public static final CoreFn<CVMLong> BYTE;
    public static final CoreFn<APrimitive> PLUS;
    public static final CoreFn<APrimitive> MINUS;
    public static final CoreFn<APrimitive> TIMES;
    public static final CoreFn<CVMDouble> DIVIDE;
    public static final CoreFn<CVMDouble> FLOOR;
    public static final CoreFn<CVMDouble> CEIL;
    public static final CoreFn<CVMDouble> SQRT;
    public static final CoreFn<APrimitive> ABS;
    public static final CoreFn<CVMLong> SIGNUM;
    public static final CoreFn<AInteger> MOD;
    public static final CoreFn<AInteger> DIV;
    public static final CoreFn<AInteger> REM;
    public static final CoreFn<AInteger> QUOT;
    public static final CoreFn<ACell> QUOTE;
    public static final CoreFn<CVMDouble> POW;
    public static final CoreFn<CVMDouble> EXP;
    public static final CoreFn<CVMBool> NOT;
    public static final CoreFn<CVMLong> BIT_AND;
    public static final CoreFn<CVMLong> BIT_XOR;
    public static final CoreFn<CVMLong> BIT_OR;
    public static final CoreFn<CVMLong> BIT_NOT;
    public static final CoreFn<Hash> HASH;
    public static final CoreFn<Hash> KECCAK256;
    public static final CoreFn<Hash> SHA256;
    public static final CoreFn<CVMLong> COUNT;
    public static final CoreFn<ACell> EMPTY;
    public static final CoreFn<ACell> NTH;
    public static final CoreFn<ASequence<ACell>> NEXT;
    public static final CoreFn<ASequence<ACell>> SLICE;
    public static final CoreFn<?> RECUR;
    public static final CoreFn<?> TAILCALL_STAR;
    public static final CoreFn<?> ROLLBACK;
    public static final CoreFn<?> HALT;
    public static final CoreFn<?> RETURN;
    public static final CoreFn<CVMBool> FAIL;
    public static final CoreFn<?> APPLY;
    public static final CoreFn<ADataStructure<ACell>> INTO;
    public static final CoreFn<AHashMap<ACell, ACell>> MERGE;
    public static final CoreFn<ADataStructure<?>> MAP;
    public static final CoreFn<ACell> REDUCE;
    public static final CoreFn<ACell> REDUCED;
    public static final CoreFn<CVMBool> NIL_Q;
    public static final CoreFn<CVMBool> VECTOR_Q;
    public static final CoreFn<CVMBool> LIST_Q;
    public static final CoreFn<CVMBool> SET_Q;
    public static final CoreFn<CVMBool> MAP_Q;
    public static final CoreFn<CVMBool> COLL_Q;
    public static final CoreFn<CVMBool> COUNTABLE_Q;
    public static final CoreFn<CVMBool> EMPTY_Q;
    public static final CoreFn<CVMBool> SYMBOL_Q;
    public static final CoreFn<CVMBool> KEYWORD_Q;
    public static final CoreFn<CVMBool> BLOB_Q;
    public static final CoreFn<CVMBool> ADDRESS_Q;
    public static final CoreFn<CVMBool> LONG_Q;
    public static final CoreFn<CVMBool> INT_Q;
    public static final CoreFn<CVMBool> DOUBLE_Q;
    public static final CoreFn<CVMBool> STR_Q;
    public static final CoreFn<CVMBool> NUMBER_Q;
    public static final CoreFn<CVMBool> NAN_Q;
    public static final CoreFn<CVMBool> FN_Q;
    public static final CoreFn<CVMBool> ZERO_Q;
    private static AMap<Symbol, AHashMap<ACell, ACell>> METAS;

    private static <T extends ACell> T reg(T o) {
        if (tempReg.contains(o = Cells.intern(o))) {
            throw new Error("Duplicate core form! = " + String.valueOf(o));
        }
        tempReg.add(o);
        if (o instanceof ICoreDef) {
            ICoreDef cd = (ICoreDef)((Object)o);
            Symbol stm = cd.getSymbol();
            Symbol implicitForm = Symbol.create("#%" + stm.getName().toString());
            CORE_FORMS.put(implicitForm, o);
        } else {
            System.err.println("Not a core Def: " + String.valueOf(o));
        }
        return o;
    }

    private static final Context reduceResult(Context ctx) {
        Object ex = ctx.getValue();
        if (ex instanceof ReducedValue) {
            ctx = ctx.withResult(((ReducedValue)ex).getValue());
        }
        return ctx.consumeJuice(100L);
    }

    static Symbol symbolFor(ACell o) {
        if (o instanceof CoreFn) {
            return ((CoreFn)o).getSymbol();
        }
        throw new Error("Cant get symbol for object of type " + String.valueOf(o.getClass()));
    }

    private static AHashMap<Symbol, ACell> register(AHashMap<Symbol, ACell> env, ACell o) {
        Symbol sym = Core.symbolFor(o);
        if (o instanceof ICoreDef) {
            Core.registerCode((ICoreDef)((Object)o));
        }
        assert (!env.containsKey(sym)) : "Duplicate core declaration: " + String.valueOf(sym);
        return env.assoc(sym, o);
    }

    static void registerCode(ICoreDef o) {
        int code = o.getCoreCode();
        ACell there = CODE_MAP[code];
        if (there != null) {
            throw new Error("Code duplicte (" + code + "): " + String.valueOf(o) + " clashes with " + String.valueOf(there));
        }
        Core.CODE_MAP[code] = (ACell)((Object)o);
    }

    private static Context registerCoreCode(AHashMap<Symbol, ACell> env) throws IOException {
        State state = State.EMPTY;
        int i = 0;
        while ((long)i <= CORE_ADDRESS.longValue()) {
            state = state.putAccount(Address.create(i), AccountStatus.createActor());
            ++i;
        }
        Context ctx = Context.create(state, CORE_ADDRESS);
        for (Map.Entry me : env.entrySet()) {
            ctx = ctx.define((Symbol)me.getKey(), (ACell)me.getValue());
        }
        ACell form = null;
        AList<ACell> forms = Reader.readAll(Utils.readResourceAsString("/convex/core/core.cvx"));
        for (ACell f : forms) {
            form = f;
            if ((ctx = ctx.expandCompile(form)).isExceptional()) {
                throw new Error("Error compiling core code form: " + String.valueOf(form) + "\nException : " + String.valueOf(ctx.getExceptional()));
            }
            AOp op = (AOp)ctx.getResult();
            if (!(ctx = ctx.exec(op)).isExceptional()) continue;
            throw new Error("Error executing form: " + String.valueOf(form) + "\n\nException : " + ctx.getExceptional().toString());
        }
        return ctx;
    }

    private static Context applyDocumentation(Context ctx) throws IOException {
        for (Map.Entry<Symbol, AHashMap<ACell, ACell>> entry : METAS.entrySet()) {
            try {
                Object value;
                Symbol sym = entry.getKey();
                AMap meta = entry.getValue();
                MapEntry<Object, Object> definedEntry = ctx.getEnvironment().getEntry(sym);
                if (definedEntry == null) {
                    AHashMap doc = (AHashMap)meta.get(Keywords.DOC_META);
                    if (doc == null) {
                        System.err.println("CORE WARNING: Missing :doc tag in metadata for: " + String.valueOf(sym));
                        continue;
                    }
                    if (meta.get(Keywords.SPECIAL_META) == CVMBool.TRUE) {
                        ACell val = sym;
                        Special spec = Special.forSymbol(sym);
                        if (spec != null) {
                            val = spec;
                        }
                        ctx = ctx.define(sym, val);
                        definedEntry = MapEntry.create(sym, val);
                    } else {
                        System.err.println("CORE WARNING: Documentation for non-existent core symbol: " + String.valueOf(sym));
                        continue;
                    }
                }
                if ((value = definedEntry.getValue()) instanceof ICoreDef) {
                    meta = meta.assoc(Keywords.STATIC, CVMBool.TRUE);
                }
                ctx = ctx.defineWithSyntax(Syntax.create(sym, meta), (ACell)value);
            }
            catch (IllegalArgumentException ex) {
                throw new Error("Error applying documentation:  " + String.valueOf(entry), ex);
            }
        }
        return ctx;
    }

    public static ACell fromCode(long code) throws BadFormatException {
        if (code < 0L || code >= (long)CODE_MAP.length) {
            return null;
        }
        ACell o = CODE_MAP[(int)code];
        return o;
    }

    public static void main(String ... args) {
    }

    static {
        CORE_FORMS = new HashMap();
        CORE_SYMBOL = Symbol.create("convex.core");
        tempReg = new HashSet();
        CODE_MAP = new ACell[512];
        VECTOR = Core.reg(new CoreFn<AVector<ACell>>(Symbols.VECTOR, 1){

            @Override
            public Context invoke(Context context, ACell[] args) {
                long juice = 50L + (long)args.length * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector result = Vectors.wrap(args);
                return context.withResult(juice, result);
            }
        });
        CONCAT = Core.reg(new CoreFn<ASequence<ACell>>(Symbols.CONCAT, 2){

            @Override
            public Context invoke(Context context, ACell[] args) {
                ASequence<?> result = null;
                int n = args.length;
                long juice = 5L;
                for (int ix = 0; ix < n; ++ix) {
                    ACell a = args[ix];
                    if (a == null) continue;
                    ASequence seq = RT.sequence(a);
                    if (seq == null) {
                        return context.withCastError(ix, args, Types.SEQUENCE);
                    }
                    if (!context.checkJuice(juice += 50L + seq.count() * 50L)) {
                        return context.withJuiceError();
                    }
                    result = RT.concat(result, seq);
                }
                return context.withResult(juice, result);
            }
        });
        VEC = Core.reg(new CoreFn<AVector<ACell>>(Symbols.VEC, 3){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                Long n = RT.count(o);
                if (n == null) {
                    return context.withCastError(0, args, Types.VECTOR);
                }
                long juice = 50L + n * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector result = RT.castVector(o);
                return context.withResult(juice, result);
            }
        });
        REVERSE = Core.reg(new CoreFn<AVector<ACell>>(Symbols.REVERSE, 4){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                ASequence seq = RT.ensureSequence(o);
                if (seq == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                long juice = 50L;
                SequencedCollection result = seq.reversed();
                return context.withResult(juice, (ACell)((Object)result));
            }
        });
        SET = Core.reg(new CoreFn<ASet<ACell>>(Symbols.SET, 5){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                Long n = RT.count(o);
                if (n == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                long juice = Juice.addMul(50L, n, 50L);
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ASet result = RT.castSet(o);
                if (result == null) {
                    return context.withCastError(0, args, Types.SET);
                }
                return context.withResult(juice, result);
            }
        });
        UNION = Core.reg(new CoreFn<ASet<ACell>>(Symbols.UNION, 6){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                ASet result = Sets.empty();
                long juice = 50L;
                for (int i = 0; i < n; ++i) {
                    ACell arg = args[i];
                    ASet set = RT.ensureSet(arg);
                    if (set == null) {
                        return context.withCastError(i, args, Types.SET);
                    }
                    long size = set.count();
                    if (!context.checkJuice(juice = Juice.addMul(juice, size, 50L))) {
                        return context.withJuiceError();
                    }
                    result = ((ASet)result).includeAll(set);
                }
                return context.withResult(juice, result);
            }
        });
        INTERSECTION = Core.reg(new CoreFn<ASet<ACell>>(Symbols.INTERSECTION, 7){

            @Override
            public Context invoke(Context context, ACell[] args) {
                ASet result;
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                int n = args.length;
                ACell arg0 = args[0];
                ASet aSet = result = arg0 == null ? Sets.empty() : RT.ensureSet(arg0);
                if (result == null) {
                    return context.withCastError(0, args, Types.SET);
                }
                long juice = 50L;
                for (int i = 1; i < n; ++i) {
                    SetLeaf set;
                    ACell arg = args[i];
                    ASet aSet2 = set = arg == null ? Sets.empty() : RT.ensureSet(args[i]);
                    if (set == null) {
                        return context.withCastError(i, args, Types.SET);
                    }
                    long size = set.count();
                    if (!context.checkJuice(juice = Juice.addMul(juice, size, 50L))) {
                        return context.withJuiceError();
                    }
                    result = result.intersectAll(set);
                }
                return context.withResult(juice, result);
            }
        });
        DIFFERENCE = Core.reg(new CoreFn<ASet<ACell>>(Symbols.DIFFERENCE, 8){

            @Override
            public Context invoke(Context context, ACell[] args) {
                ASet result;
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                int n = args.length;
                ACell arg0 = args[0];
                ASet aSet = result = arg0 == null ? Sets.empty() : RT.ensureSet(arg0);
                if (result == null) {
                    return context.withCastError(0, args, Types.SET);
                }
                long juice = 50L;
                for (int i = 1; i < n; ++i) {
                    ACell arg = args[i];
                    ASet set = RT.ensureSet(arg);
                    if (set == null) {
                        return context.withCastError(i, args, Types.SET);
                    }
                    long size = set.count();
                    if (!context.checkJuice(juice = Juice.addMul(juice, size, 50L))) {
                        return context.withJuiceError();
                    }
                    result = result.excludeAll(set);
                }
                return context.withResult(juice, result);
            }
        });
        LIST = Core.reg(new CoreFn<AList<ACell>>(Symbols.LIST, 9){

            @Override
            public Context invoke(Context context, ACell[] args) {
                long juice = Juice.buildDataCost(args.length);
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                List result = List.create(args);
                return context.withResult(juice, result);
            }
        });
        STR = Core.reg(new CoreFn<AString>(Symbols.STR, 10){

            @Override
            public Context invoke(Context context, ACell[] args) {
                AString result = RT.str(args);
                if (result == null) {
                    return context.withCastError(Types.STRING);
                }
                long juice = Juice.buildStringCost(result.count());
                return context.withResult(juice, result);
            }
        });
        PRINT = Core.reg(new CoreFn<AString>(Symbols.PRINT, 11){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                long limit = Juice.limitString(context);
                AString result = RT.print(args[0], limit);
                if (result == null) {
                    return context.withJuiceError();
                }
                long juice = Juice.buildStringCost(result.count());
                return context.withResult(juice, result);
            }
        });
        SPLIT = Core.reg(new CoreFn<AString>(Symbols.SPLIT, 12){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AString str = RT.ensureString(args[0]);
                if (str == null) {
                    return context.withCastError(0, args, Types.STRING);
                }
                CVMChar ch = RT.ensureChar(args[1]);
                if (ch == null) {
                    return context.withCastError(1, args, Types.CHARACTER);
                }
                long strlen = str.count();
                long strcost = Juice.buildStringCost(strlen);
                if (!context.checkJuice(strcost)) {
                    return context.withJuiceError();
                }
                AVector<AString> result = str.split(ch);
                long juice = strcost + Juice.buildDataCost(result.count());
                return context.withResult(juice, result);
            }
        });
        JOIN = Core.reg(new CoreFn<AString>(Symbols.JOIN, 13){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                ASequence<AString> strs = RT.ensureSequence(args[0]);
                if (strs == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                CVMChar ch = RT.ensureChar(args[1]);
                if (ch == null) {
                    return context.withCastError(1, args, Types.CHARACTER);
                }
                AString result = Strings.join(strs, ch);
                if (result == null) {
                    return context.withError(ErrorCodes.CAST, "Element in join is not a String.");
                }
                long juice = Juice.buildStringCost(result.count());
                return context.withResult(juice, result);
            }
        });
        NAME = Core.reg(new CoreFn<AString>(Symbols.NAME, 14){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell arg = args[0];
                AString result = RT.name(arg);
                if (result == null) {
                    return context.withCastError(0, args, Types.STRING);
                }
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        KEYWORD = Core.reg(new CoreFn<Keyword>(Symbols.KEYWORD, 15){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell arg = args[0];
                if (arg instanceof Keyword) {
                    return context.withResult(20L, arg);
                }
                AString name = RT.name(arg);
                if (name == null) {
                    return context.withCastError(0, args, Types.KEYWORD);
                }
                Keyword result = Keyword.create(name);
                if (result == null) {
                    return context.withArgumentError("Invalid Keyword name, must be between 1 and 128 characters");
                }
                return context.withResult(20L, result);
            }
        });
        SYMBOL = Core.reg(new CoreFn<Symbol>(Symbols.SYMBOL, 16){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell maybeName = args[n - 1];
                if (maybeName instanceof Symbol) {
                    Symbol sym = (Symbol)maybeName;
                    return context.withResult(20L, sym);
                }
                AString name = RT.name(maybeName);
                if (name == null) {
                    return context.withCastError(0, args, Types.SYMBOL);
                }
                Symbol sym = Symbol.create(name);
                if (sym == null) {
                    return context.withArgumentError("Invalid Symbol name, must be between 1 and 128 characters");
                }
                long juice = 20L;
                return context.withResult(juice, sym);
            }
        });
        COMPILE = Core.reg(new CoreFn<AOp<ACell>>(Symbols.COMPILE, 257){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell form = args[0];
                return context.expandCompile(form);
            }
        });
        EVAL = Core.reg(new CoreFn<ACell>(Symbols.EVAL, 17){

            @Override
            public Context invoke(Context context, ACell[] args) {
                AOp op;
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell form = args[0];
                if (form instanceof AOp) {
                    op = (AOp)form;
                } else {
                    if ((context = context.expandCompile(form)).isExceptional()) {
                        return context;
                    }
                    op = (AOp)context.getResult();
                }
                Context rctx = context.exec(op);
                return rctx.consumeJuice(500L);
            }
        });
        EVAL_AS = Core.reg(new CoreFn<ACell>(Symbols.EVAL_AS, 18){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                ACell form = args[1];
                Context rctx = context.evalAs(address, form);
                return rctx.consumeJuice(500L);
            }
        });
        QUERY_AS = Core.reg(new CoreFn<ACell>(Symbols.QUERY_AS, 19){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                ACell form = args[1];
                Context rctx = context.queryAs(address, form);
                return rctx.consumeJuice(500L);
            }
        });
        SCHEDULE_STAR = Core.reg(new CoreFn<CVMLong>(Symbols.SCHEDULE_STAR, 20){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 2) {
                    return context.withArityError(this.exactArityMessage(3, n));
                }
                CVMLong tso = RT.ensureLong(args[0]);
                if (tso == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                long scheduleTimestamp = tso.longValue();
                ACell opo = args[1];
                if (!(opo instanceof AOp)) {
                    return context.withCastError(1, args, Types.OP);
                }
                AOp op = (AOp)opo;
                return context.schedule(scheduleTimestamp, op);
            }
        });
        SYNTAX = Core.reg(new CoreFn<Syntax>(Symbols.SYNTAX, 21){

            @Override
            public Context invoke(Context context, ACell[] args) {
                Syntax result;
                int n = args.length;
                if (n < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                if (n > 2) {
                    return context.withArityError(this.maxArityMessage(2, args.length));
                }
                if (n == 1) {
                    result = Syntax.create(args[0]);
                } else {
                    AHashMap<ACell, ACell> meta = RT.ensureHashMap(args[1]);
                    if (meta == null) {
                        return context.withCastError(1, args, Types.MAP);
                    }
                    result = Syntax.create(args[0], meta);
                }
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        UNSYNTAX = Core.reg(new CoreFn<ACell>(Symbols.UNSYNTAX, 22){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell result = (ACell)Syntax.unwrap(args[0]);
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        META = Core.reg(new CoreFn<AHashMap<ACell, ACell>>(Symbols.META, 23){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                AHashMap<ACell, ACell> result = a instanceof Syntax ? ((Syntax)a).getMeta() : null;
                long juice = 10L;
                return context.withResult(juice, result);
            }
        });
        SYNTAX_Q = Core.reg(new CorePred(Symbols.SYNTAX_Q, 24){

            @Override
            public boolean test(ACell val) {
                return val instanceof Syntax;
            }
        });
        EXPAND = Core.reg(new CoreFn<ACell>(Symbols.EXPAND, 258){

            @Override
            public Context invoke(Context context, ACell[] args) {
                ACell contArg;
                AFn expander;
                int n = args.length;
                if (n < 1 || n > 3) {
                    return context.withArityError(this.name() + " requires a form argument, optional expander and optional continuation expander (arity 1, 2 or 2)");
                }
                if (n >= 2) {
                    ACell exArg = args[1];
                    expander = RT.ensureFunction(exArg);
                    if (expander == null) {
                        return context.withCastError(1, args, Types.FUNCTION);
                    }
                } else {
                    expander = Compiler.INITIAL_EXPANDER;
                }
                AFn cont = expander;
                if (n >= 3 && (cont = RT.ensureFunction(contArg = args[2])) == null) {
                    return context.withCastError(2, args, Types.FUNCTION);
                }
                ACell form = args[0];
                Context rctx = context.expand(expander, form, cont);
                return rctx;
            }
        });
        INITIAL_EXPANDER = Core.reg(Compiler.INITIAL_EXPANDER);
        CALLABLE_Q = Core.reg(new CoreFn<CVMBool>(Symbols.CALLABLE_Q, 30){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length == 1) {
                    Address addr = RT.callableAddress(args[0]);
                    if (addr == null) {
                        return context.withResult(15L, CVMBool.FALSE);
                    }
                    AccountStatus as = context.getState().getAccount(addr);
                    return context.withResult(15L, CVMBool.create(as != null));
                }
                if (args.length != 2) {
                    return context.withArityError(this.rangeArityMessage(1, 2, args.length));
                }
                Symbol sym = RT.ensureSymbol(args[1]);
                if (sym == null) {
                    return context.withCastError(1, args, Types.SYMBOL);
                }
                ACell a0 = args[0];
                Address addr = RT.callableAddress(a0);
                if (addr == null) {
                    return context.withResult(15L, CVMBool.FALSE);
                }
                AccountStatus as = context.getState().getAccount(addr);
                if (as == null) {
                    return context.withResult(15L, CVMBool.FALSE);
                }
                AFn fn = as.getCallableFunction(sym);
                CVMBool result = CVMBool.create(fn != null);
                return context.withResult(15L, result);
            }
        });
        DEPLOY = Core.reg(new CoreFn<Address>(Symbols.DEPLOY, 387){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                return context.deploy(args);
            }
        });
        ACCEPT = Core.reg(new CoreFn<CVMLong>(Symbols.ACCEPT, 385){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMLong amount = RT.ensureLong(args[0]);
                if (amount == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.acceptFunds(amount.longValue());
            }
        });
        CALL_STAR = Core.reg(new CoreFn<ACell>(Symbols.CALL_STAR, 386){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length < 3) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                Context ctx = context.consumeJuice(100L);
                if (ctx.isExceptional()) {
                    return ctx;
                }
                ACell target = args[0];
                CVMLong sendAmount = RT.ensureLong(args[1]);
                if (sendAmount == null) {
                    return ctx.withCastError(1, args, Types.LONG);
                }
                Symbol sym = RT.ensureSymbol(args[2]);
                if (sym == null) {
                    return ctx.withCastError(2, args, Types.SYMBOL);
                }
                int arity = args.length - 3;
                ACell[] callArgs = Arrays.copyOfRange(args, 3, 3 + arity);
                return ctx.actorCall(target, sendAmount.longValue(), sym, callArgs);
            }
        });
        LOG = Core.reg(new CoreFn<Hash>(Symbols.LOG, 384){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                long juice = 1050L + (long)n * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector<ACell> values = Vectors.create(args);
                context = context.appendLog(values);
                return context.withResult(juice, values);
            }
        });
        UNDEF_STAR = Core.reg(new CoreFn<ACell>(Symbols.UNDEF_STAR, 31){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                Symbol sym = RT.ensureSymbol(args[0]);
                if (sym == null) {
                    return context.withArgumentError("Invalid Symbol name for undef: " + Utils.toString(args[0]));
                }
                Context ctx = context.undefine(sym);
                return ctx.withResult(100L, null);
            }
        });
        LOOKUP = Core.reg(new CoreFn<ACell>(Symbols.LOOKUP, 32){

            @Override
            public Context invoke(Context context, ACell[] args) {
                Address address;
                int n = args.length;
                if (n < 1 || n > 2) {
                    return context.withArityError(this.rangeArityMessage(1, 2, args.length));
                }
                Address address2 = address = n == 1 ? context.getAddress() : RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                ACell symArg = args[n - 1];
                Symbol sym = RT.ensureSymbol(symArg);
                if (sym == null) {
                    return context.withCastError(n - 1, args, Types.SYMBOL);
                }
                MapEntry<Symbol, ACell> me = context.lookupDynamicEntry(address, sym);
                long juice = 15L;
                Object result = me == null ? null : me.getValue();
                return context.withResult(juice, (ACell)result);
            }
        });
        LOOKUP_META = Core.reg(new CoreFn<Syntax>(Symbols.LOOKUP_META, 33){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n < 1 || n > 2) {
                    return context.withArityError(this.rangeArityMessage(1, 2, args.length));
                }
                Address address = null;
                if (n > 1 && (address = RT.ensureAddress(args[0])) == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                ACell symArg = args[n - 1];
                Symbol sym = RT.ensureSymbol(symArg);
                if (sym == null) {
                    return context.withCastError(n - 1, args, Types.SYMBOL);
                }
                AHashMap<ACell, ACell> result = context.lookupMeta(address, sym);
                long juice = 15L;
                return context.withResult(juice, result);
            }
        });
        ADDRESS = Core.reg(new CoreFn<Address>(Symbols.ADDRESS, 34){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                Address address = RT.castAddress(o);
                if (address == null) {
                    if (o instanceof ABlob) {
                        return context.withArgumentError("Blob not convertible a valid Address");
                    }
                    if (o instanceof AInteger) {
                        return context.withArgumentError("Integer value is not a valid Address");
                    }
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                long juice = 20L;
                return context.withResult(juice, address);
            }
        });
        BLOB = Core.reg(new CoreFn<ABlob>(Symbols.BLOB, 35){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ABlob blob = RT.castBlob(args[0]);
                if (blob == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                long juice = Juice.buildBlobCost(blob.count());
                return context.withResult(juice, blob);
            }
        });
        ACCOUNT = Core.reg(new CoreFn<AccountStatus>(Symbols.ACCOUNT, 36){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a0 = args[0];
                Address address = RT.ensureAddress(a0);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                AccountStatus as = context.getAccountStatus(address);
                return context.withResult(20L, as);
            }
        });
        BALANCE = Core.reg(new CoreFn<CVMLong>(Symbols.BALANCE, 37){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                AccountStatus as = context.getAccountStatus(address);
                CVMLong balance = as != null ? CVMLong.create(as.getBalance()) : null;
                return context.withResult(50L, balance);
            }
        });
        TRANSFER = Core.reg(new CoreFn<CVMLong>(Symbols.TRANSFER, 38){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                CVMLong amount = RT.ensureLong(args[1]);
                if (amount == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                return context.transfer(address, amount.longValue()).consumeJuice(200L);
            }
        });
        SET_MEMORY = Core.reg(new CoreFn<CVMLong>(Symbols.SET_MEMORY, 39){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMLong amount = RT.ensureLong(args[0]);
                if (amount == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.setMemory(amount.longValue()).consumeJuice(200L);
            }
        });
        TRANSFER_MEMORY = Core.reg(new CoreFn<CVMLong>(Symbols.TRANSFER_MEMORY, 40){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                CVMLong amount = RT.ensureLong(args[1]);
                if (amount == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                return context.transferMemoryAllowance(address, amount).consumeJuice(200L);
            }
        });
        SET_STAKE = Core.reg(new CoreFn<CVMLong>(Symbols.SET_STAKE, 64){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                ABlob b = RT.ensureBlob(args[0]);
                if (b == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                AccountKey accountKey = AccountKey.create(b);
                if (accountKey == null) {
                    return context.withArgumentError("Peer Key for stake must be 32 bytes");
                }
                CVMLong amount = RT.ensureLong(args[1]);
                if (amount == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                return context.setDelegatedStake(accountKey, amount.longValue()).consumeJuice(200L);
            }
        });
        GET_STAKE = Core.reg(new CoreFn<CVMLong>(Symbols.GET_STAKE, 69){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                ABlob b = RT.ensureBlob(args[0]);
                if (b == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                AccountKey accountKey = AccountKey.create(b);
                if (accountKey == null) {
                    return context.withArgumentError("Peer Key must be 32 bytes");
                }
                Address acct = RT.ensureAddress(args[1]);
                if (acct == null) {
                    return context.withCastError(1, args, Types.ADDRESS);
                }
                PeerStatus ps = context.getState().getPeer(accountKey);
                CVMLong stake = ps == null ? null : CVMLong.create(ps.getDelegatedStake(acct));
                return context.withResult(15L, stake);
            }
        });
        GET_PEER_STAKE = Core.reg(new CoreFn<CVMLong>(Symbols.GET_PEER_STAKE, 70){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ABlob b = RT.ensureBlob(args[0]);
                if (b == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                AccountKey accountKey = AccountKey.create(b);
                if (accountKey == null) {
                    return context.withArgumentError("Peer Key must be 32 bytes");
                }
                PeerStatus ps = context.getState().getPeer(accountKey);
                CVMLong stake = ps == null ? null : CVMLong.create(ps.getPeerStake());
                return context.withResult(15L, stake);
            }
        });
        CREATE_PEER = Core.reg(new CoreFn<CVMLong>(Symbols.CREATE_PEER, 65){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AccountKey accountKey = RT.ensureAccountKey(args[0]);
                if (accountKey == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                CVMLong amount = RT.ensureLong(args[1]);
                if (amount == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                return context.createPeer(accountKey, amount.longValue()).consumeJuice(1000L);
            }
        });
        EVICT_PEER = Core.reg(new CoreFn<CVMLong>(Symbols.EVICT_PEER, 68){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                AccountKey accountKey = RT.ensureAccountKey(args[0]);
                if (accountKey == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                if ((context = context.consumeJuice(1000L)).isExceptional()) {
                    return context;
                }
                return context.evictPeer(accountKey);
            }
        });
        SET_PEER_DATA = Core.reg(new CoreFn<CVMLong>(Symbols.SET_PEER_DATA, 66){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                AccountKey peerKey = RT.ensureAccountKey(args[0]);
                if (peerKey == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                AHashMap<ACell, ACell> data = RT.ensureHashMap(args[1]);
                if (data == null) {
                    return context.withCastError(1, args, Types.MAP);
                }
                long juice = 1000L;
                if ((context = context.consumeJuice(juice)).isExceptional()) {
                    return context;
                }
                return context.setPeerData(peerKey, data);
            }
        });
        SET_PEER_STAKE = Core.reg(new CoreFn<CVMLong>(Symbols.SET_PEER_STAKE, 67){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AccountKey peerKey = RT.ensureAccountKey(args[0]);
                if (peerKey == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                CVMLong newStake = RT.ensureLong(args[1]);
                if (newStake == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                long targetStake = newStake.longValue();
                if ((context = context.consumeJuice(1000L)).isExceptional()) {
                    return context;
                }
                return context.setPeerStake(peerKey, targetStake);
            }
        });
        HASHMAP = Core.reg(new CoreFn<AMap<?, ?>>(Symbols.HASH_MAP, 80){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int len = args.length;
                if (Utils.isOdd(len)) {
                    return context.withArityError(this.name() + " requires an even number of arguments");
                }
                long juice = 50L + (long)len * 50L;
                return context.withResult(juice, (ACell)Maps.create(args));
            }
        });
        INDEX = Core.reg(new CoreFn<Index>(Symbols.INDEX, 81){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int len = args.length;
                if (Utils.isOdd(len)) {
                    return context.withArityError(this.name() + " requires an even number of arguments");
                }
                long juice = 50L + (long)len * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AIndex r = Index.none();
                int n = len / 2;
                for (int i = 0; i < n; ++i) {
                    int ix = i * 2;
                    ACell k = args[ix];
                    ACell v = args[ix + 1];
                    if ((r = r.assoc(k, v)) != null) continue;
                    return context.withArgumentError("Cannot have a key of Type " + String.valueOf(RT.getType(k)) + " in Index");
                }
                return context.withResult(juice, r);
            }
        });
        HASHSET = Core.reg(new CoreFn<ASet<?>>(Symbols.HASH_SET, 82){

            @Override
            public Context invoke(Context context, ACell[] args) {
                long juice = 50L + (long)args.length * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                return context.withResult(juice, Sets.of(args));
            }
        });
        KEYS = Core.reg(new CoreFn<AVector<ACell>>(Symbols.KEYS, 83){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                if (!(a instanceof AMap)) {
                    return context.withCastError(0, args, Types.MAP);
                }
                AMap m = (AMap)a;
                long juice = 50L + m.count() * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector keys = RT.keys(m);
                return context.withResult(juice, keys);
            }
        });
        VALUES = Core.reg(new CoreFn<AVector<ACell>>(Symbols.VALUES, 84){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                if (!(a instanceof AMap)) {
                    return context.withCastError(0, args, Types.MAP);
                }
                AMap m = (AMap)a;
                long juice = 50L + m.count() * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector keys = RT.values(m);
                return context.withResult(juice, keys);
            }
        });
        ASSOC = Core.reg(new CoreFn<ADataStructure<ACell>>(Symbols.ASSOC, 85){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n < 1) {
                    return context.withArityError(this.minArityMessage(1, n));
                }
                if (!Utils.isOdd(n)) {
                    return context.withArityError(this.name() + " requires key/value pairs as successive args");
                }
                long juice = 50L + (long)(n - 1) * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ACell o = args[0];
                ADataStructure<?> result = RT.ensureAssociative(o);
                if (o != null && result == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                for (int i = 1; i < n; i += 2) {
                    ACell key = args[i];
                    if ((result = RT.assoc(result, key, args[i + 1])) != null) continue;
                    return context.withError(ErrorCodes.ARGUMENT, "Cannot assoc value - invalid (key type " + String.valueOf(RT.getType(key)) + " is invalid or out of bounds)");
                }
                return context.withResult(juice, result);
            }
        });
        ASSOC_IN = Core.reg(new CoreFn<ACell>(Symbols.ASSOC_IN, 86){

            @Override
            public Context invoke(Context context, ACell[] args) {
                Object k;
                ADataStructure struct;
                int i;
                if (args.length != 3) {
                    return context.withArityError(this.exactArityMessage(3, args.length));
                }
                ASequence ixs = RT.ensureSequence(args[1]);
                if (ixs == null) {
                    return context.withCastError(1, args, Types.SEQUENCE);
                }
                int n = ixs.size();
                long juice = 180L * (1L + (long)n);
                ACell data = args[0];
                ADataStructure value = args[2];
                if (n == 0) {
                    return context.withResult(juice, value);
                }
                ADataStructure[] ass = new ADataStructure[n];
                ACell[] ks = new ACell[n];
                for (i = 0; i < n; ++i) {
                    struct = RT.ensureAssociative(data);
                    if (struct == null) {
                        return context.withCastError(data, (AType)Types.DATA_STRUCTURE);
                    }
                    ass[i] = struct;
                    ks[i] = k = ixs.get(i);
                    data = struct.get((ACell)k);
                }
                for (i = n - 1; i >= 0; --i) {
                    struct = ass[i];
                    k = ks[i];
                    if ((value = RT.assoc(struct, (ACell)k, value)) != null) continue;
                    return context.withError(ErrorCodes.ARGUMENT, "Invalid key of type " + String.valueOf(RT.getType((ACell)k)) + " or value of type " + String.valueOf(RT.getType(value)) + " for " + this.name());
                }
                return context.withResult(juice, value);
            }
        });
        GET_HOLDING = Core.reg(new CoreFn<ACell>(Symbols.GET_HOLDING, 96){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, n));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(args[0], (AType)Types.ADDRESS);
                }
                Index<Address, ACell> holdings = context.getHoldings();
                ACell result = holdings == null ? null : holdings.get(address);
                return context.withResult(15L, result);
            }
        });
        SET_HOLDING = Core.reg(new CoreFn<ACell>(Symbols.SET_HOLDING, 97){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 2) {
                    return context.withArityError(this.exactArityMessage(2, n));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(args[0], (AType)Types.ADDRESS);
                }
                ACell result = args[1];
                if ((context = context.setHolding(address, result)).isExceptional()) {
                    return context;
                }
                return context.withResult(150L, result);
            }
        });
        SET_CONTROLLER = Core.reg(new CoreFn<ACell>(Symbols.SET_CONTROLLER, 98){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, n));
                }
                ACell arg = args[0];
                ACell controller = null;
                if (arg != null) {
                    Address controlAddress = RT.callableAddress(arg);
                    if (controlAddress == null) {
                        return context.withError(ErrorCodes.CAST, this.name() + " requires an Address or scoped Actor");
                    }
                    if (!context.getState().hasAccount(controlAddress)) {
                        return context.withError(ErrorCodes.NOBODY, this.name() + " requires an address for an existing account");
                    }
                    controller = arg;
                }
                if ((context = context.setController(controller)).isExceptional()) {
                    return context;
                }
                return context.withResult(150L, controller);
            }
        });
        SET_PARENT = Core.reg(new CoreFn<ACell>(Symbols.SET_PARENT, 99){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, n));
                }
                ACell arg = args[0];
                Address parent = null;
                if (arg != null) {
                    Address parentAddress = RT.ensureAddress(arg);
                    if (parentAddress == null) {
                        return context.withError(ErrorCodes.CAST, this.name() + " requires an Address or nil");
                    }
                    if (!context.getState().hasAccount(parentAddress)) {
                        return context.withError(ErrorCodes.NOBODY, this.name() + " requires an address for an existing account");
                    }
                    if (parentAddress.equals(context.getAddress())) {
                        return context.withError(ErrorCodes.ARGUMENT, "Can't set parent of account to itself!");
                    }
                    parent = parentAddress;
                }
                if ((context = context.setParent(parent)).isExceptional()) {
                    return context;
                }
                return context.withResult(150L, parent);
            }
        });
        SET_KEY = Core.reg(new CoreFn<AccountKey>(Symbols.SET_KEY, 100){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, n));
                }
                ACell arg = args[0];
                AccountKey publicKey = null;
                if (arg != null) {
                    ABlob b = RT.ensureBlob(arg);
                    if (b == null) {
                        return context.withCastError(arg, (AType)Types.BLOB);
                    }
                    publicKey = AccountKey.create(b);
                    if (publicKey == null) {
                        return context.withArgumentError("Invalid key length");
                    }
                }
                if ((context = context.setAccountKey(publicKey)).isExceptional()) {
                    return context;
                }
                return context.withResult(150L, publicKey);
            }
        });
        GET = Core.reg(new CoreFn<ACell>(Symbols.GET, 112){

            @Override
            public Context invoke(Context context, ACell[] args) {
                ACell result;
                int n = args.length;
                if (n < 2 || n > 3) {
                    return context.withArityError(this.name() + " requires exactly 2 or 3 arguments");
                }
                ACell coll = args[0];
                if (coll == null) {
                    result = n == 3 ? args[2] : null;
                } else if (n == 2) {
                    gettable = RT.ensureDataStructure(coll);
                    if (gettable == null) {
                        return context.withCastError(coll, (AType)Types.DATA_STRUCTURE);
                    }
                    result = gettable.get(args[1]);
                } else {
                    gettable = RT.ensureDataStructure(coll);
                    if (gettable == null) {
                        return context.withCastError(coll, (AType)Types.DATA_STRUCTURE);
                    }
                    result = gettable.get(args[1], args[2]);
                }
                long juice = 30L;
                return context.withResult(juice, result);
            }
        });
        GET_IN = Core.reg(new CoreFn<ACell>(Symbols.GET_IN, 113){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n < 2 || n > 3) {
                    return context.withArityError(this.name() + " requires exactly 2 or 3 arguments");
                }
                ASequence ixs = RT.ensureSequence(args[1]);
                if (ixs == null) {
                    return context.withCastError(args[1], (AType)Types.SEQUENCE);
                }
                ACell notFound = n < 3 ? null : args[2];
                int il = ixs.size();
                long juice = 30L * (1L + (long)il);
                ACell result = args[0];
                for (int i = 0; i < il; ++i) {
                    if (result == null) {
                        result = notFound;
                        break;
                    }
                    ADataStructure gettable = RT.ensureDataStructure(result);
                    if (gettable == null) {
                        return context.withCastError(result, (AType)Types.DATA_STRUCTURE);
                    }
                    Object k = ixs.get(i);
                    if (!gettable.containsKey((ACell)k)) {
                        return context.withResult(juice, notFound);
                    }
                    result = gettable.get((ACell)k);
                }
                return context.withResult(juice, result);
            }
        });
        CONTAINS_KEY_Q = Core.reg(new CoreFn<CVMBool>(Symbols.CONTAINS_KEY_Q, 114){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMBool result;
                int n = args.length;
                if (n != 2) {
                    return context.withArityError(this.exactArityMessage(2, n));
                }
                ACell coll = args[0];
                if (coll == null) {
                    result = CVMBool.FALSE;
                } else {
                    ADataStructure gettable = RT.ensureDataStructure(args[0]);
                    if (gettable == null) {
                        return context.withCastError(args[0], (AType)Types.DATA_STRUCTURE);
                    }
                    result = CVMBool.of(gettable.containsKey(args[1]));
                }
                long juice = 30L;
                return context.withResult(juice, result);
            }
        });
        SUBSET_Q = Core.reg(new CoreFn<CVMBool>(Symbols.SUBSET_Q, 115){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 2) {
                    return context.withArityError(this.exactArityMessage(2, n));
                }
                ASet s0 = RT.ensureSet(args[0]);
                if (s0 == null) {
                    return context.withCastError(args[0], (AType)Types.SET);
                }
                long juice = 20L + 10L * s0.count();
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ASet s1 = RT.ensureSet(args[1]);
                if (s1 == null) {
                    return context.withCastError(args[1], (AType)Types.SET);
                }
                CVMBool result = CVMBool.of(s0.isSubset(s1));
                return context.withResult(juice, result);
            }
        });
        DISSOC = Core.reg(new CoreFn<AMap<?, ?>>(Symbols.DISSOC, 116){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                Object result = RT.ensureMap(args[0]);
                if (result == null) {
                    return context.withCastError(args[0], (AType)Types.MAP);
                }
                for (int i = 1; i < n; ++i) {
                    result = ((AMap)result).dissoc(args[i]);
                }
                long juice = 50L + (long)(n - 1) * 50L;
                return context.withResult(juice, (ACell)result);
            }
        });
        CONJ = Core.reg(new CoreFn<ADataStructure<ACell>>(Symbols.CONJ, 117){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int numAdditions = args.length - 1;
                if (args.length <= 0) {
                    return context.withArityError(this.name() + " requires a data structure as first argument");
                }
                long juice = 50L + 50L * (long)numAdditions;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ADataStructure result = RT.castDataStructure(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                for (int i = 0; i < numAdditions; ++i) {
                    int argIndex = i + 1;
                    ACell val = args[argIndex];
                    if ((result = result.conj(val)) != null) continue;
                    return context.withError(ErrorCodes.ARGUMENT, "Failure to 'conj' argument at position " + argIndex + " (with Type " + String.valueOf(RT.getType(val)) + "). Probably not a legal value for this data structure?");
                }
                return context.withResult(juice, result);
            }
        });
        DISJ = Core.reg(new CoreFn<ASet<ACell>>(Symbols.DISJ, 118){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                int numAdditions = args.length - 1;
                long juice = 50L + 50L * (long)numAdditions;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ASet result = RT.ensureSet(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.SET);
                }
                for (int i = 0; i < numAdditions; ++i) {
                    int argIndex = i + 1;
                    ACell val = args[argIndex];
                    result = result.exclude(val);
                }
                return context.withResult(juice, result);
            }
        });
        CONS = Core.reg(new CoreFn<AList<ACell>>(Symbols.CONS, 119){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (args.length < 2) {
                    return context.withArityError(this.minArityMessage(2, args.length));
                }
                long juice = 50L + 50L * (long)(n - 1);
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                int lastIndex = n - 1;
                ASequence seq = RT.sequence(args[lastIndex]);
                if (seq == null) {
                    return context.withCastError(lastIndex, args, Types.SEQUENCE);
                }
                AList<ACell> list = RT.cons(args[n - 2], seq);
                for (int i = n - 3; i >= 0; --i) {
                    list = RT.cons(args[i], list);
                }
                return context.withResult(juice, list);
            }
        });
        FIRST = Core.reg(new CoreFn<ACell>(Symbols.FIRST, 120){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell maybeColl = args[0];
                Long n = RT.count(maybeColl);
                if (n == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                if (n < 1L) {
                    return context.withBoundsError(0L);
                }
                Object result = RT.nth(maybeColl, 0L);
                long juice = 20L;
                return context.withResult(juice, (ACell)result);
            }
        });
        SECOND = Core.reg(new CoreFn<ACell>(Symbols.SECOND, 121){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell maybeColl = args[0];
                Long n = RT.count(maybeColl);
                if (n == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                if (n < 2L) {
                    return context.withBoundsError(1L);
                }
                Object result = RT.nth(maybeColl, 1L);
                long juice = 20L;
                return context.withResult(juice, (ACell)result);
            }
        });
        LAST = Core.reg(new CoreFn<ACell>(Symbols.LAST, 122){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                Long n = RT.count(a);
                if (n == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                if (n <= 0L) {
                    return context.withBoundsError(-1L);
                }
                Object result = RT.nth(a, n - 1L);
                long juice = 20L;
                return context.withResult(juice, (ACell)result);
            }
        });
        EQUALS = Core.reg(new CoreFn<CVMBool>(Symbols.EQUALS, 123){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMBool result = CVMBool.of(RT.allEqual((ACell[])args));
                return context.withResult(20L, result);
            }
        });
        EQ = Core.reg(new CoreFn<CVMBool>(Symbols.EQ, 124){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMBool result = RT.eq(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(10L, result);
            }
        });
        NE = Core.reg(new CoreFn<CVMBool>(Symbols.NE, 125){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMBool equal = RT.eq(args);
                if (equal == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(10L, equal.not());
            }
        });
        GE = Core.reg(new CoreFn<CVMBool>(Symbols.GE, 126){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMBool result = RT.ge(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(10L, result);
            }
        });
        GT = Core.reg(new CoreFn<CVMBool>(Symbols.GT, 127){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMBool result = RT.gt(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(10L, result);
            }
        });
        LE = Core.reg(new CoreFn<CVMBool>(Symbols.LE, 128){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMBool result = RT.le(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(10L, result);
            }
        });
        LT = Core.reg(new CoreFn<CVMBool>(Symbols.LT, 129){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMBool result = RT.lt(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(10L, result);
            }
        });
        MIN = Core.reg(new CoreFn<CVMBool>(Symbols.MIN, 130){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                ACell result = RT.min(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(10L, result);
            }
        });
        MAX = Core.reg(new CoreFn<CVMBool>(Symbols.MAX, 131){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                ACell result = RT.max(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(10L, result);
            }
        });
        INC = Core.reg(new CoreFn<CVMLong>(Symbols.INC, 132){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                AInteger result = RT.ensureInteger(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                result = result.inc();
                return context.withResult(20L, result);
            }
        });
        DEC = Core.reg(new CoreFn<CVMLong>(Symbols.DEC, 133){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                AInteger result = RT.ensureInteger(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                result = result.dec();
                return context.withResult(20L, result);
            }
        });
        BOOLEAN = Core.reg(new CoreFn<CVMBool>(Symbols.BOOLEAN, 134){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMBool result = RT.bool(args[0]) ? CVMBool.TRUE : CVMBool.FALSE;
                return context.withResult(20L, result);
            }
        });
        BOOLEAN_Q = Core.reg(new CorePred(Symbols.BOOLEAN_Q, 135){

            @Override
            public boolean test(ACell val) {
                return RT.isBoolean(val);
            }
        });
        ENCODING = Core.reg(new CoreFn<ABlob>(Symbols.ENCODING, 136){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                Blob encoding = Cells.encode(a);
                long juice = Juice.buildBlobCost(encoding.count());
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ABlob result = (ABlob)encoding.getCanonical();
                return context.withResult(juice, result);
            }
        });
        LONG = Core.reg(new CoreFn<CVMLong>(Symbols.LONG, 137){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMLong result = RT.castLong(a);
                if (result == null) {
                    if (a instanceof ANumeric) {
                        return context.withArgumentError("Out of range");
                    }
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.withResult(20L, result);
            }
        });
        INT = Core.reg(new CoreFn<AInteger>(Symbols.INT, 138){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                AInteger result = RT.castInteger(a);
                if (result == null) {
                    if (a instanceof ANumeric) {
                        return context.withArgumentError("Out of range");
                    }
                    return context.withCastError(0, args, Types.INTEGER);
                }
                return context.withResult(20L, result);
            }
        });
        DOUBLE = Core.reg(new CoreFn<CVMDouble>(Symbols.DOUBLE, 139){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMDouble result = RT.castDouble(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.DOUBLE);
                }
                return context.withResult(20L, result);
            }
        });
        CHAR = Core.reg(new CoreFn<CVMChar>(Symbols.CHAR, 140){

            @Override
            public Context invoke(Context context, ACell[] args) {
                CVMChar result;
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                if (a instanceof CVMChar) {
                    result = (CVMChar)a;
                } else if (a instanceof ABlob) {
                    ABlob b = RT.ensureBlob(a);
                    result = CVMChar.fromUTF8(b);
                    if (result == null) {
                        return context.withArgumentError("Not a valid UTF-8 character");
                    }
                } else {
                    AInteger cp = RT.ensureInteger(a);
                    if (cp == null) {
                        return context.withCastError(0, args, Types.CHARACTER);
                    }
                    if (!cp.isLong()) {
                        return context.withArgumentError("Invalid code point: " + String.valueOf(cp));
                    }
                    result = CVMChar.create(cp.longValue());
                    if (result == null) {
                        return context.withArgumentError("Invalid code point: " + String.valueOf(cp));
                    }
                }
                return context.withResult(20L, result);
            }
        });
        BYTE = Core.reg(new CoreFn<CVMLong>(Symbols.BYTE, 141){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMLong result = RT.castByte(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.withResult(20L, result);
            }
        });
        PLUS = Core.reg(new CoreFn<APrimitive>(Symbols.PLUS, 160){

            @Override
            public Context invoke(Context context, ACell[] args) {
                long cost = Juice.precostNumericLinear(args);
                if (cost < 0L) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                if (cost > 0L && (context = context.consumeJuice(cost)).isExceptional()) {
                    return context;
                }
                ANumeric result = RT.plus(args);
                if (result == null) {
                    return context.withError(ErrorMessages.INVALID_NUMERIC);
                }
                return context.withResult(20L, result);
            }
        });
        MINUS = Core.reg(new CoreFn<APrimitive>(Symbols.MINUS, 161){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                long cost = Juice.precostNumericLinear(args);
                if (cost < 0L) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                if (cost > 0L && (context = context.consumeJuice(cost)).isExceptional()) {
                    return context;
                }
                ANumeric result = RT.minus(args);
                if (result == null) {
                    return context.withError(ErrorMessages.INVALID_NUMERIC);
                }
                return context.withResult(20L, result);
            }
        });
        TIMES = Core.reg(new CoreFn<APrimitive>(Symbols.TIMES, 162){

            @Override
            public Context invoke(Context context, ACell[] args) {
                long cost = Juice.precostNumericLinear(args);
                if (cost < 0L) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                if (cost > 0L && (context = context.consumeJuice(cost)).isExceptional()) {
                    return context;
                }
                ANumeric result = RT.multiply(args);
                if (result == null) {
                    return context.withError(ErrorMessages.INVALID_NUMERIC);
                }
                return context.withResult(20L, result);
            }
        });
        DIVIDE = Core.reg(new CoreFn<CVMDouble>(Symbols.DIVIDE, 163){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                CVMDouble result = RT.divide(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        FLOOR = Core.reg(new CoreFn<CVMDouble>(Symbols.FLOOR, 164){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMDouble result = RT.floor(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        CEIL = Core.reg(new CoreFn<CVMDouble>(Symbols.CEIL, 165){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMDouble result = RT.ceil(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        SQRT = Core.reg(new CoreFn<CVMDouble>(Symbols.SQRT, 166){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMDouble result = RT.sqrt(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        ABS = Core.reg(new CoreFn<APrimitive>(Symbols.ABS, 167){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                APrimitive result = RT.abs(args[0]);
                if (result == null) {
                    int badVal = RT.findNonNumeric(args);
                    if (badVal < 0) {
                        return context.withError(ErrorMessages.INVALID_NUMERIC);
                    }
                    return context.withCastError(badVal, args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        SIGNUM = Core.reg(new CoreFn<CVMLong>(Symbols.SIGNUM, 168){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell result = RT.signum(args[0]);
                if (result == null) {
                    return context.withCastError(args[0], (AType)Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        MOD = Core.reg(new CoreFn<AInteger>(Symbols.MOD, 169){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AInteger la = RT.ensureInteger(args[0]);
                AInteger lb = RT.ensureInteger(args[1]);
                if (lb == null || la == null) {
                    return context.withCastError(Types.INTEGER);
                }
                if (lb.isZero()) {
                    return context.withArgumentError("Divsion by zero in " + this.name());
                }
                AInteger result = la.mod(lb);
                return context.withResult(20L, result);
            }
        });
        DIV = Core.reg(new CoreFn<AInteger>(Symbols.DIV, 170){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AInteger la = RT.ensureInteger(args[0]);
                AInteger lb = RT.ensureInteger(args[1]);
                if (lb == null || la == null) {
                    return context.withCastError(Types.INTEGER);
                }
                if (lb.isZero()) {
                    return context.withArgumentError("Divsion by zero in " + this.name());
                }
                AInteger result = la.div(lb);
                return context.withResult(20L, result);
            }
        });
        REM = Core.reg(new CoreFn<AInteger>(Symbols.REM, 171){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AInteger la = RT.ensureInteger(args[0]);
                AInteger lb = RT.ensureInteger(args[1]);
                if (lb == null || la == null) {
                    return context.withCastError(Types.INTEGER);
                }
                if (lb.isZero()) {
                    return context.withArgumentError("Divsion by zero in " + this.name());
                }
                AInteger result = la.rem(lb);
                return context.withResult(20L, result);
            }
        });
        QUOT = Core.reg(new CoreFn<AInteger>(Symbols.QUOT, 172){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AInteger la = RT.ensureInteger(args[0]);
                AInteger lb = RT.ensureInteger(args[1]);
                if (lb == null || la == null) {
                    return context.withCastError(Types.INTEGER);
                }
                if (lb.isZero()) {
                    return context.withArgumentError("Divsion by zero in " + this.name());
                }
                AInteger result = la.quot(lb);
                return context.withResult(20L, result);
            }
        });
        QUOTE = Core.reg(new CoreFn<ACell>(Symbols.QUOTE, 0){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                ACell x = args[0];
                return context.withResult(40L, x);
            }
        });
        POW = Core.reg(new CoreFn<CVMDouble>(Symbols.POW, 173){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                CVMDouble result = RT.pow(args);
                if (result == null) {
                    return context.withCastError(Types.DOUBLE);
                }
                return context.withResult(20L, result);
            }
        });
        EXP = Core.reg(new CoreFn<CVMDouble>(Symbols.EXP, 174){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMDouble result = RT.exp(args[0]);
                if (result == null) {
                    return context.withCastError(0, (AType)Types.DOUBLE);
                }
                return context.withResult(20L, result);
            }
        });
        NOT = Core.reg(new CoreFn<CVMBool>(Symbols.NOT, 175){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMBool result = CVMBool.of(!RT.bool(args[0]));
                return context.withResult(20L, result);
            }
        });
        BIT_AND = Core.reg(new CoreFn<CVMLong>(Symbols.BIT_AND, 176){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                CVMLong a = RT.ensureLong(args[0]);
                if (a == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                CVMLong b = RT.ensureLong(args[1]);
                if (b == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                CVMLong result = CVMLong.create(a.longValue() & b.longValue());
                return context.withResult(20L, result);
            }
        });
        BIT_XOR = Core.reg(new CoreFn<CVMLong>(Symbols.BIT_XOR, 177){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                CVMLong a = RT.ensureLong(args[0]);
                if (a == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                CVMLong b = RT.ensureLong(args[1]);
                if (b == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                CVMLong result = CVMLong.create(a.longValue() ^ b.longValue());
                return context.withResult(20L, result);
            }
        });
        BIT_OR = Core.reg(new CoreFn<CVMLong>(Symbols.BIT_OR, 178){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                CVMLong a = RT.ensureLong(args[0]);
                if (a == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                CVMLong b = RT.ensureLong(args[1]);
                if (b == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                CVMLong result = CVMLong.create(a.longValue() | b.longValue());
                return context.withResult(20L, result);
            }
        });
        BIT_NOT = Core.reg(new CoreFn<CVMLong>(Symbols.BIT_NOT, 179){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMLong a = RT.ensureLong(args[0]);
                if (a == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                CVMLong result = CVMLong.create(a.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                return context.withResult(20L, result);
            }
        });
        HASH = Core.reg(new CoreFn<Hash>(Symbols.HASH, 180){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ABlob blob = RT.ensureBlob(args[0]);
                if (blob == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                long juice = 1000L + blob.count() * 20L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                Hash result = blob.getContentHash();
                return context.withResult(juice, result);
            }
        });
        KECCAK256 = Core.reg(new CoreFn<Hash>(Symbols.KECCAK256, 181){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ABlob blob = RT.ensureBlob(args[0]);
                if (blob == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                long juice = 1000L + blob.count() * 20L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                Hash result = blob.computeHash(Hashing.getKeccak256Digest());
                return context.withResult(juice, result);
            }
        });
        SHA256 = Core.reg(new CoreFn<Hash>(Symbols.SHA256, 182){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ABlob blob = RT.ensureBlob(args[0]);
                if (blob == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                long juice = 1000L + blob.count() * 20L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                Hash result = blob.computeHash(Hashing.getSHA256Digest());
                return context.withResult(juice, result);
            }
        });
        COUNT = Core.reg(new CoreFn<CVMLong>(Symbols.COUNT, 183){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                Long result = RT.count(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                return context.withResult(20L, CVMLong.create(result));
            }
        });
        EMPTY = Core.reg(new CoreFn<ACell>(Symbols.EMPTY, 192){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                if (o == null) {
                    return context.withResult(20L, null);
                }
                ACountable coll = RT.ensureCountable(o);
                if (coll == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                ACountable result = coll.empty();
                return context.withResult(20L, result);
            }
        });
        NTH = Core.reg(new CoreFn<ACell>(Symbols.NTH, 193){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                ACell arg = args[0];
                Long n = RT.count(arg);
                if (n == null) {
                    return context.withCastError(arg, (AType)Types.SEQUENCE);
                }
                AInteger iarg = RT.ensureInteger(args[1]);
                if (iarg == null) {
                    return context.withCastError(1, args, Types.INTEGER);
                }
                if (!iarg.isLong()) {
                    return context.withError(ErrorCodes.BOUNDS, "Excessively large index");
                }
                long i = iarg.longValue();
                if (i < 0L || i >= n) {
                    return context.withBoundsError(i);
                }
                Object result = RT.nth(arg, i);
                return context.withResult(20L, (ACell)result);
            }
        });
        NEXT = Core.reg(new CoreFn<ASequence<ACell>>(Symbols.NEXT, 194){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ASequence seq = RT.sequence(args[0]);
                if (seq == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                ASequence result = seq.next();
                return context.withResult(20L, result);
            }
        });
        SLICE = Core.reg(new CoreFn<ASequence<ACell>>(Symbols.SLICE, 195){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int alen = args.length;
                if (alen < 2) {
                    return context.withArityError(this.minArityMessage(2, args.length));
                }
                if (alen > 3) {
                    return context.withArityError(this.maxArityMessage(3, args.length));
                }
                ACountable<ACell> counted = RT.ensureCountable(args[0]);
                if (counted == null) {
                    return context.withCastError(0, args, Types.COUNTABLE);
                }
                long n = counted.count();
                long start = 0L;
                long end = n;
                CVMLong l = RT.ensureLong(args[1]);
                if (l == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                start = l.longValue();
                if (start < 0L) {
                    return context.withBoundsError(start);
                }
                if (alen > 2) {
                    l = RT.ensureLong(args[2]);
                    if (l == null) {
                        return context.withCastError(2, args, Types.LONG);
                    }
                    end = l.longValue();
                    if (end > n) {
                        return context.withBoundsError(end);
                    }
                }
                if (end < start) {
                    return context.withError(ErrorCodes.BOUNDS, "End before start");
                }
                long juice = Juice.costBuildStructure(counted, end - start);
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ACountable<ACell> result = counted.slice(start, end);
                return context.withResult(juice, result);
            }
        });
        RECUR = Core.reg(new CoreFn<ACell>(Symbols.RECUR, 196){

            @Override
            public Context invoke(Context context, ACell[] args) {
                RecurValue result = RecurValue.wrap(args);
                return context.withException(30L, result);
            }
        });
        TAILCALL_STAR = Core.reg(new CoreFn<ACell>(Symbols.TAILCALL_STAR, 197){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n < 1) {
                    return context.withArityError(this.minArityMessage(1, n));
                }
                AFn f = RT.ensureFunction(args[0]);
                if (f == null) {
                    return context.withCastError(0, args, Types.FUNCTION);
                }
                ACell[] tailArgs = Arrays.copyOfRange(args, 1, args.length);
                TailcallValue result = TailcallValue.wrap(f, tailArgs);
                return context.withException(30L, result);
            }
        });
        ROLLBACK = Core.reg(new CoreFn<ACell>(Symbols.ROLLBACK, 208){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                RollbackValue<ACell> result = RollbackValue.wrap(args[0]);
                return context.withException(20L, result);
            }
        });
        HALT = Core.reg(new CoreFn<ACell>(Symbols.HALT, 209){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n > 1) {
                    return context.withArityError(this.maxArityMessage(1, n));
                }
                HaltValue<Object> result = HaltValue.wrap(n > 0 ? args[0] : null);
                return context.withException(20L, result);
            }
        });
        RETURN = Core.reg(new CoreFn<ACell>(Symbols.RETURN, 210){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ReturnValue<ACell> result = ReturnValue.wrap(args[0]);
                return context.withException(20L, result);
            }
        });
        FAIL = Core.reg(new CoreFn<CVMBool>(Symbols.FAIL, 211){

            @Override
            public Context invoke(Context context, ACell[] args) {
                Keyword code;
                int alen = args.length;
                if (alen > 2) {
                    return context.withArityError(this.maxArityMessage(2, alen));
                }
                ACell aCell = code = alen == 2 ? args[0] : ErrorCodes.ASSERT;
                if (code == null) {
                    return context.withError(ErrorCodes.ARGUMENT, "Error code cannot be nil");
                }
                ACell message = alen > 0 ? args[alen - 1] : null;
                ErrorValue error = ErrorValue.createRaw(code, message);
                return context.withError(error);
            }
        });
        APPLY = Core.reg(new CoreFn<ACell>(Symbols.APPLY, 198){

            @Override
            public Context invoke(Context context, ACell[] args) {
                ACell[] applyArgs;
                int alen = args.length;
                if (alen < 2) {
                    return context.withArityError(this.minArityMessage(2, alen));
                }
                AFn fn = RT.castFunction(args[0]);
                if (fn == null) {
                    return context.withCastError(0, args, Types.FUNCTION);
                }
                int lastIndex = alen - 1;
                ACell lastArg = args[lastIndex];
                ASequence coll = RT.ensureSequence(lastArg);
                if (coll == null) {
                    return context.withCastError(lastIndex, args, Types.SEQUENCE);
                }
                int vlen = coll.size();
                int n = alen - 2 + vlen;
                if (alen > 2) {
                    applyArgs = new ACell[n];
                    for (int i = 0; i < alen - 2; ++i) {
                        applyArgs[i] = args[i + 1];
                    }
                    int ix = alen - 2;
                    Iterator it = coll.iterator();
                    while (it.hasNext()) {
                        applyArgs[ix++] = (ACell)it.next();
                    }
                } else {
                    applyArgs = coll.toCellArray();
                }
                Context rctx = context.invoke(fn, applyArgs);
                return rctx.consumeJuice(50L);
            }
        });
        INTO = Core.reg(new CoreFn<ADataStructure<ACell>>(Symbols.INTO, 224){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                ACell a0 = args[0];
                ADataStructure result = RT.ensureDataStructure(a0);
                if (a0 != null && result == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                long juice = 50L;
                ACell a1 = args[1];
                if (a0 == null) {
                    result = RT.ensureDataStructure(a1);
                    if (a1 != null && result == null) {
                        return context.withCastError(a1, (AType)Types.DATA_STRUCTURE);
                    }
                } else {
                    Long n = RT.count(a1);
                    if (n == null) {
                        return context.withCastError(a1, (AType)Types.DATA_STRUCTURE);
                    }
                    if (!context.checkJuice(juice += 50L * n)) {
                        return context.withJuiceError();
                    }
                    ASequence seq = RT.sequence(a1);
                    if (seq == null) {
                        return context.withCastError(a1, (AType)Types.DATA_STRUCTURE);
                    }
                    if ((result = result.conjAll(seq)) == null) {
                        return context.withError(ErrorCodes.ARGUMENT, "Invalid element type for 'into'");
                    }
                }
                return context.withResult(juice, result);
            }
        });
        MERGE = Core.reg(new CoreFn<AHashMap<ACell, ACell>>(Symbols.MERGE, 225){

            @Override
            public Context invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n == 0) {
                    return context.withResult(50L, (ACell)Maps.empty());
                }
                ACell arg0 = args[0];
                Object result = RT.ensureMap(arg0);
                if (result == null) {
                    return context.withCastError(arg0, (AType)Types.MAP);
                }
                long juice = 50L;
                for (int i = 1; i < n; ++i) {
                    ACell argi = args[i];
                    Object argMap = RT.ensureMap(argi);
                    if (argMap == null) {
                        return context.withCastError(argi, (AType)Types.MAP);
                    }
                    long size = ((ADataStructure)argMap).count();
                    if (!context.checkJuice(juice = Juice.addMul(juice, size, 50L))) {
                        return context.withJuiceError();
                    }
                    if ((result = ((AMap)result).merge(argMap)) != null) continue;
                    return context.withError(ErrorCodes.CAST, "Unable to merge");
                }
                return context.withResult(juice, (ACell)result);
            }
        });
        MAP = Core.reg(new CoreFn<ADataStructure<?>>(Symbols.MAP, 226){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length < 2) {
                    return context.withArityError(this.minArityMessage(2, args.length));
                }
                ACell fnArg = args[0];
                AFn f = RT.castFunction(fnArg);
                if (f == null) {
                    return context.withCastError(fnArg, (AType)Types.FUNCTION);
                }
                int fnArity = args.length - 1;
                ADataStructure[] seqs = new ADataStructure[fnArity];
                int length = Integer.MAX_VALUE;
                for (int i = 0; i < fnArity; ++i) {
                    ADataStructure seq;
                    ACell maybeSeq = args[1 + i];
                    seqs[i] = seq = RT.ensureDataStructure(maybeSeq);
                    if (seq == null) {
                        if (maybeSeq != null) {
                            return context.withCastError(maybeSeq, (AType)Types.SEQUENCE);
                        }
                        ACountable result = seqs[0];
                        if (result != null) {
                            result = result.empty();
                        }
                        return context.withResult(100L, result);
                    }
                    length = Math.min(length, seq.size());
                }
                long juice = Juice.addMul(100L, 50L, length);
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ADataStructure result = seqs[0].empty();
                boolean reverse = result instanceof AList;
                for (int i = 0; i < length; ++i) {
                    ACell[] xs = new ACell[fnArity];
                    long srcIndex = reverse ? (long)(length - 1 - i) : (long)i;
                    for (int j = 0; j < fnArity; ++j) {
                        xs[j] = seqs[j].get(srcIndex);
                    }
                    if ((context = context.invoke(f, xs)).isExceptional()) {
                        return context;
                    }
                    Object r = context.getResult();
                    if ((result = result.conj((ACell)r)) != null) continue;
                    return context.withError(ErrorCodes.ARGUMENT, "Invalid element type for " + String.valueOf(seqs[0].getType()));
                }
                return context.withResult(juice, result);
            }
        });
        REDUCE = Core.reg(new CoreFn<ACell>(Symbols.REDUCE, 227){

            @Override
            public Context invoke(Context ctx, ACell[] args) {
                ACell result;
                ADataStructure seq;
                int ac = args.length;
                if (ac < 2 || ac > 3) {
                    return ctx.withArityError(this.exactArityMessage(3, ac));
                }
                ACell fnArg = args[0];
                AFn fn = RT.castFunction(fnArg);
                if (fn == null) {
                    return ctx.withCastError(0, args, Types.FUNCTION);
                }
                ACell maybeSeq = args[ac - 1];
                ADataStructure aDataStructure = seq = maybeSeq == null ? Vectors.empty() : RT.ensureDataStructure(maybeSeq);
                if (seq == null) {
                    return ctx.withCastError(ac - 1, args, Types.SEQUENCE);
                }
                long n = seq.count();
                long start = 0L;
                if (ac == 3) {
                    result = args[1];
                } else {
                    int initial = (int)Math.min(2L, n);
                    if (initial == 0) {
                        return Core.reduceResult(ctx.invoke(fn, Cells.EMPTY_ARRAY));
                    }
                    if (initial == 1) {
                        return Core.reduceResult(ctx.invoke(fn, new ACell[]{seq.get(0L)}));
                    }
                    result = seq.get(0L);
                    start = 1L;
                }
                ACell[] xs = new ACell[2];
                for (long i = start; i < n; ++i) {
                    xs[0] = result;
                    xs[1] = seq.get(i);
                    if ((ctx = ctx.invoke(fn, xs)).isExceptional()) {
                        return Core.reduceResult(ctx);
                    }
                    result = ctx.getResult();
                }
                return ctx.withResult(100L, result);
            }
        });
        REDUCED = Core.reg(new CoreFn<ACell>(Symbols.REDUCED, 228){

            @Override
            public Context invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ReducedValue result = ReducedValue.wrap(args[0]);
                return context.withException(20L, result);
            }
        });
        NIL_Q = Core.reg(new CorePred(Symbols.NIL_Q, 240){

            @Override
            public boolean test(ACell val) {
                return val == null;
            }
        });
        VECTOR_Q = Core.reg(new CorePred(Symbols.VECTOR_Q, 241){

            @Override
            public boolean test(ACell val) {
                return val instanceof AVector;
            }
        });
        LIST_Q = Core.reg(new CorePred(Symbols.LIST_Q, 242){

            @Override
            public boolean test(ACell val) {
                return val instanceof AList;
            }
        });
        SET_Q = Core.reg(new CorePred(Symbols.SET_Q, 243){

            @Override
            public boolean test(ACell val) {
                return val instanceof ASet;
            }
        });
        MAP_Q = Core.reg(new CorePred(Symbols.MAP_Q, 244){

            @Override
            public boolean test(ACell val) {
                return val instanceof AMap;
            }
        });
        COLL_Q = Core.reg(new CorePred(Symbols.COLL_Q, 245){

            @Override
            public boolean test(ACell val) {
                return val instanceof ADataStructure;
            }
        });
        COUNTABLE_Q = Core.reg(new CorePred(Symbols.COUNTABLE_Q, 256){

            @Override
            public boolean test(ACell val) {
                return RT.isCountable(val);
            }
        });
        EMPTY_Q = Core.reg(new CorePred(Symbols.EMPTY_Q, 246){

            @Override
            public boolean test(ACell val) {
                if (val == null) {
                    return true;
                }
                return val instanceof ACountable && ((ACountable)val).isEmpty();
            }
        });
        SYMBOL_Q = Core.reg(new CorePred(Symbols.SYMBOL_Q, 247){

            @Override
            public boolean test(ACell val) {
                return val instanceof Symbol;
            }
        });
        KEYWORD_Q = Core.reg(new CorePred(Symbols.KEYWORD_Q, 248){

            @Override
            public boolean test(ACell val) {
                return val instanceof Keyword;
            }
        });
        BLOB_Q = Core.reg(new CorePred(Symbols.BLOB_Q, 249){

            @Override
            public boolean test(ACell val) {
                return val instanceof ABlob;
            }
        });
        ADDRESS_Q = Core.reg(new CorePred(Symbols.ADDRESS_Q, 250){

            @Override
            public boolean test(ACell val) {
                return val instanceof Address;
            }
        });
        LONG_Q = Core.reg(new CorePred(Symbols.LONG_Q, 251){

            @Override
            public boolean test(ACell val) {
                if (val instanceof AInteger) {
                    return ((AInteger)val).ensureLong() != null;
                }
                return false;
            }
        });
        INT_Q = Core.reg(new CorePred(Symbols.INT_Q, 252){

            @Override
            public boolean test(ACell val) {
                return val instanceof AInteger;
            }
        });
        DOUBLE_Q = Core.reg(new CorePred(Symbols.DOUBLE_Q, 253){

            @Override
            public boolean test(ACell val) {
                return val instanceof CVMDouble;
            }
        });
        STR_Q = Core.reg(new CorePred(Symbols.STR_Q, 254){

            @Override
            public boolean test(ACell val) {
                return val instanceof AString;
            }
        });
        NUMBER_Q = Core.reg(new CorePred(Symbols.NUMBER_Q, 255){

            @Override
            public boolean test(ACell val) {
                return RT.isNumber(val);
            }
        });
        NAN_Q = Core.reg(new CorePred(Symbols.NAN_Q, 270){

            @Override
            public boolean test(ACell val) {
                return RT.isNaN(val);
            }
        });
        FN_Q = Core.reg(new CorePred(Symbols.FN_Q, 271){

            @Override
            public boolean test(ACell val) {
                return val instanceof AFn;
            }
        });
        ZERO_Q = Core.reg(new CorePred(Symbols.ZERO_Q, 272){

            @Override
            public boolean test(ACell val) {
                if (!RT.isNumber(val)) {
                    return false;
                }
                ANumeric n = RT.ensureNumber(val);
                if (n == null) {
                    return false;
                }
                return n.isZero();
            }
        });
        Object coreEnv = Maps.empty();
        Object coreMeta = Maps.empty();
        try {
            METAS = (AMap)Reader.read(Utils.readResourceAsString("/convex/core/metadata.cvx"));
            for (ACell o : tempReg) {
                coreEnv = Core.register(coreEnv, o);
            }
            Context ctx = Core.registerCoreCode(coreEnv);
            ctx = Core.applyDocumentation(ctx);
            coreEnv = ctx.getEnvironment();
            coreMeta = ctx.getMetadata();
            METADATA = coreMeta;
            ENVIRONMENT = coreEnv;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("IO Error initialising core!", e);
        }
    }
}

