/*
 * Decompiled with CFR 0.152.
 */
package convex.core.json;

import convex.core.data.ACell;
import convex.core.data.Cells;
import convex.core.data.Maps;
import convex.core.data.Vectors;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMDouble;
import convex.core.exceptions.ParseException;
import convex.core.json.reader.antlr.JSON5BaseListener;
import convex.core.json.reader.antlr.JSON5Lexer;
import convex.core.json.reader.antlr.JSON5Parser;
import convex.core.util.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class JSON5Reader {
    public static final ThrowingErrorListener ERROR_LISTENER = new ThrowingErrorListener();

    public static ACell read(String s) {
        return JSON5Reader.read((CharStream)CharStreams.fromString((String)s));
    }

    public static ACell read(Reader r) throws IOException {
        return JSON5Reader.read((CharStream)CharStreams.fromReader((Reader)r));
    }

    public static ACell read(InputStream is) throws IOException {
        return JSON5Reader.read(CharStreams.fromStream((InputStream)is));
    }

    static JSON5Parser getParser(CharStream cs, JSONListener listener) {
        JSON5Lexer lexer = new JSON5Lexer(cs);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JSON5Parser parser = new JSON5Parser((TokenStream)tokens);
        parser.setBuildParseTree(false);
        parser.removeErrorListeners();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        parser.addParseListener(listener);
        return parser;
    }

    static ACell read(CharStream cs) {
        JSONListener listener = new JSONListener();
        JSON5Parser parser = JSON5Reader.getParser(cs, listener);
        try {
            parser.json();
        }
        catch (ParseCancellationException pe) {
            throw new ParseException(pe.getMessage(), pe.getCause());
        }
        ArrayList<ACell> top = listener.popList();
        if (top.size() != 1) {
            throw new ParseException("Bad parse output: " + String.valueOf(top));
        }
        return top.get(0);
    }

    public static class ThrowingErrorListener
    extends BaseErrorListener {
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }

    protected static class JSONListener
    extends JSON5BaseListener {
        ArrayList<ArrayList<ACell>> stack = new ArrayList();

        public JSONListener() {
            this.stack.add(new ArrayList());
        }

        protected void push(ACell a) {
            ArrayList<ACell> top = this.stack.getLast();
            top.add(a);
        }

        protected <R extends ACell> R pop() {
            ArrayList<ACell> top = this.stack.getLast();
            ACell cell = top.removeLast();
            return (R)cell;
        }

        protected void pushList() {
            this.stack.add(new ArrayList());
        }

        protected ArrayList<ACell> popList() {
            ArrayList<ACell> top = this.stack.removeLast();
            return top;
        }

        @Override
        public void exitNil(JSON5Parser.NilContext ctx) {
            this.push(null);
        }

        @Override
        public void exitBool(JSON5Parser.BoolContext ctx) {
            boolean value = ctx.getText().equals("true");
            this.push(CVMBool.create(value));
        }

        @Override
        public void enterArray(JSON5Parser.ArrayContext ctx) {
            this.pushList();
        }

        @Override
        public void exitArray(JSON5Parser.ArrayContext ctx) {
            ArrayList<ACell> arr = this.popList();
            this.push(Vectors.create(arr));
        }

        @Override
        public void exitNumber(JSON5Parser.NumberContext ctx) {
            String num = ctx.getText();
            AInteger intv = AInteger.parse(num);
            if (intv != null) {
                this.push(intv);
                return;
            }
            if (num.startsWith("0x") || num.startsWith("0X")) {
                this.push(AInteger.parseHex(num.substring(2)));
                return;
            }
            if (num.startsWith("-0x") || num.startsWith("-0X")) {
                this.push(AInteger.parseHex(num.substring(3)).negate());
                return;
            }
            try {
                CVMDouble dv = CVMDouble.parse(num);
                if (dv != null) {
                    this.push(dv);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ParseException("Can't parse as number: " + num);
        }

        @Override
        public void exitString(JSON5Parser.StringContext ctx) {
            String text = ctx.getText();
            String content = text.substring(1, text.length() - 1);
            this.push(JSON.unescape(content));
        }

        @Override
        public void exitIdentifier(JSON5Parser.IdentifierContext ctx) {
            String text = ctx.getText();
            this.push(JSON.unescape(text));
        }

        @Override
        public void enterObj(JSON5Parser.ObjContext ctx) {
            this.pushList();
        }

        @Override
        public void exitObj(JSON5Parser.ObjContext ctx) {
            ArrayList<ACell> arr = this.popList();
            ACell[] kvs = arr.toArray(Cells.EMPTY_ARRAY);
            this.push((ACell)Maps.create(kvs));
        }
    }
}

