/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.util;

import convex.core.data.ABlob;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Strings;
import convex.core.data.prim.CVMChar;
import convex.core.exceptions.Panic;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BlobBuilder {
    protected ABlob acc = Blob.EMPTY;
    protected byte[] tail = null;
    protected long count = 0L;

    public BlobBuilder() {
    }

    public BlobBuilder(ABlob blob) {
        this();
        this.append(blob);
    }

    private int spare() {
        return (int)(4096L - (this.count - this.acc.count()));
    }

    private int arrayPos() {
        return Utils.checkedInt(this.count - this.acc.count());
    }

    public BlobBuilder append(AString a) {
        return this.append(a.toBlob());
    }

    public BlobBuilder append(ABlob b) {
        long blen = b.count();
        if (blen == 0L) {
            return this;
        }
        long spare = this.spare();
        if (blen <= spare) {
            this.ensureArray((long)this.arrayPos() + blen);
            b.getBytes(this.tail, this.arrayPos());
            this.count += blen;
            if (blen == spare) {
                this.completeChunk();
            }
            return this;
        }
        this.append(b.slice(0L, spare));
        for (long off = spare; off < blen; off += 4096L) {
            long take = Math.min(4096L, blen - off);
            this.append(b.slice(off, off + take));
        }
        return this;
    }

    private void completeChunk() {
        if (this.tail.length != 4096) {
            throw new IllegalStateException("tail not complete! Has length: " + this.tail.length);
        }
        Blob b = Blob.wrap(this.tail, 0, this.arrayPos());
        this.acc = this.acc.append(b);
        this.tail = null;
    }

    private void ensureArray(long n) {
        if (n > 4096L) {
            throw new IllegalStateException("Invalid array size request: " + n);
        }
        if (this.tail == null) {
            this.tail = new byte[Utils.checkedInt(Math.min(4096L, n * 2L))];
        }
        if ((long)this.tail.length >= n) {
            return;
        }
        int save = this.arrayPos();
        int newLen = Math.min(4096, Math.max((int)n, this.tail.length * 2));
        byte[] newTail = new byte[newLen];
        System.arraycopy(this.tail, 0, newTail, 0, save);
        this.tail = newTail;
    }

    public ABlob toBlob() {
        ABlob result = this.acc;
        if (this.tail == null) {
            return this.acc;
        }
        if ((result = result.append(Blob.wrap(this.tail, 0, this.arrayPos()))).count() != this.count) {
            throw new Panic("Invalid count!!");
        }
        return result;
    }

    public ABlob slice(long start, long end) {
        if (start < 0L || start > this.count) {
            throw new IndexOutOfBoundsException("Invalid start: " + start);
        }
        if (end < start || end > this.count) {
            throw new IndexOutOfBoundsException("Invalid end: " + end);
        }
        long length = end - start;
        if (length == this.count) {
            return this.toBlob();
        }
        long split = this.acc.count();
        if (end <= split) {
            return this.acc.slice(start, end);
        }
        if (start >= split) {
            return Blob.wrap(this.tail, (int)(start - split), (int)length);
        }
        return this.toBlob().slice(start, end);
    }

    public AString getCVMString() {
        ABlob result = this.toBlob();
        return Strings.create(result);
    }

    public long count() {
        return this.count;
    }

    public void append(String string) {
        this.append(Strings.create(string));
    }

    public void appendLongString(long value) {
        int n;
        if (value == Long.MIN_VALUE) {
            this.append(Strings.LONG_MIN_VALUE);
            return;
        }
        if (value < 0L) {
            this.append('-');
            value = -value;
        }
        if ((n = Utils.longStringSize(value)) == 1) {
            this.append((byte)(48L + value));
            return;
        }
        byte[] bs = new byte[n];
        for (int i = 0; i < n; ++i) {
            bs[n - i - 1] = (byte)(48L + value % 10L);
            value /= 10L;
        }
        this.append(bs);
    }

    public BlobBuilder append(byte b) {
        int spare = this.spare();
        if (spare < 1) {
            throw new Panic("BlobBuilder should always have spare bytes but was: " + spare);
        }
        this.ensureArray(this.arrayPos() + 1);
        this.tail[4096 - spare] = b;
        ++this.count;
        if (spare == 1) {
            this.completeChunk();
        }
        return this;
    }

    public BlobBuilder appendRepeatedByte(byte b, long repeatCount) {
        int spare = this.spare();
        if (spare < 1) {
            throw new Panic("BlobBuilder should always have spare bytes but was: " + spare);
        }
        while (repeatCount > 0L) {
            int batchSize = (int)Math.min((long)spare, repeatCount);
            int start = this.arrayPos();
            int end = start + batchSize;
            this.ensureArray(end);
            Arrays.fill(this.tail, start, end, b);
            this.count += (long)batchSize;
            if (this.spare() == 0) {
                this.completeChunk();
            }
            repeatCount -= (long)batchSize;
        }
        return this;
    }

    public void append(byte[] bs) {
        this.append(bs, 0, bs.length);
    }

    public void append(byte[] bs, int offset, int length) {
        while (length > 0) {
            int split = Math.min(length, this.spare());
            int pos = this.arrayPos();
            this.ensureArray(pos + split);
            System.arraycopy(bs, offset, this.tail, pos, split);
            this.count += (long)split;
            length -= split;
            offset += split;
            if (this.spare() != 0) continue;
            this.completeChunk();
        }
    }

    public BlobBuilder append(char c) {
        if (c < '\u0080') {
            return this.append((byte)c);
        }
        return this.append(CVMChar.create(c));
    }

    public void appendHexByte(byte b) {
        this.append(Utils.toHexChar((b & 0xF0) >>> 4));
        this.append(Utils.toHexChar(b & 0xF));
    }

    public void appendCAD3Hex(Blob encoding) {
        byte[] arr = encoding.getInternalArray();
        int pos = encoding.getInternalOffset();
        int n = encoding.size();
        for (int i = 0; i < n; ++i) {
            byte b = arr[pos + i];
            this.append(Utils.toHexChar((b & 0xF0) >>> 4));
            this.append(Utils.toHexChar(b & 0xF));
        }
    }

    public void appendVLQCountHex(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative VLQ Count?");
        }
        int n = Format.getVLQCountLength(value);
        for (int i = 0; i < n; ++i) {
            byte b = (byte)(value >> (n - i - 1) * 7 & 0x7FL);
            if (i < n - 1) {
                b = (byte)(b | 0xFFFFFF80);
            }
            this.appendHexByte(b);
        }
    }

    public BlobBuilder append(CVMChar c) {
        return this.append(c.toUTFBlob());
    }

    public boolean check(long limit) {
        return this.count <= limit;
    }

    public void append(ByteBuffer bb) {
        int n;
        if (this.arrayPos() > 0) {
            this.appendToFillChunk(bb);
        }
        for (n = bb.remaining(); n >= 4096; n -= 4096) {
            byte[] bs = new byte[4096];
            bb.get(bs);
            this.acc = this.acc.append(Blob.wrap(bs));
            this.count = this.acc.count();
        }
        if (n <= 0) {
            return;
        }
        this.appendToFillChunk(bb);
    }

    private void appendToFillChunk(ByteBuffer bb) {
        int n = bb.remaining();
        int fill = Math.min(this.spare(), n);
        if (fill > 0) {
            this.ensureArray(this.arrayPos() + fill);
            bb.get(this.tail, this.arrayPos(), fill);
            this.count += (long)fill;
            if (this.arrayPos() == 4096) {
                this.completeChunk();
            }
        }
    }

    public void clear() {
        this.acc = Blob.EMPTY;
        this.tail = null;
        this.count = 0L;
    }
}

