/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Strings;
import convex.core.data.prim.AByteFlag;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.util.Bits;

public final class CVMBool
extends AByteFlag
implements Comparable<CVMBool> {
    private final boolean value;
    public static final CVMBool TRUE = Cells.intern(new CVMBool(true));
    public static final CVMBool FALSE = Cells.intern(new CVMBool(false));
    private static final int CANONICAL_TRUE_HASHCODE = Bits.hash32(-1342062370L);
    private static final int CANONICAL_FALSE_HASHCODE = ~CANONICAL_TRUE_HASHCODE;
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";

    private CVMBool(boolean value) {
        this.value = value;
    }

    @Override
    public AType getType() {
        return Types.BOOLEAN;
    }

    public static CVMBool create(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static CVMBool of(boolean b) {
        return b ? TRUE : FALSE;
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    @Override
    public long longValue() {
        return this.value ? 1L : 0L;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.value ? -79 : -80;
        return pos;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.value ? Strings.TRUE : Strings.FALSE);
        return bb.check(limit);
    }

    @Override
    public double doubleValue() {
        return this.value ? 1.0 : 0.0;
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public final byte getTag() {
        return this.value ? (byte)-79 : -80;
    }

    public static ACell parse(String text) {
        if (TRUE_STRING.equals(text)) {
            return TRUE;
        }
        if (FALSE_STRING.equals(text)) {
            return FALSE;
        }
        return null;
    }

    @Override
    public AString toCVMString(long limit) {
        return this.value ? Strings.TRUE : Strings.FALSE;
    }

    @Override
    public int hashCode() {
        return this.value ? CANONICAL_TRUE_HASHCODE : CANONICAL_FALSE_HASHCODE;
    }

    @Override
    public boolean equals(ACell a) {
        if (a == null) {
            return false;
        }
        if (this == a) {
            return true;
        }
        return this.getTag() == a.getTag();
    }

    public Blob toBlob() {
        return this.value ? Blob.SINGLE_ONE : Blob.SINGLE_ZERO;
    }

    public CVMBool not() {
        return this.value ? FALSE : TRUE;
    }

    public CVMBool negate() {
        return this.not();
    }

    public CVMBool and(CVMBool other) {
        return this.value && other.value ? TRUE : FALSE;
    }

    public CVMBool or(CVMBool other) {
        return this.value || other.value ? TRUE : FALSE;
    }

    public CVMBool xor(CVMBool other) {
        return this.value ^ other.value ? TRUE : FALSE;
    }

    @Override
    public String toString() {
        return this.value ? TRUE_STRING : FALSE_STRING;
    }

    @Override
    public int compareTo(CVMBool other) {
        return Boolean.compare(this.value, other.value);
    }
}

