/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.prim.AInteger;
import convex.core.data.prim.APrimitive;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ANumeric
extends APrimitive
implements Comparable<ANumeric> {
    public abstract CVMLong toLong();

    public abstract CVMDouble toDouble();

    @Override
    public abstract double doubleValue();

    public abstract Class<?> numericType();

    public abstract APrimitive signum();

    public abstract boolean isNegative();

    public abstract boolean isPositive();

    public abstract boolean isNatural();

    public abstract ANumeric abs();

    public abstract CVMLong ensureLong();

    public abstract ANumeric add(ANumeric var1);

    public abstract ANumeric sub(ANumeric var1);

    public abstract ANumeric negate();

    public abstract ANumeric multiply(ANumeric var1);

    public abstract AInteger toInteger();

    public abstract boolean isZero();

    public static <T extends ANumeric> T fromNumber(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return (T)CVMLong.create(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return (T)CVMDouble.create(number.doubleValue());
        }
        if (number instanceof BigInteger) {
            BigInteger bi = (BigInteger)number;
            return (T)AInteger.create(bi);
        }
        try {
            BigDecimal bd = new BigDecimal(number.toString());
            BigInteger bi = bd.toBigIntegerExact();
            if (bi.bitLength() <= 63) {
                return (T)CVMLong.create(bi.longValue());
            }
            return (T)CVMBigInteger.create(bi);
        }
        catch (ArithmeticException | NumberFormatException e) {
            return (T)CVMDouble.create(number.doubleValue());
        }
    }
}

