/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.impl;

import convex.core.data.ABlob;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Keyword;
import convex.core.data.StringShort;
import convex.core.data.Symbol;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class StringStore {
    static HashMap<String, Entry> stringIndex = new HashMap();
    static HashMap<Blob, Entry> blobIndex = new HashMap();

    public static Entry get(String string) {
        Entry e = stringIndex.get(string);
        return e;
    }

    public static Entry get(AString name) {
        return StringStore.get(name.toBlob());
    }

    public static Entry get(ABlob blob) {
        Entry e = blobIndex.get(blob);
        return e;
    }

    public static StringShort intern(String s) {
        Entry e = StringStore.get(s);
        if (e == null) {
            Blob b = Blob.wrap(s.getBytes(StandardCharsets.UTF_8));
            if (b.count() > 4096L) {
                throw new IllegalArgumentException("String too large to intern");
            }
            e = new Entry(b);
            e.string = s;
            StringShort astring = StringShort.wrap(b);
            e.astring = astring = Cells.intern(astring);
            stringIndex.put(s, e);
            blobIndex.put(b, e);
            return astring;
        }
        return e.getStringShort();
    }

    public static StringShort intern(AString s) {
        if (s.count() > 4096L) {
            throw new IllegalArgumentException("String too large to intern");
        }
        Blob b = s.toFlatBlob();
        Entry e = StringStore.get(b);
        if (e == null) {
            String js;
            StringShort ss;
            e = new Entry(b);
            StringShort astring = s instanceof StringShort ? (ss = (StringShort)s) : StringShort.wrap(b);
            e.astring = astring = Cells.intern(astring);
            e.string = js = astring.toString();
            stringIndex.put(js, e);
            blobIndex.put(b, e);
            return astring;
        }
        return e.getStringShort();
    }

    public static class Entry {
        String string = null;
        StringShort astring = null;
        Keyword keyword = null;
        Symbol symbol = null;
        Blob blob;

        public Entry(Blob b) {
            this.blob = b;
        }

        public StringShort getStringShort() {
            StringShort result = this.astring;
            if (result == null) {
                this.astring = result = Cells.intern(StringShort.wrap(this.blob));
            }
            return result;
        }

        public Keyword getKeyword() {
            Keyword result = this.keyword;
            if (result == null) {
                StringShort ss = this.getStringShort();
                if (!ASymbolic.validateName(ss)) {
                    return null;
                }
                this.keyword = result = Cells.intern(Keyword.unsafeCreate(ss));
            }
            return result;
        }

        public Symbol getSymbol() {
            Symbol result = this.symbol;
            if (result == null) {
                StringShort ss = this.getStringShort();
                if (!ASymbolic.validateName(ss)) {
                    return null;
                }
                this.symbol = result = Cells.intern(Symbol.unsafeCreate(ss));
            }
            return result;
        }
    }
}

