/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.data.impl.StringStore;
import convex.core.data.prim.CVMChar;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.text.Text;
import convex.core.util.ErrorMessages;
import convex.core.util.Utils;
import java.nio.charset.StandardCharsets;

public final class StringShort
extends AString {
    public static final int MAX_EMBEDDED_STRING_LENGTH = 137;
    public static final int MAX_LENGTH = 4096;
    public static final int MAX_ENCODING_LENGTH = 1 + Format.getVLQLongLength(4096L) + 4096;
    private final Blob data;
    private String _string = null;
    public static final StringShort EMPTY = StringStore.intern("");

    protected StringShort(Blob data) {
        super(data.count);
        this.data = data;
    }

    protected StringShort(byte[] data) {
        super(data.length);
        this.data = Blob.wrap(data);
    }

    protected StringShort(byte[] data, int offset, int length) {
        super(length);
        this.data = Blob.wrap(data, offset, length);
    }

    public static StringShort wrap(Blob b) {
        if (b.count() > 4096L) {
            throw new IllegalArgumentException("Invalid Blob length for StringShort");
        }
        return new StringShort(b);
    }

    public static StringShort create(String string) {
        if (string.length() == 0) {
            return EMPTY;
        }
        StringStore.Entry e = StringStore.get(string);
        if (e != null) {
            return e.getStringShort();
        }
        byte[] bs = string.getBytes(StandardCharsets.UTF_8);
        StringShort result = new StringShort(bs);
        result._string = string;
        return result;
    }

    public static StringShort intern(String string) {
        if (string.length() == 0) {
            return EMPTY;
        }
        return StringStore.intern(string);
    }

    public static StringShort create(AArrayBlob b) {
        long len = b.count();
        if (len == 0L) {
            return EMPTY;
        }
        StringStore.Entry e = StringStore.get(b);
        if (e != null) {
            return e.getStringShort();
        }
        return new StringShort(b.toFlatBlob());
    }

    @Override
    public byte byteAt(long index) {
        if (index < 0L || index >= this.length) {
            return -1;
        }
        return this.data.byteAt(index);
    }

    @Override
    public int intAt(long index) {
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            long ix = index + (long)i;
            if (ix < 0L || ix >= this.length) {
                r |= 255 << 8 * (3 - i);
                continue;
            }
            r |= (0xFF & this.data.byteAt(ix)) << 8 * (3 - i);
        }
        return r;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.length > 4096L) {
            throw new InvalidDataException("StringShort too long: " + this.length, this);
        }
        if (this.length != this.data.count) {
            throw new InvalidDataException("Wrong String length!", this);
        }
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.data.encodeRaw(bs, pos);
    }

    @Override
    public int writeRawData(byte[] bs, int pos) {
        return this.data.getBytes(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 3 + (int)this.length;
    }

    @Override
    public boolean isCanonical() {
        return this.length <= 4096L;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public boolean isEmbedded() {
        return this.length <= 137L;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (!this.isCanonical()) {
            return super.getRef(i);
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public ACell updateRefs(IRefFunction func) {
        if (!this.isCanonical()) {
            return super.updateRefs(func);
        }
        return this;
    }

    @Override
    public int getRefCount() {
        if (!this.isCanonical()) {
            return super.getRefCount();
        }
        return 0;
    }

    @Override
    public int getBranchCount() {
        if (!this.isCanonical()) {
            return super.getRefCount();
        }
        return 0;
    }

    public static StringShort read(long length, Blob blob, int pos) {
        int len = Utils.checkedInt(length);
        int headerLen = 1 + Format.getVLQCountLength(length);
        int dataOffset = pos + headerLen;
        Blob data = blob.slice(dataOffset, (long)dataOffset + length);
        StringShort result = StringShort.create(data);
        result.attachEncoding(blob.slice(pos, dataOffset + len));
        return result;
    }

    @Override
    public Blob toBlob() {
        return this.data;
    }

    @Override
    public Blob toFlatBlob() {
        return this.data;
    }

    @Override
    public boolean equals(AString b) {
        if (b == null) {
            return false;
        }
        if (this.length != b.length) {
            return false;
        }
        StringShort c = (StringShort)b.toCanonical();
        return this.equals(c);
    }

    public final boolean equals(StringShort a) {
        if (a == this) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return this.data.equals(a.data);
    }

    @Override
    public int compareTo(ABlobLike<?> o) {
        return this.data.compareTo(o);
    }

    @Override
    public AString toCanonical() {
        if (this.length <= 4096L) {
            return this;
        }
        return Strings.create((ABlob)this.data.getCanonical());
    }

    @Override
    public AString slice(long start, long end) {
        Blob newData = this.data.slice(start, end);
        if (this.data == newData) {
            return this;
        }
        if (newData == null) {
            return null;
        }
        return StringShort.create(newData);
    }

    @Override
    protected void printEscaped(BlobBuilder sb, long start, long end) {
        long n = this.count();
        if (start < 0L || start > end || end > n) {
            throw new IllegalArgumentException(ErrorMessages.badRange(start, end));
        }
        for (long i = start; i < end; ++i) {
            byte b = this.data.byteAtUnchecked(i);
            if (b >= 0) {
                Text.writeEscapedByte(sb, b);
                continue;
            }
            int cp = this.charAt(i);
            if (cp < 0) {
                sb.append(CVMChar.BAD_CHARACTER);
                ++i;
                continue;
            }
            int len = CVMChar.utfLength(cp);
            for (int j = 0; j < len; ++j) {
                sb.append(this.byteAt(i + (long)j));
            }
            i += (long)(len - 1);
        }
    }

    @Override
    public boolean equalsBytes(ABlob b) {
        return this.data.equalsBytes(b);
    }

    @Override
    public long longValue() {
        return this.data.longValue();
    }

    @Override
    public String toString() {
        String result = this._string;
        if (result != null) {
            return result;
        }
        byte[] bytes = this.data.getInternalArray();
        if ((long)bytes.length != this.data.count()) {
            bytes = this.data.getBytes();
        }
        this._string = result = new String(bytes, StandardCharsets.UTF_8);
        return result;
    }
}

