/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.MapEntry;
import convex.core.data.MapLeaf;
import convex.core.data.MapTree;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Maps {
    private static final AMap<?, ?> EMPTY_MAP = Cells.intern(MapLeaf.emptyMap());
    public static final Ref<AMap<?, ?>> EMPTY_REF = EMPTY_MAP.getRef();
    public static int MAX_ENCODING_SIZE = Math.max(MapTree.MAX_ENCODING_LENGTH, MapLeaf.MAX_ENCODING_LENGTH);

    public static <K extends ACell, V extends ACell, R extends AHashMap<K, V>> R empty() {
        return (R)((AHashMap)EMPTY_MAP);
    }

    public static <K extends ACell, V extends ACell, R extends AMap<K, V>> Ref<R> emptyRef() {
        return EMPTY_REF;
    }

    public static <K extends ACell, V extends ACell> MapLeaf<K, V> create(K k, V v) {
        return MapLeaf.create(MapEntry.create(k, v));
    }

    public static <R extends AHashMap<K, V>, K extends ACell, V extends ACell> R of(Object ... keysAndValues) {
        int n = keysAndValues.length >> 1;
        if (keysAndValues.length != n * 2) {
            throw new IllegalArgumentException("Even number of values need for key-value pairs");
        }
        Object result = Maps.empty();
        for (int i = 0; i < n; ++i) {
            Object key = RT.cvm(keysAndValues[i * 2]);
            Object value = RT.cvm(keysAndValues[i * 2 + 1]);
            result = ((AMap)result).assoc((ACell)key, (ACell)value);
        }
        return (R)((AHashMap)result);
    }

    public static <R extends AHashMap<K, V>, K extends ACell, V extends ACell> R create(ACell[] keysAndValues) {
        int n = keysAndValues.length >> 1;
        if (keysAndValues.length != n * 2) {
            throw new IllegalArgumentException("Even number of values need for key-value pairs");
        }
        Object result = Maps.empty();
        for (int i = 0; i < n; ++i) {
            ACell key = keysAndValues[i * 2];
            ACell value = keysAndValues[i * 2 + 1];
            result = ((AMap)result).assoc(key, value);
        }
        return (R)((AHashMap)result);
    }

    public static <K, V> HashMap<K, V> hashMapOf(Object ... keysAndValues) {
        int n = keysAndValues.length >> 1;
        HashMap<Object, Object> result = new HashMap<Object, Object>(n);
        if (keysAndValues.length != n * 2) {
            throw new IllegalArgumentException("Even number of values need for key-value pairs");
        }
        for (int i = 0; i < n; ++i) {
            Object key = keysAndValues[i * 2];
            Object value = keysAndValues[i * 2 + 1];
            result.put(key, value);
        }
        return result;
    }

    public static <K extends ACell, V extends ACell> AHashMap<K, V> create(List<MapEntry<K, V>> entries) {
        return Maps.createWithShift(0, entries);
    }

    public static <K extends ACell, V extends ACell> AHashMap<K, V> createWithShift(int shift, List<MapEntry<K, V>> entries) {
        int n = entries.size();
        if (n == 0) {
            return Maps.empty();
        }
        Object result = Maps.empty();
        for (int i = 0; i < n; ++i) {
            AVector v = entries.get(i);
            MapEntry e = MapEntry.convertOrNull(v);
            result = ((AHashMap)result).assocEntry(e);
        }
        return result;
    }

    public static <K extends ACell, V extends ACell, R extends AMap<K, V>> R coerce(AMap<?, ?> m) {
        return (R)m;
    }

    public static <K extends ACell, V extends ACell> AHashMap<K, V> read(Blob b, int pos) throws BadFormatException {
        long count = Format.readVLQCount(b, pos + 1);
        if (count == 0L) {
            return Maps.empty();
        }
        if (count <= 15L) {
            if (count < 0L) {
                throw new BadFormatException("Overflowed count of map elements!");
            }
            return MapLeaf.read(b, pos, count);
        }
        return MapTree.read(b, pos, count);
    }

    public static <K extends ACell, V extends ACell> Hash getFirstHash(AHashMap<K, V> map) {
        return map.getFirstHash();
    }

    public static <K extends ACell, V extends ACell> AMap<K, V> zipMap(AVector<K> keys, AVector<V> values) {
        Object result = Maps.empty();
        long n = Math.min(keys.count(), values.count());
        for (long i = 0L; i < n; ++i) {
            result = ((AMap)result).assoc((ACell)keys.get(i), (ACell)values.get(i));
        }
        return result;
    }

    public static <K extends ACell, V extends ACell> AMap<K, V> fromEntries(Collection<MapEntry<K, V>> entries) {
        Object result = Maps.empty();
        for (MapEntry<K, V> me : entries) {
            result = ((AMap)result).assocEntry(me);
        }
        return result;
    }
}

