/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AMapEntry;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.ErrorMessages;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class MapEntry<K extends ACell, V extends ACell>
extends AMapEntry<K, V>
implements Comparable<MapEntry<K, V>> {
    private final Ref<K> keyRef;
    private final Ref<V> valueRef;

    private MapEntry(Ref<K> key, Ref<V> value) {
        super(2L);
        this.keyRef = key;
        this.valueRef = value;
    }

    @Override
    public AType getType() {
        return Types.VECTOR;
    }

    public static <K extends ACell, V extends ACell> MapEntry<K, V> fromRefs(Ref<? extends K> keyRef, Ref<? extends V> valueRef) {
        return new MapEntry<K, V>(keyRef, valueRef);
    }

    public static <K extends ACell, V extends ACell> MapEntry<K, V> create(K key, V value) {
        return MapEntry.fromRefs(Ref.get(key), Ref.get(value));
    }

    public static <K extends ACell, V extends ACell> MapEntry<K, V> of(Object key, Object value) {
        return MapEntry.create(RT.cvm(key), RT.cvm(value));
    }

    public static MapEntry convertOrNull(AVector v) {
        if (v.count() != 2L) {
            return null;
        }
        return MapEntry.fromRefs(v.getElementRef(0L), v.getElementRef(1L));
    }

    @Override
    public MapEntry<K, V> withValue(V value) {
        if (value == this.getValue()) {
            return this;
        }
        return new MapEntry<K, V>(this.keyRef, Ref.get(value));
    }

    @Override
    public MapEntry<K, V> assoc(long i, ACell a) {
        if (i == 0L) {
            return this.withKey(a);
        }
        if (i == 1L) {
            return this.withValue(a);
        }
        return null;
    }

    @Override
    protected MapEntry<K, V> withKey(K key) {
        if (key == this.getKey()) {
            return this;
        }
        return new MapEntry<K, V>(Ref.get(key), this.valueRef);
    }

    @Override
    public K getKey() {
        return this.keyRef.getValue();
    }

    @Override
    public <R extends ACell> AVector<R> map(Function<ACell, R> mapper) {
        return Vectors.of(mapper.apply((ACell)this.getKey()), mapper.apply((ACell)this.getValue()));
    }

    @Override
    public <R> R reduce(BiFunction<? super R, ? super ACell, ? extends R> func, R value) {
        R result = func.apply(value, (ACell)this.getKey());
        result = func.apply(result, (ACell)this.getKey());
        return result;
    }

    @Override
    protected <R> void copyToArray(R[] arr, int offset) {
        arr[offset] = this.getKey();
        arr[offset + 1] = this.getValue();
    }

    public Hash getKeyHash() {
        return this.getKeyRef().getHash();
    }

    @Override
    public V getValue() {
        return this.valueRef.getValue();
    }

    public Ref<K> getKeyRef() {
        return this.keyRef;
    }

    public Ref<V> getValueRef() {
        return this.valueRef;
    }

    @Override
    public int compareTo(MapEntry<K, V> o) {
        if (this == o) {
            return 0;
        }
        return this.keyRef.compareTo(o.keyRef);
    }

    @Override
    public final int getRefCount() {
        return 2;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i >> 1 != 0) {
            throw new IndexOutOfBoundsException(i);
        }
        return i == 0 ? this.keyRef : this.valueRef;
    }

    @Override
    public MapEntry<K, V> updateRefs(IRefFunction func) {
        Ref newKeyRef = func.apply(this.keyRef);
        Ref newValueRef = func.apply(this.valueRef);
        if (this.keyRef == newKeyRef && this.valueRef == newValueRef) {
            return this;
        }
        MapEntry<K, V> result = new MapEntry<K, V>(newKeyRef, newValueRef);
        result.attachEncoding(this.encoding);
        return result;
    }

    @Override
    public boolean equals(AVector<?> o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        AVector<?> v = o;
        if (v.count() != 2L) {
            return false;
        }
        return this.getEncoding().equals(o.getEncoding());
    }

    public boolean equals(MapEntry<K, V> b) {
        if (this == b) {
            return true;
        }
        return this.keyRef.equals(b.keyRef) && this.valueRef.equals(b.valueRef);
    }

    public boolean keyEquals(MapEntry<K, V> b) {
        return this.keyRef.equals(b.keyRef);
    }

    @Override
    public ACell get(long i) {
        if (i == 0L) {
            return this.getKey();
        }
        if (i == 1L) {
            return this.getValue();
        }
        throw new IndexOutOfBoundsException(ErrorMessages.badIndex(i));
    }

    @Override
    public Ref<ACell> getElementRef(long i) {
        if (i == 0L) {
            return this.keyRef;
        }
        if (i == 1L) {
            return this.valueRef;
        }
        throw new IndexOutOfBoundsException(ErrorMessages.badIndex(i));
    }

    @Override
    protected Ref<ACell> getElementRefUnsafe(long i) {
        if (i == 0L) {
            return this.keyRef;
        }
        return this.valueRef;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -128;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLQCount(bs, pos, 2L);
        return this.encodeRefs(bs, pos);
    }

    int encodeRefs(byte[] bs, int pos) {
        pos = this.keyRef.encode(bs, pos);
        pos = this.valueRef.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 282;
    }

    @Override
    public void visitElementRefs(Consumer<Ref<ACell>> f) {
        f.accept(this.keyRef);
        f.accept(this.valueRef);
    }

    @Override
    public AVector<ACell> concat(ASequence<?> b) {
        if (b.isEmpty()) {
            return this;
        }
        return this.toVector().concat(b);
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public AVector<ACell> toCanonical() {
        return this;
    }

    @Override
    public AVector<ACell> toVector() {
        return new VectorLeaf<ACell>(new Ref[]{this.keyRef, this.valueRef});
    }

    @Override
    protected void visitAllChildren(Consumer<AVector<ACell>> visitor) {
    }

    @Override
    public AVector<ACell> dissocAt(long i) {
        if (i == 0L) {
            return Vectors.create(new ACell[]{this.get(1)});
        }
        if (i == 1L) {
            return Vectors.create(new ACell[]{this.get(0)});
        }
        return null;
    }
}

