/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Index;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Symbol;
import convex.core.data.impl.DummyCell;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.ParseException;
import convex.core.exceptions.TODOException;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Utils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;

public class Cells {
    public static final ACell[] EMPTY_ARRAY = new ACell[0];
    public static final int MAX_BRANCH_COUNT = 68;
    public static final ACell DUMMY = new DummyCell();
    public static final ACell NIL = null;
    public static final Comparator<ACell> countComparator = (a, b) -> {
        Long ca = RT.count(a);
        Long cb = RT.count(b);
        if (ca == null) {
            return cb == null ? 0 : -1;
        }
        if (cb == null) {
            return 1;
        }
        return Long.signum(ca - cb);
    };

    public static boolean equals(ACell a, ACell b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equalsGeneric(ACell a, ACell b) {
        Hash hb;
        if (a == b) {
            return true;
        }
        if (b == null || a == null) {
            return false;
        }
        if (a.getTag() != b.getTag()) {
            return false;
        }
        Hash ha = a.cachedHash();
        if (ha != null && (hb = b.cachedHash()) != null) {
            return ha.equals(hb);
        }
        return a.getEncoding().equals(b.getEncoding());
    }

    public static ACell[] toCellArray(Object any) {
        if (any instanceof Collection) {
            return Cells.toCellArray((Collection)any);
        }
        if (any.getClass().isArray()) {
            int n = Array.getLength(any);
            ACell[] result = new ACell[n];
            for (int i = 0; i < n; ++i) {
                result[i] = (ACell)Array.get(any, i);
            }
            return result;
        }
        throw new IllegalArgumentException("Can't get cell array from " + Utils.getClassName(any));
    }

    public static ACell[] toCellArray(Collection<? extends ACell> coll) {
        int n = coll.size();
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        return coll.toArray(new ACell[n]);
    }

    public static int refCount(ACell a) {
        if (a == null) {
            return 0;
        }
        return a.getRefCount();
    }

    public static int branchCount(ACell v) {
        if (v == null) {
            return 0;
        }
        return v.getBranchCount();
    }

    public static <R extends ACell> Ref<R> getRef(ACell cell, int index) {
        if (cell == null) {
            throw new IndexOutOfBoundsException("getRef called on null");
        }
        return cell.getRef(index);
    }

    public static boolean isCVM(ACell a) {
        if (a == null) {
            return true;
        }
        return a.isCVMValue();
    }

    public static boolean isCompletelyEncoded(ACell a) {
        if (a == null) {
            return true;
        }
        return a.isCompletelyEncoded();
    }

    public static <T extends ACell> T persist(T a) throws IOException {
        AStore store = Stores.current();
        return Cells.persist(a, store);
    }

    public static <T extends ACell> T persist(T a, AStore store) throws IOException {
        Ref<T> ref = Ref.get(a);
        Ref<T> sref = store.storeTopRef(ref, 3, null);
        return sref.getValue();
    }

    public static <T extends ACell> T store(T a, AStore store) throws IOException {
        Ref<T> ref = Ref.get(a);
        Ref<T> sref = store.storeTopRef(ref, 1, null);
        return sref.getValue();
    }

    public static <T extends ACell> T announce(T a, Consumer<Ref<ACell>> noveltyHandler) throws IOException {
        if (a == null) {
            return null;
        }
        Ref ref = Stores.current().storeTopRef(a.getRef(), 4, noveltyHandler);
        return (T)ref.getValue();
    }

    public static Hash getHash(ACell a) {
        if (a == null) {
            return Hash.NULL_HASH;
        }
        return a.getRef().getHash();
    }

    public static Blob getEncoding(ACell a) {
        if (a == null) {
            return Blob.NULL_ENCODING;
        }
        return a.getEncoding();
    }

    public static long storageSize(ACell a) {
        if (a == null) {
            return 1L;
        }
        long memSize = a.getMemorySize();
        if (a.isEmbedded()) {
            memSize += (long)a.getEncodingLength();
        }
        return memSize;
    }

    public static void visitBranchRefs(ACell a, Consumer<Ref<?>> visitor) {
        if (a == null) {
            return;
        }
        int n = a.getRefCount();
        for (int i = 0; i < n; ++i) {
            Ref ref = a.getRef(i);
            if (ref.isEmbedded()) {
                Object child = ref.getValue();
                if (child == null) continue;
                Cells.visitBranchRefs(ref.getValue(), visitor);
                continue;
            }
            visitor.accept(ref);
        }
    }

    public static void visitBranches(ACell a, Consumer<ACell> visitor) {
        if (a == null) {
            return;
        }
        int n = a.getRefCount();
        for (int i = 0; i < n; ++i) {
            Ref ref = a.getRef(i);
            if (ref.isEmbedded()) {
                Object child = ref.getValue();
                if (child == null) continue;
                Cells.visitBranches(ref.getValue(), visitor);
                continue;
            }
            visitor.accept((ACell)ref.getValue());
        }
    }

    public static <T extends ACell> T intern(T value) {
        Ref<T> ref = Ref.get(value);
        if (ref.isInternal()) {
            return value;
        }
        ref.setFlags(Ref.mergeFlags(ref.getFlags(), 15));
        return value;
    }

    public static ACell createTagged(Symbol sym, ACell value) throws ParseException {
        switch (sym.getName().toString()) {
            case "Index": {
                if (!(value instanceof AHashMap)) {
                    throw new ParseException(String.valueOf(sym) + " tag must be on a map");
                }
                Index index = (Index)Index.create((AHashMap)value);
                if (index == null) {
                    throw new ParseException("Invalid #Index keys");
                }
                return index;
            }
            case "Result": {
                if (!(value instanceof AHashMap)) {
                    throw new ParseException(String.valueOf(sym) + " tag must be on a map");
                }
                Result r = Result.fromData((AHashMap)value);
                if (r == null) {
                    throw new ParseException("Invalid #Result keys");
                }
                return r;
            }
            case "Signed": {
                if (!(value instanceof AHashMap)) {
                    throw new ParseException(String.valueOf(sym) + " tag must be on a map");
                }
                SignedData r = SignedData.fromData((AHashMap)value);
                if (r == null) {
                    throw new ParseException("Invalid #Signed keys");
                }
                return r;
            }
        }
        return value;
    }

    public static void validate(ACell cell) throws InvalidDataException {
        if (cell == null) {
            return;
        }
        Ref ref = cell.getRef();
        if (ref.isValidated()) {
            return;
        }
        try {
            cell.validateCell();
            cell.validateStructure();
        }
        catch (Exception e) {
            throw new InvalidDataException("Invalid due to failure " + e.getMessage(), cell);
        }
    }

    public static void markValidated(ACell cell) {
        cell.getRef().mergeFlags(2);
        throw new TODOException("Probably not safe?");
    }

    public static Hash cachedHash(ACell k) {
        if (k == null) {
            return Hash.NULL_HASH;
        }
        return k.cachedHash();
    }

    public static boolean isCanonical(ACell o) {
        if (o == null) {
            return true;
        }
        return o.isCanonical();
    }

    public static boolean isEmbedded(ACell cell) {
        if (cell == null) {
            return true;
        }
        return cell.isEmbedded();
    }

    public static Blob encode(ACell o) {
        if (o == null) {
            return Blob.NULL_ENCODING;
        }
        return o.getEncoding();
    }

    public static int getEncodingLength(ACell value) {
        if (value == null) {
            return 1;
        }
        return value.getEncodingLength();
    }

    public static void validateCell(ACell a) throws InvalidDataException {
        if (a == null) {
            return;
        }
        a.validateCell();
    }
}

