/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.cvm.Address;
import convex.core.cvm.Syntax;
import convex.core.data.ACell;
import convex.core.data.AEncoder;
import convex.core.data.ARecord;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Cells;
import convex.core.data.ExtensionValue;
import convex.core.data.Format;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.List;
import convex.core.data.Maps;
import convex.core.data.Sets;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.AByteFlag;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.util.ErrorMessages;

public class CAD3Encoder
extends AEncoder<ACell> {
    @Override
    public Blob encode(ACell a) {
        return Cells.encode(a);
    }

    @Override
    public ACell decode(Blob encoding) throws BadFormatException {
        if (encoding.count() < 1L) {
            throw new BadFormatException("Empty encoding");
        }
        return this.read(encoding, 0);
    }

    @Override
    protected ACell read(Blob encoding, int offset) throws BadFormatException {
        byte tag = encoding.byteAtUnchecked(offset);
        ACell result = this.read(tag, encoding, offset);
        return result;
    }

    protected ACell read(byte tag, Blob encoding, int offset) throws BadFormatException {
        switch (tag >> 4) {
            case 0: {
                if (tag != 0) break;
                return null;
            }
            case 1: {
                return this.readNumeric(tag, encoding, offset);
            }
            case 2: {
                if (tag != -22) break;
                return Address.read(encoding, offset);
            }
            case 3: {
                return this.readBasicObject(tag, encoding, offset);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                return this.readDataStructure(tag, encoding, offset);
            }
            case 9: {
                return this.readSignedData(tag, encoding, offset);
            }
            case 10: {
                return this.readSparseRecord(tag, encoding, offset);
            }
            case 11: {
                return AByteFlag.read(tag);
            }
            case 12: {
                return this.readCodedData(tag, encoding, offset);
            }
            case 13: {
                return this.readDenseRecord(tag, encoding, offset);
            }
            case 14: {
                return this.readExtension(tag, encoding, offset);
            }
        }
        return Format.read(tag, encoding, offset);
    }

    protected ANumeric readNumeric(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag < 25) {
            return CVMLong.read(tag, blob, offset);
        }
        if (tag == 25) {
            return CVMBigInteger.read(blob, offset);
        }
        if (tag == 29) {
            return CVMDouble.read(tag, blob, offset);
        }
        throw new BadFormatException(ErrorMessages.badTagMessage(tag));
    }

    protected ACell readBasicObject(byte tag, Blob blob, int offset) throws BadFormatException {
        switch (tag) {
            case 50: {
                return Symbol.read(blob, offset);
            }
            case 51: {
                return Keyword.read(blob, offset);
            }
            case 49: {
                return Blobs.read(blob, offset);
            }
            case 48: {
                return Strings.read(blob, offset);
            }
        }
        if ((tag & 0x3C) == 60) {
            int len = CVMChar.byteCountFromTag(tag);
            if (len > 4) {
                throw new BadFormatException("Can't read char type with length: " + len);
            }
            return CVMChar.read(len, blob, offset);
        }
        throw new BadFormatException(ErrorMessages.badTagMessage(tag));
    }

    protected ACell readDataStructure(byte tag, Blob b, int pos) throws BadFormatException {
        if (tag == -128) {
            return Vectors.read(b, pos);
        }
        if (tag == -126) {
            return Maps.read(b, pos);
        }
        if (tag == -120) {
            return Syntax.read(b, pos);
        }
        if (tag == -125) {
            return Sets.read(b, pos);
        }
        if (tag == -127) {
            return List.read(b, pos);
        }
        if (tag == -124) {
            return Index.read(b, pos);
        }
        throw new BadFormatException("Can't read data structure with tag byte: " + tag);
    }

    protected SignedData<?> readSignedData(byte tag, Blob blob, int offset) throws BadFormatException {
        if (tag == -112) {
            return SignedData.read(blob, offset, true);
        }
        if (tag == -111) {
            return SignedData.read(blob, offset, false);
        }
        throw new BadFormatException(ErrorMessages.badTagMessage(tag));
    }

    protected ARecord<?, ?> readSparseRecord(byte tag, Blob encoding, int offset) throws BadFormatException {
        throw new BadFormatException("Not yet implemented.");
    }

    protected ACell readCodedData(byte tag, Blob encoding, int offset) throws BadFormatException {
        return Format.read(tag, encoding, offset);
    }

    protected ACell readDenseRecord(byte tag, Blob encoding, int offset) throws BadFormatException {
        return Format.read(tag, encoding, offset);
    }

    protected ACell readExtension(byte tag, Blob blob, int offset) throws BadFormatException {
        long code = Format.readVLQCount(blob, offset + 1);
        return ExtensionValue.create(tag, code);
    }

    @Override
    public ACell decodeMultiCell(Blob enc) throws BadFormatException {
        return Format.decodeMultiCell(enc);
    }
}

