/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AList;
import convex.core.data.ASequence;
import convex.core.data.IRefFunction;
import convex.core.data.List;
import convex.core.data.Lists;
import convex.core.data.Ref;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.lang.RT;
import convex.core.util.MergeFunction;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AVector<T extends ACell>
extends ASequence<T> {
    public AVector(long count) {
        super(count);
    }

    @Override
    public AType getType() {
        return Types.VECTOR;
    }

    @Override
    public abstract T get(long var1);

    public abstract AVector<T> dissocAt(long var1);

    public abstract AVector<T> appendChunk(AVector<T> var1);

    public abstract VectorLeaf<T> getChunk(long var1);

    public abstract AVector<T> append(T var1);

    public abstract boolean isFullyPacked();

    public boolean isPacked() {
        return (this.count & 0xFL) == 0L;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append('[');
        long size = this.count();
        for (long i = 0L; i < size; ++i) {
            if (i > 0L) {
                sb.append(' ');
            }
            if (RT.print(sb, this.get(i), limit)) continue;
            return false;
        }
        sb.append(']');
        return sb.check(limit);
    }

    @Override
    public final T get(int index) {
        return this.get((long)index);
    }

    public abstract boolean anyMatch(Predicate<? super T> var1);

    public abstract boolean allMatch(Predicate<? super T> var1);

    @Override
    public abstract <R extends ACell> AVector<R> map(Function<T, R> var1);

    @Override
    public <R extends ACell> AVector<R> flatMap(Function<T, ASequence<R>> mapper) {
        ASequence vals = this.map((Function)mapper);
        ASequence result = this.empty();
        for (ASequence seq : vals) {
            result = ((AVector)result).concat(seq);
        }
        return result;
    }

    @Override
    protected <R> void copyToArray(R[] arr, int offset) {
        int i = 0;
        while ((long)i < this.count) {
            arr[offset + i] = this.get(i);
            ++i;
        }
    }

    @Override
    public abstract AVector<T> concat(ASequence<? extends T> var1);

    public abstract <R> R reduce(BiFunction<? super R, ? super T, ? extends R> var1, R var2);

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        int s = this.size();
        Object[] result = new Object[s];
        this.copyToArray(result, 0);
        return result;
    }

    @Override
    public final ListIterator<T> listIterator(int index) {
        return this.listIterator((long)index);
    }

    @Override
    public abstract ListIterator<T> listIterator(long var1);

    @Override
    public abstract boolean isCanonical();

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public AVector<T> toVector() {
        return this;
    }

    @Override
    public abstract AVector<T> updateRefs(IRefFunction var1);

    public abstract long commonPrefixLength(AVector<T> var1);

    public AVector<T> appendAll(java.util.List<T> list) {
        AVector<ACell> result = this;
        for (ACell value : list) {
            result = result.append(value);
        }
        return result;
    }

    @Override
    public final AVector<T> conj(ACell value) {
        return this.append(value);
    }

    @Override
    public AVector<T> conjAll(ACollection<? extends T> xs) {
        if (xs instanceof ASequence) {
            return this.concat((ASequence)xs);
        }
        return this.concat((ASequence)Vectors.create(xs));
    }

    @Override
    public AList<T> cons(T x) {
        return ((AList)Lists.create(this)).cons(x);
    }

    @Override
    public abstract AVector<T> next();

    @Override
    public AVector<T> slice(long start) {
        return this.slice(start, this.count);
    }

    @Override
    public abstract AVector<T> slice(long var1, long var3);

    @Override
    public final AVector<T> subVector(long start, long length) {
        return this.slice(start, start + length);
    }

    @Override
    public abstract AVector<T> assoc(long var1, T var3);

    @Override
    public AVector<T> empty() {
        return VectorLeaf.EMPTY;
    }

    @Override
    public AList<T> reversed() {
        return List.reverse(this);
    }

    public AVector<T> mergeWith(AVector<T> b, MergeFunction<T> func) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean equals(ACell a) {
        if (a instanceof AVector) {
            AVector v = (AVector)a;
            return this.equals(v);
        }
        return false;
    }

    public abstract boolean equals(AVector<?> var1);

    @Override
    public final byte getTag() {
        return -128;
    }

    @Override
    public abstract int encodeRaw(byte[] var1, int var2);

    protected abstract Ref<T> getElementRefUnsafe(long var1);

    protected abstract void visitAllChildren(Consumer<AVector<T>> var1);
}

