/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.Format;

public abstract class ASparseRecord
extends ARecord<ACell, ACell> {
    protected final long inclusion;

    protected ASparseRecord(byte tag, long mask) {
        super(tag, Long.bitCount(mask));
        this.inclusion = mask;
        if (mask < 0L) {
            throw new IllegalArgumentException("Negative mask");
        }
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.tag;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        long n = this.count();
        pos = Format.writeVLQCount(bs, pos, n);
        int i = 0;
        while ((long)i < n) {
            pos = this.getRef(i).encode(bs, pos);
            ++i;
        }
        return pos;
    }
}

