/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.ASet;
import convex.core.data.AVector;
import convex.core.data.Hash;
import convex.core.data.IAssociative;
import convex.core.data.MapEntry;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.TODOException;
import convex.core.lang.RT;
import convex.core.util.ErrorMessages;
import convex.core.util.MergeFunction;
import convex.core.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AMap<K extends ACell, V extends ACell>
extends ADataStructure<MapEntry<K, V>>
implements Map<K, V>,
IAssociative<K, V> {
    protected AMap(long count) {
        super(count);
    }

    @Override
    public AType getType() {
        return Types.MAP;
    }

    public abstract AMap<K, V> assoc(ACell var1, ACell var2);

    public abstract AMap<K, V> dissoc(ACell var1);

    public final boolean containsKeyRef(Ref<ACell> ref) {
        return this.getKeyRefEntry(ref) != null;
    }

    @Override
    public boolean containsKey(ACell key) {
        return this.getEntry(key) != null;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.containsKey((ACell)RT.cvm(key));
    }

    @Override
    public final boolean containsValue(Object value) {
        if (value instanceof ACell) {
            ACell cell = (ACell)value;
            return this.containsValue(cell);
        }
        return false;
    }

    public abstract boolean containsValue(ACell var1);

    public abstract MapEntry<K, V> getKeyRefEntry(Ref<ACell> var1);

    protected abstract void accumulateEntries(Collection<Map.Entry<K, V>> var1);

    protected abstract void accumulateKeySet(Set<K> var1);

    protected abstract void accumulateValues(List<V> var1);

    @Override
    public final V put(K key, V value) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public final V remove(Object key) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public abstract void forEach(BiConsumer<? super K, ? super V> var1);

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append('{');
        long n = this.count();
        for (long i = 0L; i < n; ++i) {
            MapEntry<K, V> e = this.entryAt(i);
            Object k = e.getKey();
            if (!RT.print(sb, (ACell)k, limit)) {
                return false;
            }
            sb.append(' ');
            Object v = e.getValue();
            if (!RT.print(sb, (ACell)v, limit)) {
                return false;
            }
            if (i >= n - 1L) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.check(limit);
    }

    public abstract AMap<K, V> assocEntry(MapEntry<K, V> var1);

    public abstract MapEntry<K, V> entryAt(long var1);

    @Override
    public Ref<MapEntry<K, V>> getElementRef(long index) {
        this.checkIndex(index);
        return this.entryAt(index).getRef();
    }

    @Override
    public final MapEntry<K, V> get(long i) {
        this.checkIndex(i);
        return this.entryAt(i);
    }

    public abstract MapEntry<K, V> getEntry(ACell var1);

    @Override
    public final V get(Object key) {
        if (key == null || key instanceof ACell) {
            return this.get((ACell)key);
        }
        return null;
    }

    public abstract V get(ACell var1);

    public V get(ACell key, ACell notFound) {
        MapEntry<K, V> me = this.getEntry(key);
        if (me == null) {
            return (V)notFound;
        }
        return (V)me.getValue();
    }

    public abstract <R> R reduceValues(BiFunction<? super R, ? super V, ? extends R> var1, R var2);

    public AMap<K, V> filterValues(Predicate<V> pred) {
        throw new TODOException();
    }

    public abstract <R> R reduceEntries(BiFunction<? super R, MapEntry<K, V>, ? extends R> var1, R var2);

    @Override
    public Set<K> keySet() {
        ASet ks = this.reduceEntries((s, me) -> s.conj((ACell)me.getKey()), Sets.empty());
        return ks;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        int len = this.size();
        HashSet<Map.Entry<K, V>> h = new HashSet<Map.Entry<K, V>>(len);
        this.accumulateEntries(h);
        return h;
    }

    protected abstract MapEntry<K, V> getEntryByHash(Hash var1);

    public AMap<K, V> conj(ACell x) {
        MapEntry me = RT.ensureMapEntry(x);
        if (me == null) {
            return null;
        }
        return this.assocEntry(me);
    }

    public AVector<MapEntry<K, V>> entryVector() {
        return this.reduceEntries((acc, e) -> acc.conj((ACell)e), Vectors.empty());
    }

    public AMap<K, V> merge(AMap<K, V> m) {
        AMap<K, V> result = this;
        long n = m.count();
        int i = 0;
        while ((long)i < n) {
            if ((result = result.assocEntry(m.entryAt(i))) == null) {
                return null;
            }
            ++i;
        }
        return result;
    }

    public AMap<K, V> slice(long start) {
        return this.slice(start, this.count);
    }

    @Override
    public abstract AMap<K, V> empty();

    public AMap<K, V> slice(long start, long end) {
        ADataStructure r = this.empty();
        for (long i = start; i < end; ++i) {
            if ((r = ((AMap)r).conj(this.get(i))) != null) continue;
            return null;
        }
        return r;
    }

    public AVector<K> getKeys() {
        int n = Utils.checkedInt(this.count);
        ACell[] keys = new ACell[n];
        for (int i = 0; i < n; ++i) {
            keys[i] = this.entryAt(i).getKey();
        }
        return Vectors.wrap(keys);
    }

    @Override
    public AVector<V> values() {
        int len = this.size();
        ArrayList al = new ArrayList(len);
        this.accumulateValues(al);
        return Vectors.create(al);
    }

    public abstract AMap<K, V> mergeDifferences(AMap<K, V> var1, MergeFunction<V> var2);

    @Override
    public abstract <R extends ACell> ADataStructure<R> map(Function<MapEntry<K, V>, R> var1);
}

