/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.AMap;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.MergeFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AHashMap<K extends ACell, V extends ACell>
extends AMap<K, V> {
    protected AHashMap(long count) {
        super(count);
    }

    @Override
    public AHashMap<K, V> empty() {
        return Maps.empty();
    }

    @Override
    public abstract AHashMap<K, V> assoc(ACell var1, ACell var2);

    public abstract AHashMap<K, V> assocRef(Ref<K> var1, V var2);

    @Override
    public abstract AHashMap<K, V> assocEntry(MapEntry<K, V> var1);

    @Override
    public abstract AHashMap<K, V> dissoc(ACell var1);

    public abstract AHashMap<K, V> dissocHash(Hash var1);

    @Override
    public AHashMap<K, V> merge(AHashMap<K, V> m) {
        AMap result = this;
        long n = m.count();
        int i = 0;
        while ((long)i < n) {
            result = result.assocEntry(m.entryAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public AHashMap<K, V> merge(AMap<K, V> m) {
        if (m instanceof AHashMap) {
            return this.merge((AHashMap)m);
        }
        return (AHashMap)super.merge(m);
    }

    @Override
    public AHashMap<K, V> mergeDifferences(AMap<K, V> b, MergeFunction<V> func) {
        if (b instanceof AHashMap) {
            return this.mergeDifferences((AHashMap)b, func, 0);
        }
        throw new UnsupportedOperationException("Cannot merge maps for different type");
    }

    protected abstract AHashMap<K, V> mergeDifferences(AHashMap<K, V> var1, MergeFunction<V> var2, int var3);

    public abstract AHashMap<K, V> mergeWith(AHashMap<K, V> var1, MergeFunction<V> var2);

    protected abstract AHashMap<K, V> mergeWith(AHashMap<K, V> var1, MergeFunction<V> var2, int var3);

    @Override
    public AHashMap<K, V> filterValues(Predicate<V> pred) {
        return this.mergeWith(this, (a, b) -> pred.test(a) ? a : null);
    }

    public abstract AHashMap<K, V> mapEntries(Function<MapEntry<K, V>, MapEntry<K, V>> var1);

    @Override
    public <R extends ACell> ADataStructure<R> map(Function<MapEntry<K, V>, R> mapper) {
        return this.mapEntries(mapper);
    }

    protected abstract void validateWithPrefix(Hash var1, int var2) throws InvalidDataException;

    @Override
    public abstract AHashMap<K, V> updateRefs(IRefFunction var1);

    public abstract boolean containsAllKeys(AHashMap<K, V> var1);

    @Override
    public final boolean containsKey(ACell key) {
        if (this.count == 0L) {
            return false;
        }
        return this.getEntry(key) != null;
    }

    @Override
    public abstract int encode(byte[] var1, int var2);

    protected abstract Hash getFirstHash();

    @Override
    public AHashMap<K, V> slice(long start) {
        return this.slice(start, this.count);
    }

    @Override
    public abstract AHashMap<K, V> slice(long var1, long var3);
}

