/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.impl.LongBlob;
import convex.core.data.prim.CVMLong;
import convex.core.util.Bits;
import convex.core.util.ErrorMessages;
import convex.core.util.Utils;
import java.io.InputStream;

public abstract class AExtensionValue
extends ABlobLike<CVMLong> {
    protected static final int BYTE_LENGTH = 8;
    protected final long value;

    protected AExtensionValue(long value) {
        this.value = value;
    }

    @Override
    public final long count() {
        return 8L;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10;
    }

    public Blob slice(long start, long end) {
        return this.toFlatBlob().slice(start, end);
    }

    @Override
    public ABlob toBlob() {
        return LongBlob.create(this.longValue());
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    protected static void checkIndex(long i) {
        if (i < 0L || i >= 8L) {
            throw new IndexOutOfBoundsException(ErrorMessages.badIndex(i));
        }
    }

    @Override
    public Blob toFlatBlob() {
        byte[] bs = new byte[8];
        this.getBytes(bs, 0);
        return Blob.wrap(bs);
    }

    @Override
    protected ACell toCanonical() {
        return this;
    }

    @Override
    public long hexMatch(ABlobLike<?> b, long start, long length) {
        int i = 0;
        while ((long)i < length) {
            int c = b.getHexDigit(start + (long)i);
            if (c != this.getHexDigit(start + (long)i)) {
                return i;
            }
            ++i;
        }
        return length;
    }

    @Override
    public boolean equalsBytes(ABlob b) {
        if (b.count() != 8L) {
            return false;
        }
        return b.longValue() == this.longValue();
    }

    @Override
    protected int compareTo(long bvalue) {
        return Long.compareUnsigned(this.longValue(), bvalue);
    }

    @Override
    public int compareTo(ABlobLike<?> b) {
        if (b.count() == 8L) {
            return this.compareTo(b.longValue());
        }
        return -b.compareTo(this);
    }

    @Override
    public AExtensionValue empty() {
        return null;
    }

    @Override
    public final int hashCode() {
        return Bits.hash32(this.value);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    protected final long calcMemorySize() {
        return 0L;
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof AExtensionValue) {
            AExtensionValue ev = (AExtensionValue)a;
            return this.equals(ev);
        }
        return Cells.equalsGeneric(this, a);
    }

    protected boolean equals(AExtensionValue a) {
        if (this.getTag() != a.getTag()) {
            return false;
        }
        return this.longValue() == a.longValue();
    }

    @Override
    public CVMLong get(long i) {
        AExtensionValue.checkIndex(i);
        return CVMLong.create(Utils.longByteAt(this.longValue(), i));
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public ACell updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public final int getRefCount() {
        return 0;
    }

    @Override
    public InputStream getInputStream() {
        return this.toFlatBlob().getInputStream();
    }
}

