/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.cvm.RecordFormat;
import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.exceptions.InvalidDataException;

public abstract class ADenseRecord
extends ARecord<ACell, ACell> {
    protected final AVector<ACell> values;
    protected final RecordFormat format;

    protected ADenseRecord(byte tag, AVector<ACell> values, RecordFormat rf) {
        super(tag, values.count());
        this.format = rf;
        this.values = values;
    }

    @Override
    public ACell get(Keyword key) {
        Long ix = this.format.indexFor(key);
        if (ix == null) {
            return null;
        }
        return this.values.get(ix);
    }

    @Override
    public RecordFormat getFormat() {
        return this.format;
    }

    @Override
    public ADenseRecord updateRefs(IRefFunction func) {
        ACell newValues = this.values.toVector().updateRefs(func);
        return this.withValues((AVector<ACell>)newValues);
    }

    public abstract ADenseRecord withValues(AVector<ACell> var1);

    @Override
    public AVector<ACell> values() {
        return this.values;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.values.validateCell();
    }

    @Override
    public boolean equals(ACell a) {
        if (a == null) {
            return false;
        }
        if (this.tag != a.getTag()) {
            return false;
        }
        if (a instanceof ADenseRecord) {
            return this.values.equals(((ADenseRecord)a).values);
        }
        return false;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.tag;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.values.encodeRaw(bs, pos);
    }
}

