/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ACountable;
import convex.core.data.AString;
import convex.core.lang.RT;
import java.util.function.Function;

public abstract class ADataStructure<E extends ACell>
extends ACountable<E> {
    protected final long count;

    protected ADataStructure(long count) {
        this.count = count;
    }

    @Override
    public final long count() {
        return this.count;
    }

    @Override
    public final int size() {
        return (int)Math.min(this.count, Integer.MAX_VALUE);
    }

    @Override
    public abstract ADataStructure<E> empty();

    @Override
    public final boolean isEmpty() {
        return this.count == 0L;
    }

    public abstract ADataStructure<E> conj(ACell var1);

    public ADataStructure<E> conjAll(ACollection<? extends E> xs) {
        ADataStructure<E> result = this;
        for (ACell x : xs) {
            if ((result = result.conj(x)) != null) continue;
            return null;
        }
        return result;
    }

    public abstract ADataStructure<E> assoc(ACell var1, ACell var2);

    public abstract ACell get(ACell var1);

    public abstract ACell get(ACell var1, ACell var2);

    public <T extends ACell> T getIn(Object ... keys) {
        return RT.getIn((ACell)this, keys);
    }

    public <T extends ACell> T getIn(ACell ... keys) {
        return RT.getIn((ACell)this, keys);
    }

    public <T extends ACell> T getIn(Object key) {
        return (T)this.get((ACell)RT.cvm(key));
    }

    public <T extends ACell> T getIn(ACell key) {
        return (T)this.get(key);
    }

    public abstract boolean containsKey(ACell var1);

    @Override
    public AString toCVMString(long limit) {
        return this.print(limit);
    }

    public final void checkIndex(long ix) {
        if (ix >= 0L && ix < this.count) {
            return;
        }
        throw new IndexOutOfBoundsException((int)ix);
    }

    public abstract <R extends ACell> ADataStructure<R> map(Function<E, R> var1);
}

