/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AObject;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.IValidated;
import convex.core.data.IWriteable;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;

public abstract class ACell
extends AObject
implements IWriteable,
IValidated {
    protected long memorySize = -1L;
    protected Ref<ACell> cachedRef = null;

    @Override
    public void validate() throws InvalidDataException {
        Cells.validate(this);
    }

    protected abstract void validateCell() throws InvalidDataException;

    public void validateStructure() throws InvalidDataException {
    }

    public final Hash getHash() {
        return this.getEncoding().getContentHash();
    }

    public abstract byte getTag();

    protected final Hash cachedHash() {
        Hash h;
        Ref<ACell> ref = this.cachedRef;
        if (ref != null && (h = ref.cachedHash()) != null) {
            return h;
        }
        Blob enc = this.encoding;
        if (enc == null) {
            return null;
        }
        return enc.contentHash;
    }

    public int hashCode() {
        return this.getEncoding().hashCode();
    }

    public final boolean equals(Object a) {
        if (a == this) {
            return true;
        }
        if (a instanceof ACell) {
            ACell cell = (ACell)a;
            return this.equals(cell);
        }
        return false;
    }

    public abstract boolean equals(ACell var1);

    @Override
    public final Blob getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        this.encoding = this.createEncoding();
        return this.encoding;
    }

    public final <T extends ACell> T getCanonical() {
        if (this.isCanonical()) {
            return (T)this;
        }
        Ref ref = this.getRef().ensureCanonical();
        if (this.cachedRef != ref) {
            this.cachedRef = ref;
        }
        Object c = ref.getValue();
        return (T)c;
    }

    @Override
    public abstract int encode(byte[] var1, int var2);

    public abstract int encodeRaw(byte[] var1, int var2);

    @Override
    protected final Blob createEncoding() {
        byte[] bs;
        int capacity = this.estimatedEncodingSize();
        int pos = 0;
        while (true) {
            try {
                bs = new byte[capacity];
                pos = this.encode(bs, pos);
            }
            catch (IndexOutOfBoundsException be) {
                if (capacity > 16383) {
                    throw new IllegalStateException("Encoding size limit exceeded in cell: " + String.valueOf(this));
                }
                capacity = capacity * 2 + 10;
                continue;
            }
            break;
        }
        return Blob.wrap(bs, 0, pos);
    }

    public String toString() {
        try {
            return this.print().toString();
        }
        catch (Exception e) {
            return Utils.getClassName(e) + " Print failed: " + e.getMessage();
        }
    }

    public AString toCVMString(long limit) {
        BlobBuilder bb = new BlobBuilder();
        if (!this.print(bb, limit)) {
            return null;
        }
        return bb.getCVMString();
    }

    public final Blob cachedEncoding() {
        return this.encoding;
    }

    protected long calcMemorySize() {
        long result = 0L;
        int n = this.getRefCount();
        for (int i = 0; i < n; ++i) {
            Ref childRef = this.getRef(i);
            long childSize = childRef.getMemorySize();
            result = Utils.memoryAdd(result, childSize);
        }
        if (!this.isEmbedded()) {
            long encodingLength = this.getEncodingLength();
            result = Utils.memoryAdd(result, encodingLength + 64L);
        }
        return result;
    }

    public int getEncodingLength() {
        return this.getEncoding().size();
    }

    public final long getMemorySize() {
        long ms = this.memorySize;
        if (ms >= 0L) {
            return ms;
        }
        this.memorySize = ms = this.calcMemorySize();
        return ms;
    }

    public static long getMemorySize(ACell a) {
        return a == null ? 0L : a.getMemorySize();
    }

    public boolean isEmbedded() {
        if (this.memorySize == 0L) {
            return true;
        }
        if (this.cachedRef != null) {
            int flags = this.cachedRef.flags;
            if ((flags & 0x10) != 0) {
                return true;
            }
            if ((flags & 0x20) != 0) {
                return false;
            }
        } else {
            this.cachedRef = this.createRef();
        }
        boolean embedded = this.getEncodingLength() <= 140;
        this.cachedRef.flags = this.cachedRef.flags | (embedded ? 16 : 32);
        return embedded;
    }

    public abstract boolean isCanonical();

    protected abstract ACell toCanonical();

    public abstract boolean isCVMValue();

    public final <R extends ACell> Ref<R> getRef() {
        if (this.cachedRef != null) {
            return this.cachedRef;
        }
        Ref<R> newRef = this.createRef();
        this.cachedRef = newRef;
        return newRef;
    }

    protected <R extends ACell> Ref<R> createRef() {
        RefDirect<ACell> newRef = RefDirect.create(this);
        this.cachedRef = newRef;
        return newRef;
    }

    public int getRefCount() {
        Object canonical = this.getCanonical();
        assert (canonical != this) : "Canonical getRefCount not implemented: " + String.valueOf(this.getClass());
        return ((ACell)canonical).getRefCount();
    }

    public int getBranchCount() {
        Object c = this.getCanonical();
        int rc = ((ACell)c).getRefCount();
        int result = 0;
        for (int i = 0; i < rc; ++i) {
            Ref r = ((ACell)c).getRef(i);
            if (r.isEmbedded()) {
                result += r.branchCount();
                continue;
            }
            ++result;
        }
        return result;
    }

    public <T extends ACell> Ref<T> getBranchRef(int index) {
        T c = this.getCanonical();
        int rc = ((ACell)c).getRefCount();
        for (int i = 0; i < rc; ++i) {
            Ref r = ((ACell)c).getRef(i);
            if (r.isEmbedded()) {
                Object child = r.getValue();
                if (child == null) continue;
                int cbc = ((ACell)child).getBranchCount();
                if (cbc > index) {
                    return ((ACell)child).getBranchRef(index);
                }
                index -= cbc;
                continue;
            }
            if (index == 0) {
                return r;
            }
            --index;
        }
        return null;
    }

    public <R extends ACell> Ref<R> getRef(int i) {
        Object canonical = this.getCanonical();
        assert (canonical != this) : "Canonical getRef not implemented: " + String.valueOf(this.getClass());
        return ((ACell)this.getCanonical()).getRef(i);
    }

    public ACell updateRefs(IRefFunction func) {
        Object canonical = this.getCanonical();
        assert (canonical != this) : "Canonical updateRefs not implemented: " + String.valueOf(this.getClass());
        return ((ACell)canonical).updateRefs(func);
    }

    public <R extends ACell> Ref<R>[] getChildRefs() {
        int n = this.getRefCount();
        Ref[] refs = new Ref[n];
        for (int i = 0; i < n; ++i) {
            refs[i] = this.getRef(i);
        }
        return refs;
    }

    public AType getType() {
        return Types.ANY;
    }

    public void attachMemorySize(long memorySize) {
        if (this.memorySize < 0L) {
            this.memorySize = memorySize;
            assert (this.memorySize > 0L) : "Attempting to attach memory size " + memorySize + " to object of class " + Utils.getClassName(this);
        } else assert (this.memorySize == memorySize) : "Trying to change memory size to " + memorySize + " with object of class " + Utils.getClassName(this) + " which already has memorySize " + this.memorySize;
    }

    public void attachRef(Ref<?> ref) {
        Ref<ACell> current = this.cachedRef;
        if (current != null && ref.getStatus() <= current.getStatus()) {
            return;
        }
        this.cachedRef = ref;
    }

    boolean isCompletelyEncoded() {
        if (this.memorySize == 0L) {
            return true;
        }
        int n = this.getRefCount();
        for (int i = 0; i < n; ++i) {
            Ref r = this.getRef(i);
            if (!r.isEmbedded()) {
                return false;
            }
            Object child = r.getValue();
            if (child == null || ((ACell)child).isCompletelyEncoded()) continue;
            return false;
        }
        return true;
    }
}

