/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ARecord;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Tag;
import convex.core.data.prim.CVMLong;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;

public abstract class ACAD3Record
extends ARecord<CVMLong, ACell> {
    protected ACAD3Record(byte tag, long count) {
        super(tag, count);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        byte cat = Tag.category(this.tag);
        switch (cat) {
            case -96: 
            case -48: {
                break;
            }
            default: {
                throw new InvalidDataException("Bad tag for CAD3 Record: 0x" + Utils.toHexString(this.tag), this);
            }
        }
    }

    @Override
    public void validateStructure() throws InvalidDataException {
        super.validateStructure();
    }

    @Override
    public boolean equals(ACell a) {
        if (a == null) {
            return false;
        }
        if (a.getTag() != this.tag) {
            return false;
        }
        return this.getEncoding().equals(a.getEncoding());
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.tag;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public abstract int getRefCount();

    public abstract Ref<ACell> getRef(int var1);

    @Override
    public abstract ACell updateRefs(IRefFunction var1);

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    protected ARecord<CVMLong, ACell> toCanonical() {
        return this;
    }

    @Override
    public boolean isCVMValue() {
        return false;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return RT.printCAD3(sb, limit, this);
    }
}

