/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.crypto.Hashing;
import convex.core.data.ABlob;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.BlobTree;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;

public abstract class AArrayBlob
extends ABlob {
    protected final byte[] store;
    protected final int offset;
    protected Hash contentHash = null;

    protected AArrayBlob(byte[] bytes, int offset, int length) {
        super(length);
        this.store = bytes;
        this.offset = offset;
    }

    @Override
    public final Hash getContentHash() {
        if (this.contentHash == null) {
            this.contentHash = this.computeHash(Hashing.getDigest());
        }
        return this.contentHash;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.store, this.offset, (int)this.count);
    }

    @Override
    public Blob slice(long start, long end) {
        if (start < 0L) {
            return null;
        }
        if (end > this.count) {
            return null;
        }
        long length = end - start;
        if (length < 0L) {
            return null;
        }
        int size = (int)length;
        if (length == this.count) {
            return this.toFlatBlob();
        }
        return Blob.wrap(this.store, Utils.checkedInt(start + (long)this.offset), size);
    }

    @Override
    public ABlob append(ABlob d) {
        long dlength = d.count();
        if (dlength == 0L) {
            return this;
        }
        long length = this.count;
        if (length == 0L) {
            return d;
        }
        if (length > 4096L) {
            return BlobTree.create(this).append(d);
        }
        long newLen = length + dlength;
        if (newLen <= 4096L) {
            return this.appendSmall(d);
        }
        if (newLen <= 8192L) {
            long split = 4096L - length;
            return BlobTree.create(this.append(d.slice(0L, split)).toFlatBlob(), d.slice(split, dlength).toFlatBlob());
        }
        BlobBuilder bb = new BlobBuilder(this);
        bb.append(d);
        return bb.toBlob();
    }

    protected ABlob appendSmall(ABlob d) {
        int n = Utils.checkedInt(this.count() + d.count());
        if (n > 4096) {
            throw new IllegalStateException("Illegal Blob appendSmall size: " + n);
        }
        byte[] newData = new byte[n];
        this.getBytes(newData, 0);
        d.getBytes(newData, (int)this.count);
        return Blob.wrap(newData);
    }

    @Override
    public Blob toFlatBlob() {
        return Blob.wrap(this.store, this.offset, (int)this.count);
    }

    @Override
    public final int compareTo(ABlobLike<?> b) {
        if (b instanceof AArrayBlob) {
            return this.compareTo((AArrayBlob)b);
        }
        return -b.compareTo(this);
    }

    @Override
    public final int compareTo(AArrayBlob b) {
        if (this == b) {
            return 0;
        }
        int alength = (int)this.count;
        int blength = (int)b.count;
        int compareLength = Math.min(alength, blength);
        int c = Utils.compareByteArrays(this.store, this.offset, b.store, b.offset, compareLength);
        if (c != 0) {
            return c;
        }
        if (alength > compareLength) {
            return 1;
        }
        if (blength > compareLength) {
            return -1;
        }
        return 0;
    }

    @Override
    public final int getBytes(byte[] dest, int pos) {
        System.arraycopy(this.store, this.offset, dest, pos, (int)this.count);
        return (int)((long)pos + this.count);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLQCount(bs, pos, this.count);
        return this.getBytes(bs, pos);
    }

    @Override
    public final boolean appendHex(BlobBuilder bb, long hexLength) {
        if (hexLength < 0L) {
            return false;
        }
        long nbytes = Math.min(hexLength / 2L, this.count);
        for (long i = 0L; i < nbytes; ++i) {
            byte b = this.byteAt(i);
            bb.appendHexByte(b);
        }
        return nbytes == this.count;
    }

    @Override
    public boolean isChunkPacked() {
        return this.count == 0L || this.count == 4096L;
    }

    @Override
    public boolean isFullyPacked() {
        return this.count == 4096L;
    }

    @Override
    protected long calcMemorySize() {
        if (this.isEmbedded()) {
            return 0L;
        }
        return super.calcMemorySize();
    }

    @Override
    public final byte byteAt(long i) {
        int ix = (int)i;
        if ((long)ix != i || ix < 0 || (long)ix >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.store[this.offset + ix];
    }

    @Override
    public final short shortAt(long i) {
        int ix = (int)i;
        if ((long)ix != i || ix < 0 || (long)(ix + 1) >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return (short)(this.store[ix += this.offset] << 8 | this.store[ix + 1] & 0xFF);
    }

    public long longAt(long i) {
        int ix = (int)i;
        if ((long)ix != i || ix < 0 || (long)(ix + 7) >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        long val = Utils.readLong(this.store, this.offset + ix, 8);
        return val;
    }

    @Override
    public final byte byteAtUnchecked(long i) {
        int ix = (int)i;
        return this.store[this.offset + ix];
    }

    @Override
    public int getHexDigit(long digitPos) {
        byte b = this.store[this.offset + (int)(digitPos >> 1)];
        int shift = 4 - (((int)digitPos & 1) << 2);
        return b >> shift & 0xF;
    }

    public final byte[] getInternalArray() {
        return this.store;
    }

    public final int getInternalOffset() {
        return this.offset;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        if (this.offset == 0) {
            return ByteBuffer.wrap(this.store, this.offset, (int)this.count);
        }
        return ByteBuffer.wrap(this.getBytes());
    }

    @Override
    public boolean equals(ABlob o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.count() != this.count) {
            return false;
        }
        return o.equalsBytes(this.store, this.offset);
    }

    public boolean equals(AArrayBlob other) {
        if (other == this) {
            return true;
        }
        if (this.count != other.count) {
            return false;
        }
        if (this.contentHash != null && other.contentHash != null && this.contentHash.equals(other.contentHash)) {
            return true;
        }
        return Utils.arrayEquals(other.store, other.offset, this.store, this.offset, this.size());
    }

    @Override
    public boolean equalsBytes(byte[] bytes, long byteOffset) {
        return Utils.arrayEquals(this.store, this.offset, bytes, Utils.checkedInt(byteOffset), (int)this.count);
    }

    @Override
    public boolean equalsBytes(ABlob k) {
        if (k.count() != this.count()) {
            return false;
        }
        return k.equalsBytes(this.store, this.offset);
    }

    public boolean rangeMatches(ABlob b, int start, int end) {
        if (b instanceof AArrayBlob) {
            return this.rangeMatches((AArrayBlob)b, start, end);
        }
        for (int i = start; i < end; ++i) {
            if (this.store[this.offset + i] == b.byteAtUnchecked(i)) continue;
            return false;
        }
        return true;
    }

    public boolean rangeMatches(AArrayBlob b, int start, int end) {
        return Arrays.equals(this.store, this.offset + start, this.offset + end, b.store, b.offset + start, b.offset + end);
    }

    @Override
    public long hexMatch(ABlobLike<?> b, long start, long length) {
        if (b == this) {
            return length;
        }
        long end = start + length;
        for (long i = start; i < end; ++i) {
            if (this.getHexDigit(i) == b.getHexDigit(i)) continue;
            return i - start;
        }
        return length;
    }

    public boolean hexMatches(ABlob key, int start, int end) {
        if (key == this) {
            return true;
        }
        if (start == end) {
            return true;
        }
        if ((start & 1) != 0 && key.getHexDigit(start) != this.getHexDigit(start)) {
            return false;
        }
        if ((end & 1) != 0 && key.getHexDigit(end - 1) != this.getHexDigit(end - 1)) {
            return false;
        }
        return this.rangeMatches(key, start + 1 >> 1, end >> 1);
    }

    @Override
    public long hexMatch(ABlobLike<?> b) {
        if (b == this) {
            return this.count() * 2L;
        }
        if (b instanceof AArrayBlob) {
            return this.commonHexPrefixLength((AArrayBlob)b, (int)this.count * 2);
        }
        long max = Math.min(this.count(), b.count());
        for (long i = 0L; i < max; ++i) {
            byte bi;
            byte ai = this.byteAtUnchecked(i);
            if (ai == (bi = b.byteAtUnchecked(i))) continue;
            return i * 2L + (long)(Utils.firstDigitMatch(ai, bi) ? 1 : 0);
        }
        return max * 2L;
    }

    public int commonHexPrefixLength(AArrayBlob b, int max) {
        byte bi;
        max = Math.min(max, (int)this.count * 2);
        int blen = ((max = Math.min(max, (int)b.count * 2)) + 1) / 2;
        int ix = Arrays.mismatch(this.store, this.offset, this.offset + blen, b.store, b.offset, b.offset + blen);
        if (ix < 0) {
            return max;
        }
        byte ai = this.byteAtUnchecked(ix);
        if (Utils.firstDigitMatch(ai, bi = b.byteAtUnchecked(ix))) {
            return ix * 2 + 1;
        }
        return ix * 2;
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.count < 0L) {
            throw new InvalidDataException("Negative length: " + this.count, this);
        }
        if (this.offset < 0) {
            throw new InvalidDataException("Negative data offset: " + this.offset, this);
        }
        if ((long)this.offset + this.count > (long)this.store.length) {
            throw new InvalidDataException("End out of range: " + ((long)this.offset + this.count) + " with array size=" + this.store.length, this);
        }
    }

    @Override
    public void validateStructure() throws InvalidDataException {
        super.validateStructure();
    }

    @Override
    public long longValue() {
        if (this.count == 0L) {
            return 0L;
        }
        if (this.count >= 8L) {
            return Utils.readLong(this.store, (int)((long)this.offset + this.count - 8L), 8);
        }
        return Utils.readLong(this.store, this.offset, (int)this.count);
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (this.count > 4096L) {
            return super.getRef(i);
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public ACell updateRefs(IRefFunction func) {
        if (this.count > 4096L) {
            return super.updateRefs(func);
        }
        return this;
    }

    @Override
    public int getRefCount() {
        if (this.count > 4096L) {
            return super.getRefCount();
        }
        return 0;
    }

    @Override
    public int toByteBuffer(long offset, long count, ByteBuffer dest) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count");
        }
        if (offset < 0L || offset + count > this.count) {
            throw new IllegalArgumentException("Out of range in toByteBuffer");
        }
        int n = (int)count;
        dest.put(this.store, (int)((long)this.offset + offset), n);
        return n;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.store, this.offset, this.size());
    }
}

