/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.transactions;

import convex.core.Coin;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Keyword;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;

public class Call
extends ATransaction {
    public static final long DEFAULT_OFFER = 0L;
    protected final ACell target;
    protected final long offer;
    protected final Symbol functionName;
    protected AVector<ACell> args;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.ORIGIN, Keywords.SEQUENCE, Keywords.TARGET, Keywords.OFFER, Keywords.CALL, Keywords.ARGS};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);

    protected Call(AVector<ACell> values) {
        super((byte)-46, FORMAT, values);
        this.target = values.get(2);
        this.offer = RT.ensureLong((ACell)values.get(3)).longValue();
        this.functionName = RT.ensureSymbol((ACell)values.get(4));
    }

    protected Call(Address origin, long sequence, ACell target, long offer, Symbol functionName, AVector<ACell> args) {
        super((byte)-46, FORMAT, Vectors.create(origin, CVMLong.create(sequence), target, CVMLong.create(offer), functionName, args));
        this.target = target;
        this.functionName = functionName;
        this.offer = offer;
        this.args = args;
    }

    public static Call create(Address address, long sequence, ACell target, long offer, Symbol functionName, AVector<ACell> args) {
        return new Call(address, sequence, target, offer, functionName, args);
    }

    public static Call create(Address address, long sequence, ACell target, Symbol functionName, AVector<ACell> args) {
        return Call.create(address, sequence, target, 0L, functionName, args);
    }

    public static Call create(AVector<ACell> values) {
        return new Call(values);
    }

    public static Call read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        if (values.count() != (long)KEYS.length) {
            throw new BadFormatException("Wrong number of record values");
        }
        Call result = new Call(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return 100;
    }

    @Override
    public Context apply(Context ctx) {
        return ctx.actorCall(this.target, this.offer, this.functionName, this.args.toCellArray());
    }

    @Override
    public void validateCell() throws InvalidDataException {
        super.validateCell();
        if (!Coin.isValidAmount(this.offer)) {
            throw new InvalidDataException("Invalid offer", this);
        }
    }

    @Override
    public Call withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Call.create(this.origin, newSequence, this.target, this.offer, this.functionName, this.args);
    }

    @Override
    public Call withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return Call.create(newAddress, this.sequence, this.target, this.offer, this.functionName, this.args);
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.CALL.equals(key)) {
            return this.functionName;
        }
        if (Keywords.OFFER.equals(key)) {
            return this.values.get(3);
        }
        if (Keywords.TARGET.equals(key)) {
            return this.target;
        }
        if (Keywords.ARGS.equals(key)) {
            return this.getArgs();
        }
        return super.get(key);
    }

    private ACell getArgs() {
        if (this.args == null) {
            this.args = RT.ensureVector((ACell)this.values.get(5));
        }
        return this.args;
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Call(this.values);
    }
}

