/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.transactions;

import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Cells;
import convex.core.data.Keyword;
import convex.core.data.type.AType;
import convex.core.data.type.Transaction;
import convex.core.lang.RT;

public abstract class ATransaction
extends ARecordGeneric {
    public static final long UNKNOWN_SEQUENCE = 0L;
    protected final Address origin;
    protected final long sequence;
    protected static final int IX_ORIGIN = 0;
    protected static final int IX_SEQUENCE = 1;

    protected ATransaction(byte tag, RecordFormat format, AVector<ACell> values) {
        super(tag, format, values);
        this.origin = RT.ensureAddress((ACell)values.get(0));
        if (this.origin == null) {
            throw new IllegalArgumentException("Null Origin Address for transaction");
        }
        this.sequence = RT.ensureLong((ACell)values.get(1)).longValue();
    }

    public abstract Context apply(Context var1);

    public Address getOrigin() {
        return this.origin;
    }

    public final long getSequence() {
        return this.sequence;
    }

    @Override
    public AType getType() {
        return Transaction.INSTANCE;
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.ORIGIN.equals(key)) {
            return this.origin;
        }
        if (Keywords.SEQUENCE.equals(key)) {
            return this.values.get(1);
        }
        return null;
    }

    public abstract ATransaction withSequence(long var1);

    public abstract ATransaction withOrigin(Address var1);

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean equals(ACell o) {
        return Cells.equalsGeneric(this, o);
    }
}

