/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.exception.AExceptional;
import convex.core.cvm.ops.ACodedOp;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.Vectors;
import convex.core.data.prim.ByteFlag;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;

public class Try<T extends ACell>
extends ACodedOp<T, ACell, AVector<AOp<ACell>>> {
    private static final Ref<ACell> CODE = new ByteFlag(-70).getRef();
    public static final Try<?> EMPTY = Try.create(new AOp[0]);

    protected Try(Ref<ACell> code, Ref<AVector<AOp<ACell>>> ops) {
        super((byte)-64, code, ops);
    }

    protected Try(Ref<AVector<AOp<ACell>>> ops) {
        this(CODE, ops);
    }

    public static <T extends ACell> Try<T> create(AOp<?> ... ops) {
        if (ops.length == 0) {
            return EMPTY;
        }
        return new Try<T>(Vectors.create((ACell[])ops).getRef());
    }

    @Override
    protected Try<T> rebuild(Ref<ACell> newCode, Ref<AVector<AOp<ACell>>> newOps) {
        if (this.code == newCode && this.value == newOps) {
            return this;
        }
        return new Try<T>(newCode, newOps);
    }

    public static <T extends ACell> Try<T> create(ASequence<AOp<ACell>> ops) {
        return new Try<T>(ops.toVector().getRef());
    }

    @Override
    public Context execute(Context context) {
        AVector ops = (AVector)this.value.getValue();
        int n = ops.size();
        if (n == 0) {
            return context.withResult(50L, null);
        }
        Context ctx = context;
        for (int i = 0; i < n; ++i) {
            AExceptional ex;
            ctx = context.consumeJuice(50L);
            if (ctx.isExceptional()) {
                return ctx;
            }
            AOp op = (AOp)ops.get(i);
            Context fctx = ctx.fork();
            if ((fctx = fctx.execute(op)).isExceptional()) {
                ex = fctx.getExceptional();
                if (!ex.isCatchable()) {
                    return fctx;
                }
                if (i + 1 >= n) {
                    return fctx;
                }
            } else {
                return fctx;
            }
            ctx = ctx.withResult(ex.getCode());
            ctx = ctx.withJuice(fctx.getJuiceUsed());
        }
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        AVector ops = (AVector)this.value.getValue();
        bb.append("(try");
        int len = ops.size();
        for (int i = 0; i < len; ++i) {
            bb.append(' ');
            if (((AOp)ops.get(i)).print(bb, limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    public static <T extends ACell> Try<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        Ref<AVector<AOp<ACell>>> ops = Format.readRef(b, epos);
        epos = (int)((long)epos + ops.getEncodingLength());
        Try<T> result = new Try<T>(CODE, ops);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }
}

