/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.Symbols;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Bits;
import convex.core.util.Utils;
import java.util.HashMap;

public class Special<T extends ACell>
extends AOp<T> {
    private final byte specialCode;
    public static final int NUM_SPECIALS = 25;
    public static final int BASE = 0;
    private static final int LIMIT = 25;
    public static final Symbol[] SYMBOLS = new Symbol[25];
    private static final Special<?>[] specials = new Special[25];
    private static final HashMap<Symbol, Integer> opcodes = new HashMap();
    private static final byte S_JUICE = 0;
    private static final byte S_CALLER = 1;
    private static final byte S_ADDRESS = 2;
    private static final byte S_MEMORY = 3;
    private static final byte S_BALANCE = 4;
    private static final byte S_ORIGIN = 5;
    private static final byte S_RESULT = 6;
    private static final byte S_TIMESTAMP = 7;
    private static final byte S_DEPTH = 8;
    private static final byte S_OFFER = 9;
    private static final byte S_STATE = 10;
    private static final byte S_HOLDINGS = 11;
    private static final byte S_SEQUENCE = 12;
    private static final byte S_KEY = 13;
    private static final byte S_JUICE_PRICE = 14;
    private static final byte S_SCOPE = 15;
    private static final byte S_JUICE_LIMIT = 16;
    private static final byte S_CONTROLLER = 17;
    private static final byte S_ENV = 18;
    private static final byte S_PARENT = 19;
    private static final byte S_NOP = 20;
    private static final byte S_MEMORY_PRICE = 21;
    private static final byte S_SIGNER = 22;
    private static final byte S_PEER = 23;
    private static final byte S_LOCATION = 24;

    private static byte reg(byte opCode, Symbol sym) {
        int i = opCode - 0;
        Special.SYMBOLS[i] = sym;
        Special special = new Special(opCode);
        Special.specials[i] = special;
        opcodes.put(sym, Integer.valueOf(opCode));
        return opCode;
    }

    private Special(byte specialCode) {
        this.specialCode = specialCode;
    }

    public static final Special<?> create(int opCode) {
        if (opCode < 0 || opCode > 25) {
            return null;
        }
        return specials[opCode - 0];
    }

    @Override
    public Context execute(Context ctx) {
        switch (this.specialCode) {
            case 0: {
                ctx = ctx.withResult(CVMLong.create(ctx.getJuiceUsed()));
                break;
            }
            case 1: {
                ctx = ctx.withResult(ctx.getCaller());
                break;
            }
            case 2: {
                ctx = ctx.withResult(ctx.getAddress());
                break;
            }
            case 3: {
                ctx = ctx.withResult(CVMLong.create(ctx.getAccountStatus().getMemory()));
                break;
            }
            case 4: {
                ctx = ctx.withResult(CVMLong.create(ctx.getBalance()));
                break;
            }
            case 5: {
                ctx = ctx.withResult(ctx.getOrigin());
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                ctx = ctx.withResult(ctx.getState().getTimestamp());
                break;
            }
            case 8: {
                ctx = ctx.withResult(CVMLong.create(ctx.getDepth() - 1));
                break;
            }
            case 9: {
                ctx = ctx.withResult(CVMLong.create(ctx.getOffer()));
                break;
            }
            case 10: {
                ctx = ctx.withResult(ctx.getState());
                break;
            }
            case 11: {
                ctx = ctx.withResult(ctx.getHoldings());
                break;
            }
            case 12: {
                ctx = ctx.withResult(CVMLong.create(ctx.getAccountStatus().getSequence()));
                break;
            }
            case 13: {
                ctx = ctx.withResult(ctx.getAccountStatus().getAccountKey());
                break;
            }
            case 14: {
                ctx = ctx.withResult(ctx.getState().getJuicePrice());
                break;
            }
            case 16: {
                ctx = ctx.withResult(CVMLong.create(ctx.getJuiceLimit()));
                break;
            }
            case 15: {
                ctx = ctx.withResult(ctx.getScope());
                break;
            }
            case 17: {
                ctx = ctx.withResult(ctx.getAccountStatus().getController());
                break;
            }
            case 18: {
                ctx = ctx.withResult(ctx.getEnvironment());
                break;
            }
            case 19: {
                ctx = ctx.withResult(ctx.getAccountStatus().getParent());
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                ctx = ctx.withResult(CVMDouble.create(ctx.getState().getMemoryPrice()));
                break;
            }
            case 22: {
                ctx = ctx.withResult(ctx.getSigner());
                break;
            }
            case 23: {
                ctx = ctx.withResult(ctx.getPeer());
                break;
            }
            case 24: {
                ctx = ctx.withResult(ctx.getLocation());
                break;
            }
            default: {
                throw new Error("Bad Opcode" + this.specialCode);
            }
        }
        return ctx.consumeJuice(10L);
    }

    @Override
    public byte getTag() {
        return -27;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLQCount(bs, pos, this.specialCode);
        return pos;
    }

    @Override
    public int encodeAfterOpcode(byte[] bs, int pos) {
        throw new Error("Should be unreachable");
    }

    @Override
    public Special<T> updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.specialCode < 0 || this.specialCode >= 25) {
            throw new InvalidDataException("Invalid Special opCode " + this.specialCode, this);
        }
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        return SYMBOLS[this.specialCode - 0].print(bb, limit);
    }

    public static <R extends ACell> Special<R> forSymbol(Symbol sym) {
        Integer special = opcodes.get(sym);
        if (special == null) {
            return null;
        }
        return specials[special - 0];
    }

    public static <R extends ACell> Special<R> get(String string) {
        return Special.forSymbol(Symbol.create(string));
    }

    @Override
    public final int hashCode() {
        return Bits.hash32(this.specialCode);
    }

    public static <T extends ACell> AOp<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        byte scode = b.byteAt(epos);
        Special<?> special = Special.create(scode);
        if (special == null) {
            throw new BadFormatException("Bad OpCode for Special value: " + Utils.toHexString(scode));
        }
        return special;
    }

    static {
        Special.reg((byte)0, Symbols.STAR_JUICE);
        Special.reg((byte)1, Symbols.STAR_CALLER);
        Special.reg((byte)2, Symbols.STAR_ADDRESS);
        Special.reg((byte)3, Symbols.STAR_MEMORY);
        Special.reg((byte)4, Symbols.STAR_BALANCE);
        Special.reg((byte)5, Symbols.STAR_ORIGIN);
        Special.reg((byte)6, Symbols.STAR_RESULT);
        Special.reg((byte)7, Symbols.STAR_TIMESTAMP);
        Special.reg((byte)8, Symbols.STAR_DEPTH);
        Special.reg((byte)9, Symbols.STAR_OFFER);
        Special.reg((byte)10, Symbols.STAR_STATE);
        Special.reg((byte)11, Symbols.STAR_HOLDINGS);
        Special.reg((byte)12, Symbols.STAR_SEQUENCE);
        Special.reg((byte)13, Symbols.STAR_KEY);
        Special.reg((byte)14, Symbols.STAR_JUICE_PRICE);
        Special.reg((byte)15, Symbols.STAR_SCOPE);
        Special.reg((byte)16, Symbols.STAR_JUICE_LIMIT);
        Special.reg((byte)17, Symbols.STAR_CONTROLLER);
        Special.reg((byte)18, Symbols.STAR_ENV);
        Special.reg((byte)19, Symbols.STAR_PARENT);
        Special.reg((byte)20, Symbols.STAR_NOP);
        Special.reg((byte)21, Symbols.STAR_MEMORY_PRICE);
        Special.reg((byte)22, Symbols.STAR_SIGNER);
        Special.reg((byte)23, Symbols.STAR_PEER);
        Special.reg((byte)24, Symbols.STAR_LOCATION);
    }
}

