/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.ErrorCodes;
import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.Ops;
import convex.core.cvm.ops.ACodedOp;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.prim.CVMLong;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;

public class Set<T extends ACell>
extends ACodedOp<T, CVMLong, AOp<T>> {
    private final long position;

    public Set(Ref<CVMLong> code, Ref<AOp<T>> value) {
        super((byte)-64, code, value);
        this.position = code.getValue().longValue();
    }

    private Set(long position, Ref<AOp<T>> op) {
        this(CVMLong.create(position).getRef(), op);
    }

    public static final <R extends ACell> Set<R> create(long position, AOp<R> op) {
        if (position < 0L) {
            return null;
        }
        return new Set(position, op.getRef());
    }

    @Override
    public Context execute(Context ctx) {
        AVector<ACell> env = ctx.getLocalBindings();
        long ec = env.count();
        if (this.position < 0L || this.position >= ec) {
            return ctx.withError(ErrorCodes.BOUNDS, "Bad position for set!: " + this.position);
        }
        if ((ctx = ctx.execute(Ops.castOp(this.value.getValue()))).isExceptional()) {
            return ctx;
        }
        Object value = ctx.getResult();
        ASequence newEnv = env.assoc(this.position, (ACell)value);
        ctx = ctx.withLocalBindings((AVector<ACell>)newEnv);
        return ctx.consumeJuice(20L);
    }

    public static <R extends ACell> Set<R> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Ref<CVMLong> index = Format.readRef(b, epos);
        epos = (int)((long)epos + index.getEncodingLength());
        Ref op = Format.readRef(b, epos);
        epos = (int)((long)epos + op.getEncodingLength());
        Set result = new Set(index, op);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.position < 0L) {
            throw new InvalidDataException("Invalid Local position " + this.position, this);
        }
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("(set! %");
        sb.append(Long.toString(this.position));
        sb.append(' ');
        AOp op = Ops.castOp(this.value.getValue());
        if (!op.print(sb, limit)) {
            return false;
        }
        sb.append(')');
        return sb.check(limit);
    }

    @Override
    protected AOp<T> rebuild(Ref<CVMLong> newCode, Ref<AOp<T>> newValue) {
        if (newCode == this.code && newValue == this.value) {
            return this;
        }
        return new Set<T>(newCode, newValue);
    }
}

