/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.Ops;
import convex.core.cvm.ops.AFlatMultiOp;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Vectors;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;

public class Do<T extends ACell>
extends AFlatMultiOp<T> {
    public static final Do<?> EMPTY = Do.create(new AOp[0]);

    protected Do(AVector<AOp<ACell>> ops) {
        super((byte)-38, ops);
    }

    public static <T extends ACell> Do<T> create(AOp<?> ... ops) {
        return new Do<T>(Vectors.create((ACell[])ops));
    }

    public static <T extends ACell> Do<T> create(ASequence<AOp<ACell>> ops) {
        return new Do<T>(ops.toVector());
    }

    @Override
    public Context execute(Context context) {
        AOp op;
        int n = this.ops.size();
        if (n == 0) {
            return context.withResult(5L, null);
        }
        Context ctx = context.consumeJuice(5L);
        if (ctx.isExceptional()) {
            return ctx;
        }
        for (int i = 0; i < n && !(ctx = ctx.execute(op = Ops.castOp((ACell)this.ops.get(i)))).isExceptional(); ++i) {
        }
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("(do");
        int len = this.ops.size();
        for (int i = 0; i < len; ++i) {
            bb.append(' ');
            if (RT.print(bb, (ACell)this.ops.get(i), limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    public static <T extends ACell> Do<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos;
        AVector<AOp<ACell>> ops = Vectors.read(b, epos);
        Do<T> result = Do.create(ops);
        result.attachEncoding(b.slice(pos, epos += Cells.getEncodingLength(ops)));
        return result;
    }

    @Override
    protected AFlatMultiOp<T> recreate(AVector<AOp<ACell>> newOps) {
        if (newOps == this.ops) {
            return this;
        }
        return new Do<T>(newOps);
    }
}

