/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.Ops;
import convex.core.cvm.ops.AFlatMultiOp;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Vectors;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;

public class Cond<T extends ACell>
extends AFlatMultiOp<T> {
    protected Cond(AVector<AOp<ACell>> ops) {
        super((byte)-36, ops);
    }

    public static <T extends ACell> Cond<T> create(AOp<?> ... ops) {
        AVector<AOp<ACell>> refOps = Vectors.create((ACell[])ops);
        return Cond.create(refOps);
    }

    @Override
    protected Cond<T> recreate(AVector<AOp<ACell>> newOps) {
        if (this.ops == newOps) {
            return this;
        }
        return new Cond<T>(newOps);
    }

    public static <T extends ACell> Cond<T> create(ASequence<AOp<ACell>> ops) {
        return new Cond<T>(ops.toVector());
    }

    @Override
    public Context execute(Context context) {
        int n = this.ops.size();
        Context ctx = context.consumeJuice(20L);
        if (ctx.isExceptional()) {
            return ctx;
        }
        for (int i = 0; i < n - 1; i += 2) {
            AOp testOp = Ops.castOp((ACell)this.ops.get(i));
            if ((ctx = ctx.execute(testOp)).isExceptional()) {
                return ctx;
            }
            Object test = ctx.getResult();
            if (!RT.bool(test)) continue;
            return ctx.execute(Ops.castOp((ACell)this.ops.get(i + 1)));
        }
        if ((n & 1) == 0) {
            return ctx.withResult(null);
        }
        return ctx.execute(Ops.castOp((ACell)this.ops.get(n - 1)));
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("(cond");
        int len = this.ops.size();
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
            if (RT.print(sb, (ACell)this.ops.get(i), limit)) continue;
            return false;
        }
        sb.append(')');
        return sb.check(limit);
    }

    public static <T extends ACell> Cond<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos;
        AVector<AOp<ACell>> ops = Vectors.read(b, epos);
        Cond<T> result = Cond.create(ops);
        result.attachEncoding(b.slice(pos, epos += Cells.getEncodingLength(ops)));
        return result;
    }
}

